/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBasedRepositoryMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="retarget-deploy", defaultPhase=LifecyclePhase.VALIDATE)
public class RetargetDeployMojo
extends AbstractGitflowBasedRepositoryMojo {
    protected void execute(GitBranchType type, String gitBranch, String branchPattern) throws MojoExecutionException, MojoFailureException {
        if (this.project.getDistributionManagement() == null) {
            this.project.setDistributionManagement(new DistributionManagement());
        }
        switch (type) {
            case MASTER: {
                this.getLog().info((CharSequence)("Setting release artifact repository to: [" + this.releaseDeploymentRepository + "]"));
                this.project.setSnapshotArtifactRepository(null);
                this.project.setReleaseArtifactRepository(this.getDeploymentRepository(this.releaseDeploymentRepository));
                break;
            }
            case RELEASE: {
                this.getLog().info((CharSequence)("Setting release artifact repository to: [" + this.stageDeploymentRepository + "]"));
                this.project.setSnapshotArtifactRepository(null);
                this.project.setReleaseArtifactRepository(this.getDeploymentRepository(this.stageDeploymentRepository));
                break;
            }
            case HOTFIX: {
                this.getLog().info((CharSequence)("Setting release artifact repository to: [" + this.stageDeploymentRepository + "]"));
                this.project.setSnapshotArtifactRepository(null);
                this.project.setReleaseArtifactRepository(this.getDeploymentRepository(this.stageDeploymentRepository));
                break;
            }
            case DEVELOPMENT: {
                this.getLog().info((CharSequence)("Setting snapshot artifact repository to: [" + this.snapshotDeploymentRepository + "]"));
                this.project.setSnapshotArtifactRepository(this.getDeploymentRepository(this.snapshotDeploymentRepository));
                this.project.setReleaseArtifactRepository(null);
                break;
            }
            default: {
                this.getLog().info((CharSequence)"Un-Setting artifact repositories.");
                this.project.setSnapshotArtifactRepository(null);
                this.project.setReleaseArtifactRepository(null);
                this.project.getProperties().put("maven.deploy.skip", "true");
                this.getLog().info((CharSequence)"Setting maven.deploy.skip = 'true'");
            }
        }
    }
}

