/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.properties.PropertyResolver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="promote-master")
public class MasterPromoteExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private Logger logger;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Properties systemEnvVars = null;
        try {
            systemEnvVars = CommandLineUtils.getSystemEnvVars();
        }
        catch (IOException ioe) {
            throw new MavenExecutionException("Unable to read System Envirionment Variables: ", (Throwable)ioe);
        }
        String masterBranchPattern = null;
        String gitBranchExpression = null;
        boolean pluginFound = false;
        HashMap pluginsToDrop = new HashMap();
        for (MavenProject project : session.getProjects()) {
            ArrayList<Plugin> dropPlugins = new ArrayList<Plugin>();
            for (Plugin plugin : project.getBuildPlugins()) {
                if (plugin.getKey().equals("com.e-gineering:gitflow-helper-maven-plugin")) {
                    pluginFound = true;
                    this.logger.debug("gitflow-helper-maven-plugin found in project: [" + project.getName() + "]");
                    if (masterBranchPattern == null) {
                        masterBranchPattern = this.extractPluginConfigValue("masterBranchPattern", plugin);
                    }
                    if (gitBranchExpression != null) continue;
                    gitBranchExpression = this.extractPluginConfigValue("gitBranchExpression", plugin);
                    continue;
                }
                if (plugin.getKey().equals("org.apache.maven.plugins:maven-deploy-plugin")) {
                    this.logger.debug("gitflow-helper-maven-plugin removing plugin: " + plugin + " from project: " + project.getName());
                    continue;
                }
                dropPlugins.add(plugin);
            }
            pluginsToDrop.put(project, dropPlugins);
        }
        if (pluginFound) {
            if (masterBranchPattern == null) {
                this.logger.debug("Using default master branch Pattern.");
                masterBranchPattern = "origin/master";
            }
            this.logger.debug("Master Branch Pattern: " + masterBranchPattern);
            if (gitBranchExpression == null) {
                this.logger.debug("Using default gitBranchExpression.");
                gitBranchExpression = "${env.GIT_BRANCH}";
            }
            this.logger.debug("Git Branch Expression: " + gitBranchExpression);
            PropertyResolver pr = new PropertyResolver();
            String gitBranch = pr.resolveValue(gitBranchExpression, session.getCurrentProject().getProperties(), systemEnvVars);
            this.logger.info("Build Extension Resolved: " + gitBranchExpression + " to: " + gitBranch);
            if (gitBranch != null && gitBranch.matches(masterBranchPattern)) {
                this.logger.info("gitflow-helper-maven-plugin: Enabling MasterPromoteExtension. GIT_BRANCH: [" + gitBranch + "] matches masterBranchPattern: [" + masterBranchPattern + "]");
                for (MavenProject project : session.getProjects()) {
                    project.getBuildPlugins().removeAll((Collection)pluginsToDrop.get(project));
                }
            }
        }
    }

    private String extractPluginConfigValue(String parameter, Plugin plugin) {
        String value = this.extractConfigValue(parameter, plugin.getConfiguration());
        for (int i = 0; i < plugin.getExecutions().size() && value == null; ++i) {
            value = this.extractConfigValue(parameter, ((PluginExecution)plugin.getExecutions().get(i)).getConfiguration());
        }
        return value;
    }

    private String extractConfigValue(String parameter, Object configuration) {
        try {
            return ((Xpp3Dom)configuration).getChild(parameter).getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

