/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBranchMojo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public abstract class AbstractGitflowBasedRepositoryMojo
extends AbstractGitflowBranchMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)::(.+)");
    @Parameter(property="releaseDeploymentRepository", required=true)
    protected String releaseDeploymentRepository;
    @Parameter(property="stageDeploymentRepository", required=true)
    protected String stageDeploymentRepository;
    @Parameter(property="snapshotDeploymentRepository", required=true)
    protected String snapshotDeploymentRepository;
    @Parameter(defaultValue="${repositorySystemSession}", required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File buildDirectory;
    @Component
    protected ArtifactRepositoryFactory repositoryFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;

    protected ArtifactRepository getDeploymentRepository(String altRepository) throws MojoExecutionException, MojoFailureException {
        Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altRepository);
        if (!matcher.matches()) {
            throw new MojoFailureException((Object)altRepository, "Invalid syntax for repository.", "Invalid syntax for repository. Use \"id::layout::url::unique\".");
        }
        String id = matcher.group(1).trim();
        String layout = matcher.group(2).trim();
        String url = matcher.group(3).trim();
        boolean unique = Boolean.parseBoolean(matcher.group(4).trim());
        ArtifactRepositoryLayout repoLayout = this.getLayout(layout);
        return this.repositoryFactory.createDeploymentArtifactRepository(id, url, repoLayout, unique);
    }

    private RemoteRepository getRepository(String altRepository) throws MojoExecutionException, MojoFailureException {
        Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altRepository);
        if (!matcher.matches()) {
            throw new MojoFailureException((Object)altRepository, "Invalid syntax for repository.", "Invalid syntax for repository. Use \"id::layout::url::unique\".");
        }
        String id = matcher.group(1).trim();
        String layout = matcher.group(2).trim();
        String url = matcher.group(3).trim();
        boolean unique = Boolean.parseBoolean(matcher.group(4).trim());
        ArtifactRepositoryLayout repoLayout = this.getLayout(layout);
        return new RemoteRepository.Builder(id, layout, url).build();
    }

    private String getCoordinates(ArtifactResult result) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(result.getArtifact().getGroupId());
        buffer.append(':').append(result.getArtifact().getArtifactId());
        buffer.append(':').append(result.getArtifact().getExtension());
        if (result.getArtifact().getClassifier().length() > 0) {
            buffer.append(':').append(result.getArtifact().getClassifier());
        }
        buffer.append(':').append(result.getArtifact().getBaseVersion());
        return buffer.toString();
    }

    private String getCoordinates(org.apache.maven.artifact.Artifact artifact) {
        StringBuilder result = new StringBuilder();
        this.getLog().debug((CharSequence)("   Encoding Coordinates For: " + artifact));
        String extension = this.session.getArtifactTypeRegistry().get(artifact.getType()).getExtension();
        if (artifact.getFile() != null && !artifact.getFile().getName().toLowerCase().endsWith(extension.toLowerCase())) {
            String fileExtension = artifact.getFile().getName().substring(artifact.getFile().getName().lastIndexOf(46) + 1);
            this.getLog().warn((CharSequence)("    Artifact file name: " + artifact.getFile().getName() + " of type " + artifact.getType() + " does not match the extension for the ArtifactType: " + extension + ". " + "This is likely an issue with the packaging definition for '" + artifact.getType() + "' artifacts, which may be missing an extension definition. " + "The gitflow helper catalog will use the actual file extension: " + fileExtension));
            extension = fileExtension;
        }
        result.append(this.project.getGroupId()).append(":").append(this.project.getArtifactId()).append(":").append(extension);
        if (artifact.hasClassifier()) {
            result.append(":").append(artifact.getClassifier());
        }
        result.append(":").append(this.project.getVersion());
        return result.toString().trim();
    }

    protected void attachArtifactCatalog() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Cataloging Artifacts for promotion & reattachment: " + this.project.getBuild().getDirectory()));
        File catalog = new File(this.buildDirectory, this.project.getArtifact().getArtifactId() + ".txt");
        PrintWriter writer = null;
        try {
            catalog.delete();
            this.buildDirectory.mkdirs();
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(catalog), Charset.forName("UTF-8")));
            if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null && this.project.getArtifact().getFile().exists() && !this.project.getArtifact().getFile().isDirectory()) {
                String coords = this.getCoordinates(this.project.getArtifact());
                if (!coords.isEmpty()) {
                    this.getLog().info((CharSequence)("Cataloging: " + (String)coords));
                    writer.println(coords);
                }
            } else {
                this.getLog().info((CharSequence)"No primary artifact to catalog, cataloging attached artifacts instead.");
            }
            for (org.apache.maven.artifact.Artifact artifact : this.project.getAttachedArtifacts()) {
                String coords = this.getCoordinates(artifact);
                if (coords.isEmpty()) continue;
                this.getLog().info((CharSequence)("Cataloging: " + coords));
                writer.println(coords);
            }
            this.getLog().info((CharSequence)("Attaching catalog artifact: " + catalog));
            this.projectHelper.attachArtifact(this.project, "txt", "catalog", catalog);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to create catalog of artifacts", (Exception)ioe);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void attachExistingArtifacts(String sourceRepository, boolean disableLocal) throws MojoExecutionException, MojoFailureException {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        if (sourceRepository == null) {
            if (disableLocal) {
                throw new MojoExecutionException("Cannot resolve artifacts from 'null' repository if the local repository is also disabled.");
            }
            this.getLog().debug((CharSequence)"Resolving existing artifacts from local repository only.");
        } else {
            remoteRepositories.addAll(Arrays.asList(this.getRepository(sourceRepository)));
        }
        ArrayList<ArtifactResult> resolvedArtifacts = new ArrayList<ArtifactResult>();
        Field localBaseDir = null;
        File originalBaseDir = this.session.getLocalRepositoryManager().getRepository().getBasedir();
        File tempRepo = null;
        if (disableLocal) {
            this.getLog().info((CharSequence)("Disabling local repository @ " + this.session.getLocalRepository().getBasedir()));
            try {
                localBaseDir = LocalRepository.class.getDeclaredField("basedir");
                localBaseDir.setAccessible(true);
                tempRepo = Files.createTempDirectory("gitflow-helper-maven-plugin-repo", new FileAttribute[0]).toFile();
                this.getLog().info((CharSequence)("Using temporary local repository @ " + tempRepo.getAbsolutePath()));
                localBaseDir.set(this.session.getLocalRepositoryManager().getRepository(), tempRepo);
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"Failed to disable local repository path.", (Throwable)ex);
            }
        }
        ArrayList<ArtifactRequest> requiredArtifacts = new ArrayList<ArtifactRequest>();
        BufferedReader reader = null;
        try {
            ArtifactResult catalogResult = this.artifactResolver.resolveArtifact(this.session, new ArtifactRequest((Artifact)new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), "catalog", "txt", this.project.getVersion()), remoteRepositories, null));
            resolvedArtifacts.add(catalogResult);
            if (catalogResult.isResolved()) {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(catalogResult.getArtifact().getFile()), Charset.forName("UTF-8")));
                Object coords = null;
                while ((coords = reader.readLine()) != null) {
                    if (((String)coords).trim().isEmpty()) continue;
                    requiredArtifacts.add(new ArtifactRequest((Artifact)new DefaultArtifact(((String)coords).trim()), remoteRepositories, null));
                }
            }
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Could not locate artifact catalog in remote repository.", (Exception)((Object)are));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not read artifact catalog", (Exception)ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            resolvedArtifacts.addAll(this.artifactResolver.resolveArtifacts(this.session, requiredArtifacts));
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Failed to resolve the required project files from: " + sourceRepository, (Exception)((Object)are));
        }
        String projectArtifactCoordinates = this.getCoordinates(this.project.getArtifact());
        this.getLog().debug((CharSequence)("Current Project Coordinates: " + projectArtifactCoordinates));
        for (ArtifactResult artifactResult : resolvedArtifacts) {
            try {
                FileUtils.copyFileToDirectory((File)artifactResult.getArtifact().getFile(), (File)this.buildDirectory);
                artifactResult.setArtifact(artifactResult.getArtifact().setFile(new File(this.buildDirectory, artifactResult.getArtifact().getFile().getName())));
                if (this.getCoordinates(artifactResult).equals(projectArtifactCoordinates)) {
                    this.getLog().debug((CharSequence)("    Setting primary artifact: " + artifactResult.getArtifact().getFile()));
                    this.project.getArtifact().setFile(artifactResult.getArtifact().getFile());
                    continue;
                }
                this.getLog().debug((CharSequence)("    Attaching artifact: " + this.getCoordinates(artifactResult) + " " + artifactResult.getArtifact().getFile()));
                this.projectHelper.attachArtifact(this.project, artifactResult.getArtifact().getExtension(), artifactResult.getArtifact().getClassifier(), artifactResult.getArtifact().getFile());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to copy resolved artifact to target directory.", (Exception)ioe);
            }
        }
        if (disableLocal) {
            try {
                localBaseDir.set(this.session.getLocalRepositoryManager().getRepository(), originalBaseDir);
                localBaseDir.setAccessible(false);
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"Failed to restore original local repository path.", (Throwable)ex);
            }
            if (tempRepo != null) {
                try {
                    FileUtils.deleteDirectory((File)tempRepo);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Failed to cleanup temporary repository directory: " + tempRepo));
                }
            }
        }
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoExecutionException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoExecutionException("Invalid repository layout: " + id);
        }
        return layout;
    }
}

