/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dsl;

import com.dynatrace.tools.android.dsl.ExcludeFilterOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;

public class ExcludeOptions
implements Serializable,
com.dynatrace.tools.android.api.ExcludeOptions {
    private List<String> packages;
    private List<String> classes;
    private List<String> methods;
    private List<ExcludeFilterOptions> filters;
    private transient Instantiator instantiator = null;

    public ExcludeOptions(Instantiator instantiator) {
        this(new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<ExcludeFilterOptions>());
        this.instantiator = instantiator;
    }

    ExcludeOptions(ExcludeOptions source) {
        this(new ArrayList<String>(source.packages), new ArrayList<String>(source.classes), new ArrayList<String>(source.methods), source.filters.stream().map(ExcludeFilterOptions::new).collect(Collectors.toList()));
    }

    ExcludeOptions(List<String> packages, List<String> classes, List<String> methods, List<ExcludeFilterOptions> filters) {
        this.packages = packages;
        this.classes = classes;
        this.methods = methods;
        this.filters = filters;
    }

    public void packages(String _package) {
        this.packages.add(_package);
    }

    public void packages(String ... packages) {
        this.packages.addAll(Arrays.asList(packages));
    }

    public void classes(String _class) {
        this.classes.add(_class);
    }

    public void classes(String ... classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public void methods(String method) {
        this.methods.add(method);
    }

    public void methods(String ... methods) {
        this.methods.addAll(Arrays.asList(methods));
    }

    public void filter(Action<? super ExcludeFilterOptions> action) {
        ExcludeFilterOptions excludeFilterOptions = (ExcludeFilterOptions)this.instantiator.newInstance(ExcludeFilterOptions.class, new Object[0]);
        action.execute((Object)excludeFilterOptions);
        this.filters.add(excludeFilterOptions);
    }

    @Override
    public List<String> getPackages() {
        return this.packages;
    }

    @Override
    public List<String> getClasses() {
        return this.classes;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    public List<ExcludeFilterOptions> getFilters() {
        return this.filters;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExcludeOptions)) {
            return false;
        }
        ExcludeOptions that = (ExcludeOptions)other;
        return Objects.equals(this.packages, that.packages) && Objects.equals(this.classes, that.classes) && Objects.equals(this.methods, that.methods) && Objects.equals(this.filters, that.filters);
    }

    public String toString() {
        return "ExcludeOptions{packages=" + this.packages + ", classes=" + this.classes + ", methods=" + this.methods + ", filters=" + this.filters + '}';
    }
}

