/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory.replay;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.instruction.InsertBeforeInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.instruction.ReplaceInstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.VarInsnNode;

public class SessionReplayWebViewTransformerFactory
implements TransformerFactory {
    private static final String WEB_VIEW = "android.webkit.WebView";
    private static final String WEB_VIEW_CLIENT = "android.webkit.WebViewClient";

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<InstructionSensor>> instructionSensors = new ArrayList<SensorGroup<InstructionSensor>>();
        instructionSensors.add(this.generateWebViewSensors(classLoader));
        return new DefaultSubTransformer("SessionReplayWebViewTransformer", instructionSensors, new ArrayList<SensorGroup<MethodSensor>>(), classLoader, warningsAsErrors);
    }

    private SensorGroup<InstructionSensor> generateWebViewSensors(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> webView = Class.forName(WEB_VIEW, false, classLoader);
        Method loadUrlOnlyString = webView.getDeclaredMethod("loadUrl", String.class);
        Method loadUrlWithMap = webView.getDeclaredMethod("loadUrl", String.class, Map.class);
        Class<?> webViewClient = Class.forName(WEB_VIEW_CLIENT, false, classLoader);
        Method setWebViewClient = webView.getDeclaredMethod("setWebViewClient", webViewClient);
        Class<?> callback = Class.forName("com.dynatrace.android.internal.api.InstrumentorAPI", false, classLoader);
        Method instrumentWebView = callback.getDeclaredMethod("trackWebView", webView);
        Method instrumentSetWebViewClient = callback.getDeclaredMethod("setWebViewClient", webView, webViewClient);
        Function<Integer, InsnList> transformer = startIndex -> {
            InsnList instructions = new InsnList();
            instructions.add((AbstractInsnNode)new VarInsnNode(25, startIndex.intValue()));
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(instrumentWebView));
            return instructions;
        };
        InsertBeforeInstructionSensor sensorLoadUrlOnlyString = new InsertBeforeInstructionSensor(loadUrlOnlyString, transformer);
        InsertBeforeInstructionSensor sensorLoadUrlWithMap = new InsertBeforeInstructionSensor(loadUrlWithMap, transformer);
        ReplaceInstructionSensor sensorSetWebViewClient = new ReplaceInstructionSensor(setWebViewClient, instrumentSetWebViewClient);
        return new SensorGroupImpl<InstructionSensor>("SRWebViewSensor", webView, sensorLoadUrlOnlyString, sensorLoadUrlWithMap, sensorSetWebViewClient);
    }
}

