/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.agent.AutoStartTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.ConfigurationBuilderTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.ConfigurationPresetSensorFactory;
import com.dynatrace.android.instrumentation.sensor.agent.ManualStartTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.PresetConfiguration;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AgentConfigurationTransformerFactory
implements TransformerFactory {
    private static final String CONFIG_FACTORY_CLASS = "com.dynatrace.android.agent.conf.ConfigurationFactory";
    private static final String CONFIG_BUILDER_CLASS = "com.dynatrace.android.agent.conf.ConfigurationBuilder";
    private static final String AGENT_MODE_CLASS = "com.dynatrace.android.agent.conf.AgentMode";
    private AutoStartTransformation.BuilderConfiguration builderConfig;
    private PresetConfiguration presetConfig;

    public AgentConfigurationTransformerFactory(AutoStartTransformation.BuilderConfiguration builderConfig, PresetConfiguration presetConfig) {
        this.builderConfig = builderConfig;
        this.presetConfig = presetConfig;
    }

    @Override
    public SubTransformer generateTransformer(ClassLoader classLoader, boolean warningsAsErrors) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        methodSensors.add(this.generateConfigurationBuilderSensor(classLoader));
        methodSensors.add(this.generateConfigurationFactorySensor(classLoader));
        methodSensors.add(new ConfigurationPresetSensorFactory(this.presetConfig).generateConfigurationPresetSensor(classLoader));
        return new DefaultSubTransformer("AgentConfigurationTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), methodSensors, classLoader, warningsAsErrors);
    }

    @Override
    public List<String> mandatoryClasses() {
        return Arrays.asList(CONFIG_FACTORY_CLASS, CONFIG_BUILDER_CLASS, "com.dynatrace.android.agent.conf.ConfigurationPreset");
    }

    private SensorGroup<MethodSensor> generateConfigurationFactorySensor(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> configFactoryClass = Class.forName(CONFIG_FACTORY_CLASS, false, classLoader);
        return new SensorGroupImpl<MethodSensor>("ConfigurationFactorySensor", otherClass -> configFactoryClass == otherClass, new MethodSensorImpl(this.getConfiguration(classLoader), this.builderConfig != null ? new AutoStartTransformation(this.builderConfig, classLoader) : new ManualStartTransformation(classLoader)));
    }

    private SensorGroup<MethodSensor> generateConfigurationBuilderSensor(ClassLoader classLoader) throws Exception {
        Class<?> configBuilderClass = Class.forName(CONFIG_BUILDER_CLASS, false, classLoader);
        return new SensorGroupImpl<MethodSensor>("ConfigurationBuilderSensor", otherClass -> configBuilderClass == otherClass, new MethodSensorImpl(this.ctorConfigurationBuilder(classLoader), new ConfigurationBuilderTransformation(classLoader)));
    }

    private Constructor ctorConfigurationBuilder(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(CONFIG_BUILDER_CLASS, false, classLoader).getDeclaredConstructor(Class.forName(AGENT_MODE_CLASS, false, classLoader), String.class, String.class);
    }

    private Method getConfiguration(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(CONFIG_FACTORY_CLASS, false, classLoader).getDeclaredMethod("getConfiguration", new Class[0]);
    }
}

