/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.shared;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TransformerUtils {
    public static String[] getArgumentSignatures(String desc) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 1; i < desc.length() && desc.charAt(i) != ')'; ++i) {
            char t = desc.charAt(i);
            String type = "";
            while (t == '[') {
                type = type + "[";
                t = desc.charAt(++i);
            }
            if (t == 'L') {
                int index = desc.indexOf(59, i);
                type = type + desc.substring(i, index + 1);
                i = index;
            } else {
                type = type + String.valueOf(t);
            }
            result.add(type);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getReturnType(String desc) {
        return desc.substring(desc.indexOf(41) + 1);
    }

    public static void insertAtMethodStartAndExit(MethodNode method, InstructionFactory startFactory, InstructionFactory exitFactory) {
        TransformerUtils.insertAtMethodStartAndExit(method, startFactory, exitFactory, false);
    }

    public static void insertAtMethodStartAndExit(MethodNode method, InstructionFactory startFactory, InstructionFactory exitFactory, boolean needsZeroStackHeightAtExit) {
        TransformerUtils.insertAtMethodExit(method, exitFactory, needsZeroStackHeightAtExit);
        TransformerUtils.insertAtMethodStart(method, startFactory);
    }

    public static void insertAtMethodStart(MethodNode method, InstructionFactory factory) {
        method.instructions.insertBefore(method.instructions.getFirst(), TransformerUtils.create(factory));
    }

    public static void insertAtMethodExit(MethodNode method, InstructionFactory factory) {
        TransformerUtils.insertAtMethodExit(method, factory, false);
    }

    public static void insertAtMethodExit(MethodNode method, InstructionFactory factory, boolean needsZeroStackHeight) {
        int n;
        TransformerUtils.insertBeforeReturnInstr(method, factory, needsZeroStackHeight);
        LabelNode trie = new LabelNode();
        LabelNode katch = new LabelNode();
        InsnList handler = new InsnList();
        if (needsZeroStackHeight) {
            int n2 = method.maxLocals;
            n = n2;
            method.maxLocals = n2 + 1;
        } else {
            n = -1;
        }
        int slot = n;
        handler.add(TransformerUtils.create(factory, slot, "Ljava/lang/Throwable;", method.localVariables));
        handler.add((AbstractInsnNode)new InsnNode(191));
        method.instructions.insertBefore(method.instructions.getFirst(), (AbstractInsnNode)trie);
        method.instructions.insert(method.instructions.getLast(), (AbstractInsnNode)katch);
        method.instructions.insert((AbstractInsnNode)katch, handler);
        method.tryCatchBlocks.add(new TryCatchBlockNode(trie, katch, katch, "java/lang/Throwable"));
    }

    public static void insertAtMethodExitWithoutExceptionHandling(MethodNode method, InstructionFactory factory) {
        TransformerUtils.insertBeforeReturnInstr(method, factory, false);
    }

    public static void insertBeforeReturnInstr(MethodNode method, InstructionFactory factory, boolean needsZeroStackHeight) {
        int n;
        if (needsZeroStackHeight) {
            int n2 = method.maxLocals;
            n = n2;
            method.maxLocals = n2 + 1;
        } else {
            n = -1;
        }
        int slot = n;
        String returnType = TransformerUtils.getReturnType(method.desc);
        for (AbstractInsnNode instruction : method.instructions) {
            if (!TransformerUtils.isReturnInstruction(instruction)) continue;
            method.instructions.insertBefore(instruction, TransformerUtils.create(factory, slot, returnType, method.localVariables));
        }
    }

    public static void insertBeforeAllInvocations(InsnList method, String callname, InstructionFactory factory) {
        for (MethodInsnNode call : TransformerUtils.findInvocations(method, callname)) {
            method.insertBefore((AbstractInsnNode)call, TransformerUtils.create(factory));
        }
    }

    public static void insertAfterAllInvocations(InsnList method, String callname, InstructionFactory factory) {
        for (MethodInsnNode call : TransformerUtils.findInvocations(method, callname)) {
            method.insert((AbstractInsnNode)call, TransformerUtils.create(factory));
        }
    }

    public static void insertBeforeFirstInvocation(InsnList method, String callname, InstructionFactory factory) {
        method.insertBefore((AbstractInsnNode)TransformerUtils.findInvocation(method, callname), TransformerUtils.create(factory));
    }

    public static void insertAfterFirstInvocation(InsnList method, String callname, InstructionFactory factory) {
        method.insert((AbstractInsnNode)TransformerUtils.findInvocation(method, callname), TransformerUtils.create(factory));
    }

    private static InsnList create(InstructionFactory factory) {
        return TransformerUtils.create(factory, -1, null, null);
    }

    private static InsnList create(InstructionFactory factory, int slot, String type, List<LocalVariableNode> locals) {
        InsnList instructions = new InsnList();
        factory.create(instructions);
        if (slot >= 0) {
            LabelNode start = new LabelNode();
            LabelNode end = new LabelNode();
            instructions.insertBefore(instructions.getFirst(), (AbstractInsnNode)new VarInsnNode(TransformerUtils.getStoreOpcode(type), slot));
            instructions.insert(instructions.getLast(), (AbstractInsnNode)new VarInsnNode(TransformerUtils.getLoadOpcode(type), slot));
            instructions.insertBefore(instructions.getFirst(), (AbstractInsnNode)start);
            instructions.insert(instructions.getLast(), (AbstractInsnNode)end);
            locals.add(new LocalVariableNode("dynatraceTmpStorage", type, null, start, end, slot));
        }
        return TransformerUtils.wrap(instructions);
    }

    private static int getStoreOpcode(String type) {
        if (type.equals("B") || type.equals("S") || type.equals("I") || type.equals("Z") || type.equals("C")) {
            return 54;
        }
        if (type.equals("J")) {
            return 55;
        }
        if (type.equals("F")) {
            return 56;
        }
        if (type.equals("D")) {
            return 57;
        }
        if (type.startsWith("L") || type.startsWith("[")) {
            return 58;
        }
        throw new IllegalArgumentException(type);
    }

    private static int getLoadOpcode(String type) {
        if (type.equals("B") || type.equals("S") || type.equals("I") || type.equals("Z") || type.equals("C")) {
            return 21;
        }
        if (type.equals("J")) {
            return 22;
        }
        if (type.equals("F")) {
            return 23;
        }
        if (type.equals("D")) {
            return 24;
        }
        if (type.startsWith("L") || type.startsWith("[")) {
            return 25;
        }
        throw new IllegalArgumentException(type);
    }

    private static InsnList wrap(InsnList instructions) {
        for (int i = 0; i < 3; ++i) {
            instructions.insertBefore(instructions.getFirst(), (AbstractInsnNode)new InsnNode(0));
            instructions.add((AbstractInsnNode)new InsnNode(0));
        }
        return instructions;
    }

    public static boolean isReturnInstruction(AbstractInsnNode instruction) {
        int opcode = instruction.getOpcode();
        return opcode == 177 || opcode == 176 || opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175;
    }

    public static AbstractInsnNode createIntrospectionCall(Class<?> clazz, String method, String signature) {
        return new MethodInsnNode(184, clazz.getName().replace('.', '/'), method, signature, false);
    }

    public static MethodInsnNode findInvocation(InsnList haystack, String needle) {
        for (AbstractInsnNode instruction : haystack) {
            if (!(instruction instanceof MethodInsnNode) || !needle.equals(((MethodInsnNode)instruction).name)) continue;
            return (MethodInsnNode)instruction;
        }
        return null;
    }

    public static MethodInsnNode[] findInvocations(InsnList haystack, String needle) {
        ArrayList<MethodInsnNode> result = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode instruction : haystack) {
            if (!(instruction instanceof MethodInsnNode) || needle != null && !needle.equals(((MethodInsnNode)instruction).name)) continue;
            result.add((MethodInsnNode)instruction);
        }
        return result.toArray(new MethodInsnNode[result.size()]);
    }

    public static interface InstructionFactory {
        public void create(InsnList var1);
    }
}

