/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method.generics;

import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvableType;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

class ResolvedGenericInfo {
    private Map<TypeVariable, ResolvableType> resolvedTypes;

    ResolvedGenericInfo(Map<TypeVariable, ResolvableType> resolvedTypes) {
        this.resolvedTypes = resolvedTypes;
    }

    List<Type> getResolvedArgumentTypes(Method method, Class<?> clazz) {
        return Arrays.stream(method.getGenericParameterTypes()).map(type -> this.convert((java.lang.reflect.Type)type, clazz)).collect(Collectors.toList());
    }

    Type getResolvedReturnType(Method method, Class<?> clazz) {
        return this.convert(method.getGenericReturnType(), clazz);
    }

    private Type convert(java.lang.reflect.Type type, Class<?> clazz) {
        if (type instanceof Class) {
            return Type.getType((Class)((Class)type));
        }
        if (type instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)type;
            return this.resolvedTypes.get(var).resolve(clazz);
        }
        throw new UnsupportedOperationException("unsupported type " + type.getClass().getName());
    }
}

