/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method.generics;

import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvableArrayType;
import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvableClass;
import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvableType;
import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvableTypeVariable;
import com.dynatrace.android.instrumentation.sensor.method.generics.ResolvedGenericInfo;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

class GenericTypeAnalyzer {
    private final Class<?> genericClass;

    GenericTypeAnalyzer(Class<?> clazz) {
        this.genericClass = clazz;
    }

    private static Map<TypeVariable, ResolvableType> resolveGenericParameters(Class<?> clazz) {
        return Arrays.stream(clazz.getTypeParameters()).collect(Collectors.toMap(Function.identity(), ResolvableTypeVariable::new, (prev, next) -> next, HashMap::new));
    }

    ResolvedGenericInfo resolveGenerics(Class<?> actualClass) {
        if (!this.genericClass.isAssignableFrom(actualClass)) {
            return null;
        }
        Map<TypeVariable, ResolvableType> resolvedTypes = GenericTypeAnalyzer.resolveGenericParameters(actualClass);
        if (actualClass.equals(this.genericClass)) {
            return new ResolvedGenericInfo(resolvedTypes);
        }
        Class<?> prevClass = actualClass;
        for (Class<?> curClass = actualClass.getSuperclass(); curClass != null && this.genericClass.isAssignableFrom(curClass); curClass = curClass.getSuperclass()) {
            Type curClassGeneric = prevClass.getGenericSuperclass();
            if (curClassGeneric instanceof ParameterizedType) {
                resolvedTypes = this.resolveGenericsForClass(curClass, (ParameterizedType)curClassGeneric, resolvedTypes);
            } else if (curClassGeneric instanceof Class) {
                resolvedTypes = GenericTypeAnalyzer.resolveGenericParameters(curClass);
            } else {
                throw new UnsupportedOperationException("unsupported type " + curClassGeneric.getClass().getName());
            }
            prevClass = curClass;
        }
        if (!this.genericClass.isInterface()) {
            return new ResolvedGenericInfo(resolvedTypes);
        }
        return new ResolvedGenericInfo(this.resolveGenericsForAllInterfaces(prevClass, resolvedTypes));
    }

    private Map<TypeVariable, ResolvableType> resolveGenericsForClass(Class<?> clazz, ParameterizedType clazzGeneric, Map<TypeVariable, ResolvableType> typesFromSubClass) {
        TypeVariable<Class<?>>[] generics = clazz.getTypeParameters();
        Type[] types = clazzGeneric.getActualTypeArguments();
        HashMap<TypeVariable, ResolvableType> resolvedTypes = new HashMap<TypeVariable, ResolvableType>();
        for (int ii = 0; ii < generics.length; ++ii) {
            resolvedTypes.put(generics[ii], this.determineActualType(generics[ii], types[ii], typesFromSubClass));
        }
        return resolvedTypes;
    }

    private Map<TypeVariable, ResolvableType> resolveGenericsForAllInterfaces(Class<?> implementClass, Map<TypeVariable, ResolvableType> resolvedTypesFromSubClass) {
        do {
            Type[] interfaceTypes = implementClass.getGenericInterfaces();
            boolean found = false;
            for (Type curInterfaceType : interfaceTypes) {
                if (curInterfaceType instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)curInterfaceType;
                    Class curInterface = (Class)parameterizedType.getRawType();
                    if (!this.genericClass.isAssignableFrom(curInterface)) continue;
                    resolvedTypesFromSubClass = this.resolveGenericsForClass(curInterface, parameterizedType, resolvedTypesFromSubClass);
                    implementClass = curInterface;
                    found = true;
                    break;
                }
                if (curInterfaceType instanceof Class) {
                    Class curInterface = (Class)curInterfaceType;
                    if (!this.genericClass.isAssignableFrom(curInterface)) continue;
                    resolvedTypesFromSubClass = GenericTypeAnalyzer.resolveGenericParameters(curInterface);
                    implementClass = curInterface;
                    found = true;
                    break;
                }
                throw new UnsupportedOperationException("unsupported type " + curInterfaceType.getClass().getName());
            }
            if (found) continue;
            throw new IllegalArgumentException("could not determine relationship between " + this.genericClass.getName() + " and " + implementClass.getName());
        } while (!implementClass.equals(this.genericClass));
        return resolvedTypesFromSubClass;
    }

    private ResolvableTypeVariable determineActualType(TypeVariable<? extends Class<?>> genericType, Type actualType, Map<TypeVariable, ResolvableType> resolvedTypesFromSubClass) {
        if (actualType instanceof TypeVariable) {
            return new ResolvableTypeVariable(genericType, resolvedTypesFromSubClass.get(actualType));
        }
        if (actualType instanceof Class) {
            return new ResolvableTypeVariable(genericType, new ResolvableClass((Class)actualType));
        }
        if (actualType instanceof ParameterizedType) {
            return new ResolvableTypeVariable(genericType, new ResolvableClass((Class)((ParameterizedType)actualType).getRawType()));
        }
        if (actualType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)actualType;
            int count = 1;
            while (genericArrayType.getGenericComponentType() instanceof GenericArrayType) {
                genericArrayType = (GenericArrayType)genericArrayType.getGenericComponentType();
                ++count;
            }
            TypeVariable genericComponent = (TypeVariable)genericArrayType.getGenericComponentType();
            return new ResolvableTypeVariable(genericType, new ResolvableArrayType(resolvedTypesFromSubClass.get(genericComponent), count));
        }
        throw new UnsupportedOperationException("unsupported actualType " + actualType.getClass().getName());
    }
}

