/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.util.Utils;
import java.lang.reflect.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ExitConstructorTransformation
implements MethodTransformation {
    private Method exitSensorMethod;
    private ParameterInstructionProvider exitParamInstrProvider;

    public ExitConstructorTransformation(Method exitSensorMethod, ParameterInstructionProvider exitParamInstrProvider) {
        this.exitSensorMethod = exitSensorMethod;
        this.exitParamInstrProvider = exitParamInstrProvider;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        TransformerUtils.InstructionFactory factory = instructions -> {
            if (this.exitParamInstrProvider != null) {
                this.exitParamInstrProvider.addParameterInstructions(instructions, startParameterIndex);
            }
            instructions.add((AbstractInsnNode)Utils.generateMethodCall(this.exitSensorMethod));
        };
        TransformerUtils.insertAtMethodExitWithoutExceptionHandling(methodNode, factory);
    }
}

