/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.filter;

import com.dynatrace.android.instrumentation.filter.ClassLevelFilter;
import com.dynatrace.android.instrumentation.filter.MethodLevelFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusionManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"ExclusionManager");
    private final Set<String> alwaysIncludeClasses = new HashSet<String>();
    private List<MethodLevelFilter> methodFilter;
    private List<ClassLevelFilter> classFilter;
    private List<ClassLevelFilter> classFileFilter;
    private Set<String> exclusionReport;

    public ExclusionManager(List<ClassLevelFilter> classFilter, List<MethodLevelFilter> methodFilter) {
        this.classFilter = classFilter;
        this.methodFilter = methodFilter;
        this.classFileFilter = new ArrayList<ClassLevelFilter>();
        this.exclusionReport = new TreeSet<String>();
    }

    public void addMandatoryClasses(List<String> mandatoryClasses) {
        this.alwaysIncludeClasses.addAll(mandatoryClasses);
    }

    public void addClassFilter(List<ClassLevelFilter> excludeClasses) {
        this.classFilter.addAll(excludeClasses);
    }

    public void addClassFileFilter(List<ClassLevelFilter> excludeClasses) {
        this.classFileFilter.addAll(excludeClasses);
    }

    public boolean filterClass(String className) {
        Optional<ClassLevelFilter> result = Stream.concat(this.classFileFilter.stream(), this.classFilter.stream()).filter(filter -> filter.filter(className)).findFirst();
        if (!result.isPresent() || this.alwaysIncludeClasses.contains(className)) {
            return false;
        }
        this.logExclusion("class", className);
        return true;
    }

    public boolean filterMethod(String className, String methodName, String methodDescription) {
        for (MethodLevelFilter excludeFilter : this.methodFilter) {
            if (!excludeFilter.filter(className, methodName, methodDescription)) continue;
            if (this.alwaysIncludeClasses.contains(className)) {
                return false;
            }
            this.logExclusion("method", className + "#" + methodName + methodDescription);
            return true;
        }
        return false;
    }

    public boolean filterInvokeInstruction(String className, String methodName, String methodDescription) {
        boolean shouldExclude = false;
        for (ClassLevelFilter filter : this.classFilter) {
            if (!filter.filter(className)) continue;
            shouldExclude = true;
            break;
        }
        if (!shouldExclude) {
            for (MethodLevelFilter excludeFilter : this.methodFilter) {
                if (!excludeFilter.filter(className, methodName, methodDescription)) continue;
                shouldExclude = true;
                break;
            }
        }
        return shouldExclude && !this.alwaysIncludeClasses.contains(className);
    }

    private void logExclusion(String type, String name) {
        logger.debug("excluded {} from instrumentation", (Object)name);
        this.exclusionReport.add(type + ": " + name);
    }

    public Set<String> getExclusionReport() {
        return this.exclusionReport;
    }
}

