/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.android.build.gradle.tasks.PackageApplication;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.SigningConfig;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.dynatrace.tools.android.AndroidPluginVersion;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class AutoInstrumentTask
extends ConventionTask {
    private File apkFile;
    private String applicationId;
    private String environmentId;
    private String cluster;
    private String startupPath;
    private String beaconURL;
    private Map<String, String> agentProperties;
    private SigningConfig signingConfig;
    private File apkitDir;
    private File outputFile;
    private AndroidPluginVersion androidPluginVersion = AndroidPluginVersion.VERSION_1_5;
    private PackageApplication packageTask;

    @TaskAction
    public void instrument() {
        block45: {
            boolean useBeaconURL;
            Properties tmpProperties = new Properties();
            tmpProperties.putAll(this.getAgentProperties());
            if (this.getApplicationId() != null) {
                tmpProperties.put("DTXApplicationID", this.getApplicationId());
            }
            boolean bl = useBeaconURL = this.getBeaconURL() != null;
            if (useBeaconURL) {
                tmpProperties.put("DTXBeaconURL", this.getBeaconURL());
            } else {
                boolean isAppMon;
                boolean bl2 = isAppMon = this.getEnvironmentId() == null;
                if (!isAppMon) {
                    if (this.getEnvironmentId() != null) {
                        tmpProperties.put("DTXAgentEnvironment", this.getEnvironmentId());
                    }
                    if (this.getCluster() != null) {
                        tmpProperties.put("DTXClusterURL", this.getCluster());
                    }
                } else if (this.getStartupPath() != null) {
                    tmpProperties.put("DTXAgentStartupPath", this.getStartupPath());
                }
            }
            File propertyFile = new File(this.getTemporaryDir(), "instrument.properties");
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(propertyFile));){
                tmpProperties.store(out, "Autogenerated properties");
            }
            catch (IOException ex) {
                throw new GradleException("Exception writing instrument.properties", (Throwable)ex);
            }
            String executableName = System.getProperty("os.name").toLowerCase().contains("windows") ? "instrument.cmd" : "instrument.sh";
            File instrumentExecutable = this.getProject().fileTree((Object)this.getApkitDir()).filter(file -> executableName.equalsIgnoreCase(file.getName())).getSingleFile();
            instrumentExecutable.setExecutable(true);
            if (this.getApkFile() == null || !this.getApkFile().getName().endsWith(".apk")) {
                throw new GradleException("Task input contains an invalid apk file: " + this.getApkFile());
            }
            String dirName = this.getApkFile().getName().substring(0, this.getApkFile().getName().lastIndexOf(".apk"));
            File instrumentDist = new File(this.getApkFile().getParentFile(), dirName + "/dist");
            File instrumentDirectory = new File(this.getApkFile().getParentFile(), dirName);
            File instrumentedAPK = new File(instrumentDist, this.getApkFile().getName());
            if (instrumentDirectory.exists()) {
                this.getProject().delete(new Object[]{instrumentDirectory});
            }
            this.getProject().exec(execSpec -> {
                execSpec.setExecutable((Object)instrumentExecutable);
                execSpec.setWorkingDir((Object)this.getTemporaryDir());
                execSpec.args(new Object[]{"apk=" + this.getApkFile().getAbsolutePath(), "prop=" + propertyFile.getAbsolutePath()});
            });
            if (!instrumentedAPK.exists()) {
                throw new IllegalStateException("auto-instrumentation failed");
            }
            try {
                boolean v2SigningEnabled;
                boolean v1SigningEnabled;
                X509Certificate certificate;
                PrivateKey key;
                String methodBuilderClass = this.androidPluginVersion.isOlderThan(AndroidPluginVersion.VERSION_3_1) ? "com.android.build.gradle.internal.tasks.BaseTask" : "com.android.build.gradle.internal.tasks.AndroidBuilderTask";
                Method methodBuilder = Class.forName(methodBuilderClass).getDeclaredMethod("getBuilder", new Class[0]);
                methodBuilder.setAccessible(true);
                AndroidBuilder androidBuilder = (AndroidBuilder)methodBuilder.invoke((Object)this.packageTask, new Object[0]);
                if (this.androidPluginVersion == AndroidPluginVersion.VERSION_1_5) {
                    Method methodSignApk = AndroidBuilder.class.getDeclaredMethod("signApk", File.class, SigningConfig.class, File.class);
                    methodSignApk.setAccessible(true);
                    methodSignApk.invoke((Object)androidBuilder, instrumentedAPK, this.getSigningConfig(), this.getOutputFile());
                    break block45;
                }
                String mainFileName = this.getApkFile().getAbsolutePath();
                String origFileName = mainFileName.substring(0, mainFileName.length() - 4) + "_uninstrumented.apk";
                this.getApkFile().renameTo(new File(origFileName));
                Class<?> classPackageAndroidArtifact = Class.forName("com.android.build.gradle.tasks.PackageAndroidArtifact");
                Method methodMinSdk = classPackageAndroidArtifact.getDeclaredMethod("getMinSdkVersion", new Class[0]);
                methodMinSdk.setAccessible(true);
                int minSdkVersion = (Integer)methodMinSdk.invoke((Object)this.packageTask, new Object[0]);
                Method methodDebugBuild = classPackageAndroidArtifact.getDeclaredMethod("getDebugBuild", new Class[0]);
                methodDebugBuild.setAccessible(true);
                boolean debugBuild = (Boolean)methodDebugBuild.invoke((Object)this.packageTask, new Object[0]);
                Method methodCreatedBy = AndroidBuilder.class.getDeclaredMethod("getCreatedBy", new Class[0]);
                methodCreatedBy.setAccessible(true);
                String createdBy = (String)methodCreatedBy.invoke((Object)androidBuilder, new Object[0]);
                if (this.signingConfig != null && this.signingConfig.isSigningReady()) {
                    CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)this.signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)this.signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyAlias())));
                    key = certificateInfo.getKey();
                    certificate = certificateInfo.getCertificate();
                    Method methodIsV1 = SigningConfig.class.getMethod("isV1SigningEnabled", new Class[0]);
                    methodIsV1.setAccessible(true);
                    Method methodIsV2 = SigningConfig.class.getMethod("isV2SigningEnabled", new Class[0]);
                    methodIsV2.setAccessible(true);
                    v1SigningEnabled = (Boolean)methodIsV1.invoke((Object)this.signingConfig, new Object[0]);
                    v2SigningEnabled = (Boolean)methodIsV2.invoke((Object)this.signingConfig, new Object[0]);
                } else {
                    key = null;
                    certificate = null;
                    v1SigningEnabled = false;
                    v2SigningEnabled = false;
                }
                String packageName = this.androidPluginVersion.isOlderOrEqualTo(AndroidPluginVersion.VERSION_2_2) ? "com.android.builder.packaging." : (this.androidPluginVersion.isOlderOrEqualTo(AndroidPluginVersion.VERSION_3_1) ? "com.android.apkzlib.zfile." : "com.android.tools.build.apkzlib.zfile.");
                Class<?> classNativeLibrariesPackagingMode = Class.forName(packageName + "NativeLibrariesPackagingMode");
                Class<?> classCreationData = Class.forName(packageName + "ApkCreatorFactory$CreationData");
                Constructor constructor = this.getCreationDataConstructor(classNativeLibrariesPackagingMode, classCreationData);
                Class<?> classPackagingUtils = Class.forName("com.android.builder.packaging.PackagingUtils");
                Method methodNativeLibraries = null;
                if (this.androidPluginVersion.isOlderOrEqualTo(AndroidPluginVersion.VERSION_3_1)) {
                    methodNativeLibraries = classPackagingUtils.getDeclaredMethod("getNativeLibrariesLibrariesPackagingMode", File.class);
                } else {
                    Class<?> evalIssueReporter = Class.forName("com.android.builder.errors.EvalIssueReporter");
                    methodNativeLibraries = classPackagingUtils.getDeclaredMethod("getNativeLibrariesLibrariesPackagingMode", File.class, BooleanSupplier.class, evalIssueReporter);
                }
                methodNativeLibraries.setAccessible(true);
                Object nativeLibrariesPackagingMode = this.getNativeLibrariesPackagingMode(dirName, classPackageAndroidArtifact, methodNativeLibraries);
                Object noCompressPredicate = this.getCompressionPredicate(classPackageAndroidArtifact, classNativeLibrariesPackagingMode, classPackagingUtils, nativeLibrariesPackagingMode);
                Object creationData = constructor.newInstance(this.getOutputFile(), key, certificate, v1SigningEnabled, v2SigningEnabled, null, createdBy, minSdkVersion, nativeLibrariesPackagingMode, noCompressPredicate);
                Class<?> classApkCreatorFactories = Class.forName("com.android.build.gradle.internal.packaging.ApkCreatorFactories");
                Method methodFromProjectProperties = classApkCreatorFactories.getDeclaredMethod("fromProjectProperties", Project.class, Boolean.TYPE);
                methodFromProjectProperties.setAccessible(true);
                Object factory = methodFromProjectProperties.invoke(null, this.getProject(), debugBuild);
                Class<?> classApkCreatorFactory = Class.forName(packageName + "ApkCreatorFactory");
                Method methodMake = classApkCreatorFactory.getDeclaredMethod("make", classCreationData);
                methodMake.setAccessible(true);
                try (Closeable creator = (Closeable)methodMake.invoke(factory, creationData);){
                    Method methodWriteZip = this.getWriteZipMethod(creator.getClass());
                    methodWriteZip.setAccessible(true);
                    methodWriteZip.invoke((Object)creator, instrumentedAPK, null, null);
                }
            }
            catch (Exception ex) {
                throw new GradleException("Failed to sign apk", (Throwable)ex);
            }
        }
    }

    private Object getNativeLibrariesPackagingMode(String dirName, Class classPackageAndroidArtifact, Method methodNativeLibraries) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException {
        Object nativeLibrariesPackagingMode;
        if (this.androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_0)) {
            File origManifestFile = new File(this.getApkFile().getParentFile(), dirName + "/AndroidManifest-orig.xml");
            if (this.androidPluginVersion.isOlderOrEqualTo(AndroidPluginVersion.VERSION_3_1)) {
                nativeLibrariesPackagingMode = methodNativeLibraries.invoke(null, origManifestFile);
            } else {
                BooleanSupplier execPhase = () -> true;
                nativeLibrariesPackagingMode = methodNativeLibraries.invoke(null, origManifestFile, execPhase, null);
            }
        } else {
            Field fieldManifest = classPackageAndroidArtifact.getDeclaredField("manifest");
            fieldManifest.setAccessible(true);
            File manifest = (File)fieldManifest.get(this.packageTask);
            nativeLibrariesPackagingMode = methodNativeLibraries.invoke(null, manifest);
            Method methodGetNoCompressPredicate = classPackageAndroidArtifact.getDeclaredMethod("getNoCompressPredicate", new Class[0]);
            methodGetNoCompressPredicate.setAccessible(true);
        }
        return nativeLibrariesPackagingMode;
    }

    private Object getCompressionPredicate(Class classPackageAndroidArtifact, Class classNativeLibrariesPackagingMode, Class classPackagingUtils, Object nativeLibrariesPackagingMode) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Predicate<String> noCompressPredicate;
        if (this.androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_0)) {
            Method methodGetNoCompressExtensions = classPackageAndroidArtifact.getDeclaredMethod("getNoCompressExtensions", new Class[0]);
            methodGetNoCompressExtensions.setAccessible(true);
            Collection noCompEx = (Collection)methodGetNoCompressExtensions.invoke((Object)this.packageTask, new Object[0]);
            Method methodGetAllNoCompressExtensions = classPackagingUtils.getDeclaredMethod("getAllNoCompressExtensions", Collection.class, classNativeLibrariesPackagingMode);
            methodGetAllNoCompressExtensions.setAccessible(true);
            List noCompressExtensions = (List)methodGetAllNoCompressExtensions.invoke(null, noCompEx, nativeLibrariesPackagingMode);
            Method methodGetNoCompressPredicateForExtension = classPackagingUtils.getDeclaredMethod("getNoCompressPredicateForExtensions", Iterable.class);
            methodGetNoCompressPredicateForExtension.setAccessible(true);
            noCompressPredicate = methodGetNoCompressPredicateForExtension.invoke(null, noCompressExtensions);
            if (this.androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_3)) {
                noCompressPredicate = noCompressPredicate::test;
            }
        } else {
            Method methodGetNoCompressPredicate = classPackageAndroidArtifact.getDeclaredMethod("getNoCompressPredicate", new Class[0]);
            methodGetNoCompressPredicate.setAccessible(true);
            noCompressPredicate = this.androidPluginVersion == AndroidPluginVersion.VERSION_2_3 ? methodGetNoCompressPredicate.invoke((Object)this.packageTask, new Object[0]) : arg_0 -> ((com.google.common.base.Predicate)((com.google.common.base.Predicate)methodGetNoCompressPredicate.invoke((Object)this.packageTask, new Object[0]))).apply(arg_0);
        }
        return noCompressPredicate;
    }

    private Constructor getCreationDataConstructor(Class classNativeLibrariesPackagingMode, Class classCreationData) throws NoSuchMethodException {
        Class<Predicate> predicateClass = Predicate.class;
        if (this.androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_3)) {
            predicateClass = com.google.common.base.Predicate.class;
        }
        return classCreationData.getDeclaredConstructor(File.class, PrivateKey.class, X509Certificate.class, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Integer.TYPE, classNativeLibrariesPackagingMode, predicateClass);
    }

    private Method getWriteZipMethod(Class clazz) throws NoSuchMethodException {
        Class<Predicate> predicateClass = Predicate.class;
        Class<java.util.function.Function> functionClass = java.util.function.Function.class;
        if (this.androidPluginVersion.isNewerOrEqualTo(AndroidPluginVersion.VERSION_3_3)) {
            functionClass = Function.class;
            predicateClass = com.google.common.base.Predicate.class;
        }
        return clazz.getDeclaredMethod("writeZip", File.class, functionClass, predicateClass);
    }

    @InputFile
    public File getApkFile() {
        return this.apkFile;
    }

    public void setApkFile(File apkFile) {
        this.apkFile = apkFile;
    }

    @Input
    @Optional
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Input
    @Optional
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Input
    @Optional
    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Input
    @Optional
    public String getBeaconURL() {
        return this.beaconURL;
    }

    public void setBeaconURL(String beaconURL) {
        this.beaconURL = beaconURL;
    }

    @Input
    @Optional
    public String getStartupPath() {
        return this.startupPath;
    }

    public void setStartupPath(String startupPath) {
        this.startupPath = startupPath;
    }

    @Input
    public Map<String, String> getAgentProperties() {
        return this.agentProperties;
    }

    public void setAgentProperties(Map<String, String> agentProperties) {
        this.agentProperties = agentProperties;
    }

    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Internal
    public File getApkitDir() {
        return this.apkitDir;
    }

    public void setApkitDir(File apkitDir) {
        this.apkitDir = apkitDir;
    }

    @Optional
    @InputFiles
    FileTree getApkitFiles() {
        if (this.apkitDir != null) {
            return this.getProject().fileTree((Object)this.apkitDir);
        }
        return null;
    }

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Input
    public AndroidPluginVersion getAndroidPluginVersion() {
        return this.androidPluginVersion;
    }

    public void setAndroidPluginVersion(AndroidPluginVersion androidPluginVersion) {
        this.androidPluginVersion = androidPluginVersion;
    }

    public PackageApplication getPackageTask() {
        return this.packageTask;
    }

    public void setPackageTask(PackageApplication packageTask) {
        this.packageTask = packageTask;
    }
}

