/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;

final class Normalize {
    private static final Logger logger = Logger.getLogger(Normalize.class.getName());
    private static final Pattern re_mk_firstIdentifierSectionStart = Pattern.compile("^[^a-zA-Z_]+");
    private static final Pattern re_mk_subsequentIdentifierSectionStart = Pattern.compile("^[^a-zA-Z0-9_]+");
    private static final Pattern re_mk_invalidCharacters = Pattern.compile("[^a-zA-Z0-9_\\-]+");
    private static final int mk_max_length = 250;
    private static final Pattern re_dk_sectionStart = Pattern.compile("^[^a-z_]+");
    private static final Pattern re_dk_invalidCharacters = Pattern.compile("[^a-z0-9_\\-:]+");
    private static final int dk_max_length = 100;
    private static final char dv_characterToEscape_quote = '\"';
    private static final char dv_characterToEscape_equals = '=';
    private static final char dv_characterToEscape_blank = ' ';
    private static final char dv_characterToEscape_comma = ',';
    private static final char dv_characterToEscape_backslash = '\\';
    private static final String dv_charactersToEscape = new StringBuilder(5).append('\"').append('=').append(' ').append(',').append('\\').toString();
    private static final Pattern re_dv_charactersToEscape = Pattern.compile("([" + Pattern.quote(dv_charactersToEscape) + "])");
    private static final Pattern re_dv_controlCharacters = Pattern.compile("[\\p{C}]+");
    private static final Pattern re_dv_hasOddNumberOfTrailingBackslashes = Pattern.compile("[^\\\\](?:\\\\\\\\)*\\\\$");
    private static final int dv_max_length = 250;

    private Normalize() {
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static List<Dimension> dimensionList(Collection<Dimension> dimensions) {
        ArrayList<Dimension> normalized = new ArrayList<Dimension>();
        if (dimensions == null) {
            return normalized;
        }
        for (Dimension dimension : dimensions) {
            String normalizedKey = Normalize.dimensionKey(dimension.getKey());
            if (Normalize.isNullOrEmpty(normalizedKey)) {
                logger.warning(String.format("could not normalize dimension key: '%s'. Skipping...", dimension.getKey()));
                continue;
            }
            normalized.add(Dimension.create(normalizedKey, Normalize.dimensionValue(dimension.getValue())));
        }
        return normalized;
    }

    static String dimensionKey(String key) {
        if (Normalize.isNullOrEmpty(key)) {
            return "";
        }
        if (key.length() > 100) {
            key = key.substring(0, 100);
        }
        String[] sections = key.split("\\.");
        StringBuilder normalizedKeyBuilder = new StringBuilder();
        boolean firstSection = true;
        for (String section : sections) {
            if (section.isEmpty()) continue;
            String normalizedSection = section.toLowerCase(Locale.ROOT);
            normalizedSection = re_dk_sectionStart.matcher(normalizedSection).replaceAll("_");
            normalizedSection = re_dk_invalidCharacters.matcher(normalizedSection).replaceAll("_");
            if (!firstSection) {
                normalizedKeyBuilder.append(".");
            } else {
                firstSection = false;
            }
            normalizedKeyBuilder.append(normalizedSection);
        }
        return normalizedKeyBuilder.toString();
    }

    static String dimensionValue(String value) {
        if (value == null) {
            return "";
        }
        if (value.length() > 250) {
            value = value.substring(0, 250);
        }
        value = re_dv_controlCharacters.matcher(value).replaceAll("_");
        return value;
    }

    static boolean needToEscapeDimensionValue(String dimensionValue) {
        int len = dimensionValue.length();
        if (len > 250) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            char c = dimensionValue.charAt(i);
            if (c != '\"' && c != '=' && c != ' ' && c != ',' && c != '\\') continue;
            return true;
        }
        return false;
    }

    static String escapeDimensionValue(String val) {
        if (Normalize.isNullOrEmpty(val)) {
            logger.warning("null or empty dimension value passed to normalization.");
            return val;
        }
        if (!Normalize.needToEscapeDimensionValue(val)) {
            return val;
        }
        String escaped = re_dv_charactersToEscape.matcher(val).replaceAll("\\\\$1");
        if (escaped.length() > 250 && re_dv_hasOddNumberOfTrailingBackslashes.matcher(escaped = escaped.substring(0, 250)).find()) {
            escaped = escaped.substring(0, 249);
        }
        return escaped;
    }

    static String metricKey(String key) {
        String[] sections;
        if (Normalize.isNullOrEmpty(key)) {
            logger.warning("null or empty metric key passed to normalization.");
            return null;
        }
        if (key.length() > 250) {
            key = key.substring(0, 250);
        }
        if ((sections = key.split("\\.")).length == 0) {
            return null;
        }
        boolean firstSection = true;
        StringBuilder normalizedKeyBuilder = new StringBuilder();
        for (String section : sections) {
            if (section.isEmpty()) {
                if (!firstSection) continue;
                logger.warning(String.format("first metric key section is empty. discarding metric with key %s...", key));
                return null;
            }
            String normalizedSection = firstSection ? re_mk_firstIdentifierSectionStart.matcher(section).replaceAll("_") : re_mk_subsequentIdentifierSectionStart.matcher(section).replaceAll("_");
            normalizedSection = re_mk_invalidCharacters.matcher(normalizedSection).replaceAll("_");
            if (!firstSection) {
                normalizedKeyBuilder.append(".");
            } else {
                firstSection = false;
            }
            normalizedKeyBuilder.append(normalizedSection);
        }
        return normalizedKeyBuilder.toString();
    }
}

