/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.DimensionList;
import com.dynatrace.metric.util.IMetricValue;
import com.dynatrace.metric.util.MetricException;
import com.dynatrace.metric.util.MetricValues;
import com.dynatrace.metric.util.Normalize;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public final class Metric {
    private Metric() {
    }

    public static Builder builder(String metricKey) {
        return new Builder(metricKey);
    }

    public static final class Builder {
        private static final Logger logger = Logger.getLogger(Builder.class.getName());
        private static final int METRIC_LINE_MAX_LENGTH = 2000;
        private static final int TIMESTAMP_WARNING_THROTTLE_FACTOR = 1000;
        private static final AtomicInteger timestampWarningCounter = new AtomicInteger(0);
        private final String metricKey;
        private String prefix;
        private IMetricValue value;
        private Instant time;
        private DimensionList dimensions;
        private DimensionList defaultDimensions;
        private DimensionList dynatraceMetadataDimensions;

        private Builder(String metricKey) {
            this.metricKey = metricKey;
        }

        Builder setDefaultDimensions(DimensionList defaultDimensions) {
            this.defaultDimensions = defaultDimensions;
            return this;
        }

        Builder setDynatraceMetadataDimensions(DimensionList dynatraceMetadataDimensions) {
            this.dynatraceMetadataDimensions = dynatraceMetadataDimensions;
            return this;
        }

        private void throwIfValueAlreadySet() throws MetricException {
            if (this.value != null) {
                throw new MetricException("A value was already set for this metric.");
            }
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Deprecated
        public Builder setLongCounterValueTotal(long value) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.LongCounterValue(value, false);
            return this;
        }

        public Builder setLongCounterValueDelta(long value) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.LongCounterValue(value, true);
            return this;
        }

        public Builder setLongGaugeValue(long value) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.LongGaugeValue(value);
            return this;
        }

        public Builder setLongSummaryValue(long min, long max, long sum, long count) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.LongSummaryValue(min, max, sum, count);
            return this;
        }

        @Deprecated
        public Builder setDoubleCounterValueTotal(double value) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.DoubleCounterValue(value, false);
            return this;
        }

        public Builder setDoubleCounterValueDelta(double value) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.DoubleCounterValue(value, true);
            return this;
        }

        public Builder setDoubleGaugeValue(double value) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.DoubleGaugeValue(value);
            return this;
        }

        public Builder setDoubleSummaryValue(double min, double max, double sum, long count) throws MetricException {
            this.throwIfValueAlreadySet();
            this.value = new MetricValues.DoubleSummaryValue(min, max, sum, count);
            return this;
        }

        public Builder setDimensions(DimensionList dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder setTimestamp(Instant timestamp) {
            if (timestamp == null) {
                return this;
            }
            int year = timestamp.atZone(ZoneOffset.UTC).getYear();
            if (year < 2000 || year > 3000) {
                if (timestampWarningCounter.getAndIncrement() == 0) {
                    logger.warning(String.format("Order of magnitude of the timestamp seems off (%s). The timestamp represents a time before the year 2000 or after the year 3000. Skipping setting timestamp, the current server time will be added upon ingestion. Only one out of every %d of these messages will be printed.", timestamp.toString(), 1000));
                }
                timestampWarningCounter.compareAndSet(1000, 0);
                return this;
            }
            this.time = timestamp;
            return this;
        }

        public Builder setCurrentTime() {
            return this.setTimestamp(Instant.now());
        }

        public String serialize() throws MetricException {
            String normalizedKeyString = this.makeNormalizedMetricKey();
            if (normalizedKeyString == null || normalizedKeyString.isEmpty()) {
                throw new MetricException("Normalized metric key is empty.");
            }
            if (this.value == null) {
                throw new MetricException("No value set for metric.");
            }
            StringBuilder builder = new StringBuilder(normalizedKeyString);
            DimensionList allDimensions = DimensionList.merge(this.defaultDimensions, this.dimensions, this.dynatraceMetadataDimensions);
            String dimensionsString = null;
            if (!allDimensions.isEmpty()) {
                dimensionsString = allDimensions.serialize();
            }
            if (dimensionsString != null && !dimensionsString.isEmpty()) {
                builder.append(",");
                builder.append(dimensionsString);
            }
            builder.append(" ");
            builder.append(this.value.serialize());
            if (this.time != null) {
                builder.append(" ");
                builder.append(this.time.toEpochMilli());
            }
            if (builder.length() > 2000) {
                throw new MetricException(String.format("Serialized line exceeds limit of %d characters accepted by the ingest API:%n%s", 2000, builder.toString()));
            }
            return builder.toString();
        }

        private String makeNormalizedMetricKey() {
            if (this.prefix == null || this.prefix.isEmpty()) {
                return Normalize.metricKey(this.metricKey);
            }
            return Normalize.metricKey(String.format("%s.%s", this.prefix, this.metricKey));
        }
    }
}

