/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.measure;

import android.view.MotionEvent;
import com.dynatrace.android.ragetap.detection.TapEventData;

public class MotionEventConverter {
    private final float inverseDensity;

    public MotionEventConverter(float density) {
        this.inverseDensity = 1.0f / density;
        if (Float.isNaN(this.inverseDensity) || Float.isInfinite(this.inverseDensity)) {
            throw new ArithmeticException("invalid value");
        }
    }

    public TapEventData convertToTapEvent(MotionEvent event, long timestamp) {
        int index = event.getActionIndex();
        return new TapEventData(event.getX(index) * this.inverseDensity, event.getY(index) * this.inverseDensity, timestamp, event.getEventTime());
    }
}

