/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.detection;

import com.dynatrace.android.agent.conf.RageTapConfiguration;
import com.dynatrace.android.ragetap.detection.TapData;

public class RageTapRules {
    private final RageTapConfiguration configuration;

    public RageTapRules(RageTapConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean exceedsTapDuration(TapData tap) {
        long duration = tap.getTapUp().getTimestamp() - tap.getTapDown().getTimestamp();
        return duration > (long)this.configuration.getTapDuration();
    }

    public boolean exceedsTimespanDifference(TapData prev, TapData next) {
        return this.exceedsTimespanDifference(prev, next.getTapDown().getTimestamp());
    }

    public boolean exceedsTimespanDifference(TapData tap, long timestamp) {
        long difference = timestamp - tap.getTapUp().getTimestamp();
        return difference > (long)this.configuration.getTimespanDifference();
    }

    public boolean exceedsDispersionRadius(TapData prev, TapData next) {
        float differenceY;
        float differenceX = next.getTapDown().getX() - prev.getTapDown().getX();
        float distanceSquare = differenceX * differenceX + (differenceY = next.getTapDown().getY() - prev.getTapDown().getY()) * differenceY;
        return distanceSquare > (float)(this.configuration.getDispersionRadius() * this.configuration.getDispersionRadius());
    }

    public boolean hasMinimumNumberOfTaps(int numOfTaps) {
        return numOfTaps >= this.configuration.getMinimumNumberOfTaps();
    }
}

