/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.metrics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.dynatrace.agent.metrics.AppVersion;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.SdkVersionProvider;
import com.dynatrace.android.agent.util.Utility;

public class AppVersionTracker {
    private static final String LOGTAG = Global.LOG_PREFIX + "AppVersionTracker";
    private final Context context;
    private final SdkVersionProvider sdkVersionProvider;

    public AppVersionTracker(Context context, SdkVersionProvider sdkVersionProvider) {
        this.context = context;
        this.sdkVersionProvider = sdkVersionProvider;
    }

    @SuppressLint(value={"NewApi"})
    public AppVersion determineAppVersion() {
        try {
            PackageInfo packageInfo = this.sdkVersionProvider.sdkVersion() >= 33 ? this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L)) : this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            if (packageInfo == null) {
                return null;
            }
            long versionCode = this.sdkVersionProvider.sdkVersion() >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
            return new AppVersion(versionCode, packageInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"Failed to determine app version from PackageInfo", (Throwable)e);
            }
            return null;
        }
    }
}

