/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.events.lifecycle.AppStartSegment;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.util.Utility;

public class AppStartEventWriter {
    private static final String DELIMITER = "&";
    private static final String ASSIGN = "=";
    private static final String EVENT_TYPE = "et=";
    private static final String NAME = "na";
    private static final String THREAD_ID = "it";
    private static final String CURRENT_ACTION_ID = "ca";
    private static final String PARENT_ACTION_ID = "pa";
    private static final String SEQ_NR_ACTION_START = "s0";
    private static final String TIME_ACTION_START = "t0";
    private static final String SEQ_NR_ACTION_END = "s1";
    private static final String TIME_DURATION = "t1";
    private static final String FORWARD_MESSAGE = "fw";

    public StringBuilder toBeaconString(AppStartSegment appStartSegment) {
        MeasurementPoint actionCreation = appStartSegment.getStartPoint();
        MeasurementPoint endPoint = appStartSegment.getEndPoint();
        StringBuilder sb = new StringBuilder();
        sb.append(EVENT_TYPE).append(appStartSegment.getEventType().getProtocolId());
        if (appStartSegment.getActivityName() != null) {
            sb.append(DELIMITER).append(NAME).append(ASSIGN).append(Utility.urlEncode((String)appStartSegment.getName()));
        }
        sb.append(DELIMITER).append(THREAD_ID).append(ASSIGN).append(Utility.getCurrentThreadId());
        sb.append(DELIMITER).append(CURRENT_ACTION_ID).append(ASSIGN).append(appStartSegment.getTagId());
        sb.append(DELIMITER).append(PARENT_ACTION_ID).append(ASSIGN).append(appStartSegment.getParentTagId());
        sb.append(DELIMITER).append(SEQ_NR_ACTION_START).append(ASSIGN).append(actionCreation.getSequenceNumber());
        sb.append(DELIMITER).append(TIME_ACTION_START).append(ASSIGN).append(actionCreation.getTimestamp());
        sb.append(DELIMITER).append(SEQ_NR_ACTION_END).append(ASSIGN).append(endPoint.getSequenceNumber());
        sb.append(DELIMITER).append(TIME_DURATION).append(ASSIGN).append(endPoint.getTimestamp());
        sb.append(DELIMITER).append(FORWARD_MESSAGE).append(ASSIGN).append(appStartSegment.getForwardToGrail() ? "1" : "0");
        return sb;
    }
}

