/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.conf.DataCollectionLevel;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;

public class PrivacyRules {
    public static final PrivacyRules PRIVACY_MODE_DEACTIVATED = new PrivacyRules(new UserPrivacyOptions.Builder().withDataCollectionLevel(DataCollectionLevel.USER_BEHAVIOR).withCrashReportingOptedIn(true).withCrashReplayOptedIn(false).withScreenRecordOptedIn(null).build());
    public static final UserPrivacyOptions NO_USER_DEFINED_VALUE = new UserPrivacyOptions.Builder().withDataCollectionLevel(DataCollectionLevel.OFF).build();
    private final UserPrivacyOptions privacySettings;

    public PrivacyRules(UserPrivacyOptions privacySettings) {
        this.privacySettings = privacySettings;
    }

    public boolean shouldCollectEvent(EventType eventType) {
        if (eventType == EventType.CRASH) {
            return this.privacySettings.isCrashReportingOptedIn();
        }
        if (eventType == EventType.ACTION_AUTO_LOADING_APP) {
            return this.privacySettings.getDataCollectionLevel() == DataCollectionLevel.OFF;
        }
        return eventType.getDataCollectionLevel().ordinal() <= this.privacySettings.getDataCollectionLevel().ordinal();
    }

    public boolean allowUserRelatedCookies() {
        return this.privacySettings.getDataCollectionLevel().ordinal() >= DataCollectionLevel.PERFORMANCE.ordinal();
    }

    public boolean allowLocationReporting() {
        return this.privacySettings.getDataCollectionLevel() == DataCollectionLevel.USER_BEHAVIOR;
    }

    public boolean keepVisitorId() {
        return this.privacySettings.getDataCollectionLevel() == DataCollectionLevel.USER_BEHAVIOR;
    }

    public UserPrivacyOptions getPrivacySettings() {
        return this.privacySettings;
    }
}

