/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.data;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.RageTapConfiguration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;
import com.dynatrace.android.agent.data.RandomFactory;
import com.dynatrace.android.agent.data.SessionState;
import com.dynatrace.android.agent.util.Utility;
import java.util.Random;

public class Session {
    static final int TC_MAX_VALUE = 100;
    private static final int SELF_MONITORING_SESSION_LIMIT = 20;
    private static final String TAG = Global.LOG_PREFIX + "Session";
    static RandomFactory randomFactory = new RandomFactory();
    private static volatile Session currentSession = null;
    public final long sessionStartTime;
    public long visitorId;
    public int sessionId;
    public int sequenceNumber = 0;
    public int multiplicity = -1;
    public String srBasicParam = null;
    public String userTag;
    private SessionState state = SessionState.CREATED;
    private volatile int selfMonitoringCount;
    private Random random;
    private volatile long lastInteractionTime;
    private PrivacyRules privacyRules;
    private final RageTapConfiguration rageTapConfiguration;
    private boolean isGrailEventsShouldBeCaptured = false;

    public Session(long sessionStartTime, Random random, PrivacyRules privacyRules, RageTapConfiguration rageTapConfiguration) {
        this.sessionStartTime = sessionStartTime;
        this.lastInteractionTime = sessionStartTime;
        this.random = random;
        this.selfMonitoringCount = 0;
        this.privacyRules = privacyRules;
        this.rageTapConfiguration = rageTapConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Session startNewSessionIfNeeded(PrivacyRules privacyRules) {
        if (currentSession != null) return currentSession;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (currentSession != null) return currentSession;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Session.startNewSession(privacyRules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void startNewSessionIfNeeded(PrivacyRules privacyRules, boolean is3GenShouldBeCaptured) {
        if (currentSession != null) return;
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (currentSession != null) return;
            Session session = Session.startNewSession(privacyRules);
            session.setGrailEventsShouldBeCaptured(is3GenShouldBeCaptured);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Session startNewSession(PrivacyRules privacyRules) {
        return Session.startNewSession(privacyRules, TimeLineProvider.getSystemTime());
    }

    public static void startNewSession(PrivacyRules privacyRules, boolean is3GenShouldBeCaptured) {
        Session session = Session.startNewSession(privacyRules, TimeLineProvider.getSystemTime());
        session.setGrailEventsShouldBeCaptured(is3GenShouldBeCaptured);
    }

    public static Session startNewSession(PrivacyRules privacyRules, long sessionStartTime) {
        ServerConfiguration serverConfig = AdkSettings.getInstance().getServerConfiguration();
        boolean isGrailEventsShouldBeCaptured = false;
        if (currentSession != null) {
            isGrailEventsShouldBeCaptured = currentSession.isGrailEventsShouldBeCaptured();
        }
        currentSession = new Session(sessionStartTime, randomFactory.generateRandom(), privacyRules, serverConfig.getRageTapConfiguration());
        currentSession.setGrailEventsShouldBeCaptured(isGrailEventsShouldBeCaptured);
        return currentSession;
    }

    public static Session currentSession() {
        if (currentSession != null) {
            return currentSession;
        }
        return Session.startNewSessionIfNeeded(PrivacyRules.PRIVACY_MODE_DEACTIVATED);
    }

    public static Session determineActiveSession(boolean mandatory, long currentTimestamp) {
        SessionSplitConfiguration sessionSplitConfiguration;
        Session curSession = Session.currentSession();
        if (!(mandatory || curSession.lastInteractionTime + (sessionSplitConfiguration = AdkSettings.getInstance().getSessionSplitConfiguration()).getInactivityTimeoutMs() >= currentTimestamp && curSession.sessionStartTime + sessionSplitConfiguration.getMaxSessionDurationMs() >= currentTimestamp)) {
            Core.startNewSession(true, curSession.getPrivacyRules(), currentTimestamp);
            if (curSession.getUserTag() != null && curSession.getPrivacyRules().shouldCollectEvent(EventType.IDENTIFY_USER)) {
                currentSession.setUserTag(curSession.userTag);
                Core.reportUserTag(currentSession);
            }
            curSession = currentSession;
        }
        curSession.lastInteractionTime = currentTimestamp;
        return curSession;
    }

    public static Session determineActiveSession(boolean mandatory) {
        return Session.determineActiveSession(mandatory, TimeLineProvider.getSystemTime());
    }

    public static Session determineActiveSessionForInternalEvent() {
        return currentSession;
    }

    public long getRunningTime() {
        return TimeLineProvider.getSystemTime() - this.sessionStartTime;
    }

    public long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public synchronized void updateLastInteractionTime(long time) {
        if (time > this.lastInteractionTime) {
            this.lastInteractionTime = time;
        }
    }

    public void handleTrafficLimitation(ServerConfiguration serverConfiguration) {
        boolean enableSession;
        if (this.state != SessionState.CREATED) {
            return;
        }
        int serverMultiplicity = serverConfiguration.getMultiplicity();
        boolean bl = enableSession = serverMultiplicity > 0;
        if (!enableSession && Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)"Session disabled by overload prevention (mp=0)");
        }
        if (enableSession && !(enableSession = this.rollDice(100, serverConfiguration.getTrafficControlPercentage())) && Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("Session disabled by traffic control: tc=" + serverConfiguration.getTrafficControlPercentage()));
        }
        this.state = enableSession ? SessionState.ENABLED : SessionState.DISABLED;
        this.multiplicity = serverMultiplicity;
    }

    private boolean rollDice(int poolSize, int positives) {
        return this.random.nextInt(poolSize) < positives;
    }

    public boolean isConfigurationApplied() {
        return this.state.isConfigurationApplied();
    }

    public boolean isActive() {
        return this.state.isActive();
    }

    public void addSelfMonitoringEvent() {
        ++this.selfMonitoringCount;
    }

    public boolean isSelfMonitoringLimitReached() {
        return this.selfMonitoringCount >= 20;
    }

    public PrivacyRules getPrivacyRules() {
        return this.privacyRules;
    }

    public RageTapConfiguration getRageTapConfiguration() {
        return this.rageTapConfiguration;
    }

    @Deprecated
    public void internalSetPrivacyRules(PrivacyRules privacyRules) {
        this.privacyRules = privacyRules;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    public boolean isGrailEventsShouldBeCaptured() {
        return this.isGrailEventsShouldBeCaptured;
    }

    public void setGrailEventsShouldBeCaptured(boolean grailEventsShouldBeCaptured) {
        this.isGrailEventsShouldBeCaptured = grailEventsShouldBeCaptured;
    }
}

