/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.window;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.dynatrace.android.window.WindowCallbackInstrumentation;
import java.util.HashSet;
import java.util.Set;

public class ActivityWindowTracker
implements Application.ActivityLifecycleCallbacks {
    private final WindowCallbackInstrumentation instrumentation;
    private final Set<Integer> cache = new HashSet<Integer>();

    private ActivityWindowTracker(WindowCallbackInstrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public static ActivityWindowTracker newTracker(WindowCallbackInstrumentation instrumentation, Activity activeActivity) {
        ActivityWindowTracker listener = new ActivityWindowTracker(instrumentation);
        if (activeActivity != null) {
            listener.instrumentActivity(activeActivity);
        }
        return listener;
    }

    private void instrumentActivity(Activity activity) {
        int key = this.identity(activity);
        if (!this.cache.contains(key)) {
            this.instrumentation.interceptWindowCallback(activity.getWindow());
            this.cache.add(key);
        }
    }

    private int identity(Activity activity) {
        return System.identityHashCode(activity);
    }

    public void onActivityResumed(Activity activity) {
        this.instrumentActivity(activity);
    }

    public void onActivityDestroyed(Activity activity) {
        this.cache.remove(this.identity(activity));
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }
}

