/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.measure;

import android.view.Window;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import com.dynatrace.android.ragetap.detection.RageTapDetector;
import com.dynatrace.android.ragetap.measure.MotionEventConverter;
import com.dynatrace.android.ragetap.measure.TapMonitor;
import com.dynatrace.android.window.OnKeyEventListener;
import com.dynatrace.android.window.OnTouchEventListener;
import com.dynatrace.android.window.WindowListenerFactory;

public class TapMonitorFactory
implements WindowListenerFactory {
    private static final String TAG = Global.LOG_PREFIX + "TapMonitorFactory";
    private final RageTapDetector detector;
    private final TimeLineProvider timeLineProvider;

    public TapMonitorFactory(RageTapDetector detector, TimeLineProvider timeLineProvider) {
        this.detector = detector;
        this.timeLineProvider = timeLineProvider;
    }

    private static float measureScreenDensity() {
        ScreenMetrics screenMetrics = AndroidMetrics.getInstance().getScreenMetrics();
        if (screenMetrics == null) {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)"Cannot determine screen density as ScreenMetrics is null");
            }
            return 1.0f;
        }
        return screenMetrics.getScreenDensityFactor();
    }

    @Override
    public OnKeyEventListener generateOnKeyEventListener() {
        return null;
    }

    @Override
    public OnTouchEventListener generateOnTouchEventListener(Window window) {
        MotionEventConverter converter = new MotionEventConverter(TapMonitorFactory.measureScreenDensity());
        return new TapMonitor(this.detector, converter, this.timeLineProvider);
    }
}

