/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.callback;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.dynatrace.android.lifecycle.LifecycleController;
import com.dynatrace.android.lifecycle.callback.ComponentIdentifier;
import com.dynatrace.android.lifecycle.callback.ComponentIdentity;
import com.dynatrace.android.lifecycle.event.ActivityEventType;

public class ActivityLifecycleListener
implements Application.ActivityLifecycleCallbacks {
    private final LifecycleController lifecycleController;
    private final ComponentIdentifier<Activity> componentIdentifier;

    public ActivityLifecycleListener(LifecycleController lifecycleController, ComponentIdentifier<Activity> componentIdentifier) {
        this.lifecycleController = lifecycleController;
        this.componentIdentifier = componentIdentifier;
    }

    public void onActivityPreCreated(Activity activity, Bundle savedInstanceState) {
        this.lifecycleController.createEvent(this.componentIdentifier.obtainIdentity(activity), ActivityEventType.ON_CREATE);
    }

    public void onActivityPostCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityPreStarted(Activity activity) {
        this.lifecycleController.createEvent(this.componentIdentifier.obtainIdentity(activity), ActivityEventType.ON_START);
    }

    public void onActivityPostStarted(Activity activity) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityPreResumed(Activity activity) {
        this.lifecycleController.createEvent(this.componentIdentifier.obtainIdentity(activity), ActivityEventType.ON_RESUME);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPostResumed(Activity activity) {
        ComponentIdentity componentIdentity = this.componentIdentifier.obtainIdentity(activity);
        this.lifecycleController.onLifecycleCompleted(componentIdentity);
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        this.lifecycleController.onLifecycleCompleted(this.componentIdentifier.obtainIdentity(activity));
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.lifecycleController.onLifecycleCompleted(this.componentIdentifier.obtainIdentity(activity));
    }
}

