/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.activitytracking.metrics;

public class ScreenMetrics {
    private final int screenWidth;
    private final int screenHeight;
    private final int screenDensityDpi;
    private final float screenDensityFactor;

    private ScreenMetrics(Builder builder) {
        this.screenWidth = builder.screenWidth;
        this.screenHeight = builder.screenHeight;
        this.screenDensityFactor = builder.screenDensityFactor;
        this.screenDensityDpi = builder.screenDensityDpi;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenDensityDpi() {
        return this.screenDensityDpi;
    }

    public float getScreenDensityFactor() {
        return this.screenDensityFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenMetrics that = (ScreenMetrics)o;
        if (this.screenWidth != that.screenWidth) {
            return false;
        }
        if (this.screenHeight != that.screenHeight) {
            return false;
        }
        if (this.screenDensityDpi != that.screenDensityDpi) {
            return false;
        }
        return Float.compare(that.screenDensityFactor, this.screenDensityFactor) == 0;
    }

    public int hashCode() {
        int result = this.screenWidth;
        result = 31 * result + this.screenHeight;
        result = 31 * result + this.screenDensityDpi;
        result = 31 * result + (this.screenDensityFactor != 0.0f ? Float.floatToIntBits(this.screenDensityFactor) : 0);
        return result;
    }

    public String toString() {
        return "ActivityMetrics{screenWidth=" + this.screenWidth + ", screenHeight=" + this.screenHeight + ", screenDensityDpi=" + this.screenDensityDpi + ", screenDensityFactor=" + this.screenDensityFactor + '}';
    }

    public static class Builder {
        private int screenWidth;
        private int screenHeight;
        private int screenDensityDpi;
        private float screenDensityFactor;

        public Builder withScreenWidth(int screenWidth) {
            this.screenWidth = screenWidth;
            return this;
        }

        public Builder withScreenHeight(int screenHeight) {
            this.screenHeight = screenHeight;
            return this;
        }

        public Builder withScreenDensityDpi(int screenDensityDpi) {
            this.screenDensityDpi = screenDensityDpi;
            return this;
        }

        public Builder withScreenDensityFactor(float screenDensityFactor) {
            this.screenDensityFactor = screenDensityFactor;
            return this;
        }

        public ScreenMetrics build() {
            return new ScreenMetrics(this);
        }
    }
}

