/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle;

import android.app.Application;
import android.os.Build;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.events.lifecycle.FinishedActionObserver;
import com.dynatrace.android.agent.events.lifecycle.StoreActionObserver;
import com.dynatrace.android.agent.measurement.MeasurementProviderImpl;
import com.dynatrace.android.lifecycle.LifecycleController;
import com.dynatrace.android.lifecycle.action.LifecycleActionFactoryImpl;
import com.dynatrace.android.lifecycle.callback.ActivityComponentIdentifier;
import com.dynatrace.android.lifecycle.callback.ActivityLifecycleListener;
import com.dynatrace.android.lifecycle.callback.ActivityLifecycleListenerLegacy;
import com.dynatrace.android.useraction.ActionAggregatorImpl;
import com.dynatrace.android.useraction.LoadingActionNameGenerator;

public class ActivityLifecycleMonitor {
    private Application.ActivityLifecycleCallbacks lifecycleCallbacks;

    public void startMonitoring(Application application, TimeLineProvider timeLineProvider) {
        ActionAggregatorImpl aggregator = new ActionAggregatorImpl(new LoadingActionNameGenerator());
        MeasurementProviderImpl measurementProvider = new MeasurementProviderImpl(timeLineProvider);
        LifecycleController controller = new LifecycleController(new LifecycleActionFactoryImpl(), new FinishedActionObserver(), new StoreActionObserver(), measurementProvider, aggregator);
        ActivityComponentIdentifier identifier = new ActivityComponentIdentifier();
        this.lifecycleCallbacks = Build.VERSION.SDK_INT >= 29 ? new ActivityLifecycleListener(controller, identifier) : new ActivityLifecycleListenerLegacy(controller, identifier);
        application.registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }

    public void stopMonitoring(Application application) {
        if (this.lifecycleCallbacks != null) {
            application.unregisterActivityLifecycleCallbacks(this.lifecycleCallbacks);
            this.lifecycleCallbacks = null;
        }
    }
}

