/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import android.util.Log;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.HttpClientCallbackCore;
import com.dynatrace.android.callback.UriReqStateParms;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public final class HttpClientCallback {
    private static final String LOGTAG = Global.LOG_PREFIX + "HttpClientCallback";

    private HttpClientCallback() {
    }

    public static void newInstance(HttpRequestBase httpMethod) {
        if (!Global.isAlive.get()) {
            return;
        }
        HttpClientCallbackCore.addHttpReq(httpMethod);
    }

    static HttpHost determineTarget(HttpUriRequest request) {
        if (request == null) {
            return null;
        }
        URI uri = request.getURI();
        if (uri == null || !uri.isAbsolute()) {
            return null;
        }
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest uriReq) throws Exception {
        return HttpClientCallback.execute(httpClient, uriReq, (HttpContext)new BasicHttpContext());
    }

    public static HttpResponse execute(HttpClient httpClient, HttpHost host, HttpRequest request) throws Exception {
        return HttpClientCallback.execute(httpClient, host, request, (HttpContext)new BasicHttpContext());
    }

    public static Object execute(HttpClient httpClient, HttpUriRequest uriReq, ResponseHandler<?> handler) throws Exception {
        return HttpClientCallback.execute(httpClient, uriReq, handler, (HttpContext)new BasicHttpContext());
    }

    public static Object execute(HttpClient httpClient, HttpHost host, HttpRequest request, ResponseHandler<?> handler) throws Exception {
        return HttpClientCallback.execute(httpClient, host, request, handler, (HttpContext)new BasicHttpContext());
    }

    public static HttpResponse execute(HttpClient httpClient, HttpUriRequest uriReq, HttpContext context) throws Exception {
        HttpResponse resp;
        if (!Global.isAlive.get()) {
            return httpClient.execute(uriReq, context);
        }
        if (context == null) {
            context = new BasicHttpContext();
        }
        UriReqStateParms parm = new UriReqStateParms(HttpClientCallback.determineTarget(uriReq), (HttpRequest)uriReq, context);
        try {
            HttpClientCallback.updateRequest(parm);
            resp = httpClient.execute(uriReq, context);
            HttpClientCallback.getRespCodeFromResp(resp, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            HttpClientCallback.updateRequest(parm);
        }
        catch (Exception e) {
            parm.respCode = 0;
            parm.reason = e.toString();
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            HttpClientCallback.updateRequest(parm);
            throw e;
        }
        return resp;
    }

    public static HttpResponse execute(HttpClient httpClient, HttpHost host, HttpRequest request, HttpContext context) throws Exception {
        HttpResponse resp;
        if (!Global.isAlive.get()) {
            return httpClient.execute(host, request, context);
        }
        if (context == null) {
            context = new BasicHttpContext();
        }
        UriReqStateParms parm = new UriReqStateParms(host, request, context);
        try {
            HttpClientCallback.updateRequest(parm);
            resp = httpClient.execute(host, request, context);
            HttpClientCallback.getRespCodeFromResp(resp, parm);
            parm.state = CbConstants.WrStates.POST_EXEC_OK;
            HttpClientCallback.updateRequest(parm);
        }
        catch (Exception e) {
            parm.respCode = 0;
            parm.reason = e.toString();
            parm.state = CbConstants.WrStates.POST_EXEC_ERR;
            HttpClientCallback.updateRequest(parm);
            throw e;
        }
        return resp;
    }

    public static Object execute(HttpClient httpClient, HttpUriRequest uriReq, ResponseHandler<?> handler, HttpContext context) throws Exception {
        HttpResponse resp = HttpClientCallback.execute(httpClient, uriReq, context);
        return HttpClientCallback.wrapHandleResponse(handler, resp);
    }

    public static Object execute(HttpClient httpClient, HttpHost host, HttpRequest request, ResponseHandler<?> handler, HttpContext context) throws Exception {
        HttpResponse resp = HttpClientCallback.execute(httpClient, host, request, context);
        return HttpClientCallback.wrapHandleResponse(handler, resp);
    }

    private static Object wrapHandleResponse(ResponseHandler<?> responseHandler, HttpResponse response) throws IOException {
        Object result;
        try {
            result = responseHandler.handleResponse(response);
        }
        catch (Throwable t) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (Throwable t2) {
                    Log.w((String)"HttpClient", (String)"Error consuming content after an exception.", (Throwable)t2);
                }
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            entity.consumeContent();
        }
        return result;
    }

    private static void getRespCodeFromResp(HttpResponse resp, UriReqStateParms wrsp) {
        int respCode;
        block5: {
            respCode = 0;
            if (resp == null || wrsp == null) {
                return;
            }
            try {
                StatusLine status = resp.getStatusLine();
                if (status != null) {
                    respCode = status.getStatusCode();
                    wrsp.reason = status.getReasonPhrase();
                }
                wrsp.calcHttpMessageBytes(resp);
                Header[] headers = resp.getHeaders("Server-Timing");
                ArrayList<String> list = new ArrayList<String>();
                for (Header header : headers) {
                    list.add(header.getValue());
                }
                wrsp.evaluateServerTiming(list);
            }
            catch (Exception e) {
                if (wrsp.reason != null) break block5;
                wrsp.reason = e.getMessage();
            }
        }
        wrsp.respCode = respCode;
    }

    private static void updateRequest(UriReqStateParms parm) {
        block2: {
            try {
                HttpClientCallbackCore.updateRequest(parm);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogD((String)LOGTAG, (String)parm.toString(), (Throwable)e);
            }
        }
    }
}

