/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.AgentUtil;
import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.WebReqTag;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

public class ApacheUtil {
    public static String fetchWebReqTag(HttpRequest httpReq) {
        if (httpReq == null) {
            return null;
        }
        try {
            Header header = httpReq.getLastHeader(Dynatrace.getRequestTagHeader());
            if (header != null) {
                return header.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static WebReqTag tagRequest(HttpRequest request) {
        if (!Dynatrace.getCaptureStatus() || request == null) {
            return null;
        }
        WebReqTag wrTag = AgentUtil.getRequestTag();
        if (wrTag == null) {
            return null;
        }
        request.setHeader(Dynatrace.getRequestTagHeader(), wrTag.toString());
        return wrTag;
    }

    public static WebReqTag tagRequest(DTXActionImpl action, HttpRequest request) {
        if (!action.getPreconditions() || request == null || !action.session.getPrivacyRules().shouldCollectEvent(EventType.WEB_REQUEST)) {
            return null;
        }
        WebReqTag wrTag = action.getInternalRequestTag();
        if (wrTag == null) {
            return null;
        }
        request.setHeader(Dynatrace.getRequestTagHeader(), wrTag.toString());
        CustomSegment webReq = new CustomSegment(wrTag.toString(), 110, EventType.PLACEHOLDER, action.getTagId(), action.session, action.serverId, true);
        action.addChildEvent(webReq);
        return wrTag;
    }
}

