/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.events.lifecycle.DisplaySegment;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.util.Utility;

public class DisplayEventWriter {
    private static final String DELIMITER = "&";
    private static final String ASSIGN = "=";
    private static final String EVENT_TYPE = "et=";
    private static final String NAME = "na";
    private static final String THREAD_ID = "it";
    private static final String CURRENT_ACTION_ID = "ca";
    private static final String PARENT_ACTION_ID = "pa";
    private static final String SEQ_NR_ACTION_START = "s0";
    private static final String TIME_ACTION_START = "t0";
    private static final String SEQ_NR_LC_CREATE = "s1";
    private static final String TIME_LC_CREATE = "t1";
    private static final String SEQ_NR_LC_START = "s2";
    private static final String TIME_LC_START = "t2";
    private static final String SEQ_NR_LC_RESUME = "s3";
    private static final String TIME_LC_RESUME = "t3";
    private static final String SEQ_NR_DURATION = "s4";
    private static final String TIME_DURATION = "t4";
    private static final String FORWARD_MESSAGE = "fw";

    public StringBuilder toBeaconString(DisplaySegment displaySegment) {
        MeasurementPoint actionCreation = displaySegment.getActionCreationPoint();
        MeasurementPoint onCreate = displaySegment.getCreateEvent();
        MeasurementPoint onStart = displaySegment.getStartEvent();
        MeasurementPoint onResume = displaySegment.getResumeEvent();
        MeasurementPoint duration = displaySegment.getEndpoint();
        StringBuilder sb = new StringBuilder();
        sb.append(EVENT_TYPE).append(displaySegment.getEventType().getProtocolId());
        sb.append(DELIMITER).append(NAME).append(ASSIGN).append(Utility.urlEncode((String)displaySegment.getName()));
        sb.append(DELIMITER).append(THREAD_ID).append(ASSIGN).append(Thread.currentThread().getId());
        sb.append(DELIMITER).append(CURRENT_ACTION_ID).append(ASSIGN).append(displaySegment.getTagId());
        sb.append(DELIMITER).append(PARENT_ACTION_ID).append(ASSIGN).append(displaySegment.getParentTagId());
        sb.append(DELIMITER).append(SEQ_NR_ACTION_START).append(ASSIGN).append(actionCreation.getSequenceNumber());
        sb.append(DELIMITER).append(TIME_ACTION_START).append(ASSIGN).append(actionCreation.getTimestamp());
        if (onCreate != null) {
            sb.append(DELIMITER).append(SEQ_NR_LC_CREATE).append(ASSIGN).append(onCreate.getSequenceNumber());
            sb.append(DELIMITER).append(TIME_LC_CREATE).append(ASSIGN).append(onCreate.getTimestamp());
        }
        if (onStart != null) {
            sb.append(DELIMITER).append(SEQ_NR_LC_START).append(ASSIGN).append(onStart.getSequenceNumber());
            sb.append(DELIMITER).append(TIME_LC_START).append(ASSIGN).append(onStart.getTimestamp());
        }
        if (onResume != null) {
            sb.append(DELIMITER).append(SEQ_NR_LC_RESUME).append(ASSIGN).append(onResume.getSequenceNumber());
            sb.append(DELIMITER).append(TIME_LC_RESUME).append(ASSIGN).append(onResume.getTimestamp());
        }
        if (duration != null) {
            sb.append(DELIMITER).append(SEQ_NR_DURATION).append(ASSIGN).append(duration.getSequenceNumber());
            sb.append(DELIMITER).append(TIME_DURATION).append(ASSIGN).append(duration.getTimestamp());
        }
        sb.append(DELIMITER).append(FORWARD_MESSAGE).append(ASSIGN).append(displaySegment.getForwardToGrail() ? "1" : "0");
        return sb;
    }
}

