/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.db.DatabaseWriteQueue;
import com.dynatrace.android.agent.util.Utility;
import java.util.Iterator;
import java.util.LinkedList;

public class EventsDbHelper
extends SQLiteOpenHelper {
    static final String COLUMN_ROW_ID = "id";
    static final String COLUMN_VISITOR_ID = "visitor_id";
    static final String COLUMN_SESSION_ID = "session_id";
    static final String COLUMN_SEQUENCE_NUMBER = "sequence_nr";
    static final String COLUMN_BASIC_SEGMENT = "basic_segment";
    static final String COLUMN_EVENT_SEGMENT = "event_segment";
    static final String COLUMN_SESSION_START = "session_start";
    static final String COLUMN_EVENT_START = "event_start";
    static final String COLUMN_MULTIPLICITY = "multiplicity";
    static final String COLUMN_SERVER_ID = "server_id";
    static final String COLUMN_EVENT_ID = "event_id";
    static final String COLUMN_APP_ID = "app_id";
    static final String COLUMN_SR_PARAM = "sr_param";
    static final String DB_NAME = "DTXDb";
    static final String TABLE_EVENT = "Events";
    static final int DB_VERSION = 10;
    static final int CRASH_EVENT_ID = EventType.CRASH.getProtocolId();
    private static final String TAG = Global.LOG_PREFIX + "EventsDbHelper";
    private static final String DATABASE_CREATE = "CREATE table Events (id INTEGER PRIMARY KEY AUTOINCREMENT, visitor_id INTEGER NOT NULL, session_id INTEGER NOT NULL, sequence_nr INTEGER NOT NULL, basic_segment TEXT NOT NULL, event_segment TEXT NOT NULL, event_id INTEGER NOT NULL, session_start INTEGER NOT NULL, event_start INTEGER NOT NULL, multiplicity INTEGER NOT NULL,server_id INTEGER NOT NULL,app_id TEXT NOT NULL,sr_param TEXT);";
    private SQLiteStatement stmtDeleteByDate = this.getWritableDatabase().compileStatement("DELETE FROM Events WHERE session_start + event_start < ?");
    private SQLiteStatement stmtDeleteByDateNoCrashes = this.getWritableDatabase().compileStatement("DELETE FROM Events WHERE session_start + event_start < ? AND event_id <> " + CRASH_EVENT_ID);
    private SQLiteStatement stmtDeleteByEventId;

    public EventsDbHelper(Context context) {
        super(context, DB_NAME, null, 10);
        String sql = "SELECT id FROM Events WHERE event_id= ? ORDER BY (session_start + event_start) DESC LIMIT ?";
        this.stmtDeleteByEventId = this.getWritableDatabase().compileStatement("DELETE FROM Events WHERE event_id= ? AND id NOT IN (" + sql + ")");
    }

    public void onCreate(SQLiteDatabase db) {
        block3: {
            if (Global.DEBUG) {
                Utility.zlogD((String)TAG, (String)String.format("Creating Db.Table(%s.%s)", DB_NAME, TABLE_EVENT));
            }
            try {
                db.execSQL(DATABASE_CREATE);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block3;
                Utility.zlogE((String)TAG, (String)DATABASE_CREATE, (Throwable)e);
            }
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.recreate(db, oldVersion, newVersion, "Upgrading");
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.recreate(db, oldVersion, newVersion, "Downgrading");
    }

    private void recreate(SQLiteDatabase db, int oldVersion, int newVersion, String label) {
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)String.format("%s Db.Table(%s.%s) from version %s to %s.", label, DB_NAME, TABLE_EVENT, oldVersion, newVersion));
        }
        this.dropTable(db, TABLE_EVENT);
        this.onCreate(db);
    }

    private void dropTable(SQLiteDatabase db, String tableName) {
        block2: {
            try {
                db.execSQL("DROP TABLE IF EXISTS " + tableName);
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogE((String)TAG, (String)("could not delete table " + tableName), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertBatch(LinkedList<DatabaseWriteQueue.DatabaseRecord> writeQueue) {
        block7: {
            if (writeQueue == null || writeQueue.isEmpty()) {
                return;
            }
            Iterator it = writeQueue.iterator();
            try {
                SQLiteDatabase db = this.getWritableDatabase();
                db.beginTransaction();
                try {
                    while (it.hasNext()) {
                        DatabaseWriteQueue.DatabaseRecord record = (DatabaseWriteQueue.DatabaseRecord)it.next();
                        if (!record.session.isActive()) continue;
                        Session session = record.session;
                        ContentValues initialValues = new ContentValues();
                        initialValues.put(COLUMN_VISITOR_ID, Long.valueOf(session.visitorId));
                        initialValues.put(COLUMN_SESSION_ID, Long.valueOf(session.sessionId));
                        initialValues.put(COLUMN_SEQUENCE_NUMBER, Integer.valueOf(session.sequenceNumber));
                        initialValues.put(COLUMN_BASIC_SEGMENT, record.sObvc);
                        initialValues.put(COLUMN_EVENT_SEGMENT, record.sOa);
                        initialValues.put(COLUMN_EVENT_ID, Integer.valueOf(record.eventId));
                        initialValues.put(COLUMN_SESSION_START, Long.valueOf(session.sessionStartTime));
                        initialValues.put(COLUMN_EVENT_START, Long.valueOf(record.eventStart));
                        initialValues.put(COLUMN_MULTIPLICITY, Integer.valueOf(session.multiplicity == -1 ? 1 : session.multiplicity));
                        initialValues.put(COLUMN_SERVER_ID, Integer.valueOf(record.serverId));
                        initialValues.put(COLUMN_APP_ID, record.appId);
                        initialValues.put(COLUMN_SR_PARAM, session.srBasicParam);
                        db.insert(TABLE_EVENT, null, initialValues);
                    }
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block7;
                Utility.zlogE((String)TAG, (String)"Error inserting batch record into database.", (Throwable)e);
            }
        }
    }

    public void deleteEventsByDate(long date, boolean keepCrashes) {
        SQLiteStatement stmtDelete = keepCrashes ? this.stmtDeleteByDateNoCrashes : this.stmtDeleteByDate;
        stmtDelete.bindLong(1, date);
        int rowsDeleted = stmtDelete.executeUpdateDelete();
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("Rows deleted: " + rowsDeleted));
        }
    }

    public int deleteEventsByEventId(int eventId, int limit) {
        this.stmtDeleteByEventId.bindLong(1, (long)eventId);
        this.stmtDeleteByEventId.bindLong(2, (long)eventId);
        this.stmtDeleteByEventId.bindLong(3, (long)limit);
        int rowsDeleted = this.stmtDeleteByEventId.executeUpdateDelete();
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("Rows deleted: " + rowsDeleted));
        }
        return rowsDeleted;
    }

    public void deleteEventsWithMismatchAppId(String appId) {
        this.getWritableDatabase().delete(TABLE_EVENT, "app_id!= ?", new String[]{appId});
    }

    void deleteSentEvents(long visitorId, long sessionId, int sequenceNumber, int serverId, long rowId) {
        int rowsDeleted = this.getWritableDatabase().delete(TABLE_EVENT, "visitor_id= ? AND session_id= ? AND sequence_nr= ? AND server_id= ? AND id<= ?", new String[]{String.valueOf(visitorId), String.valueOf(sessionId), String.valueOf(sequenceNumber), String.valueOf(serverId), String.valueOf(rowId)});
        if (Global.DEBUG) {
            Utility.zlogD((String)TAG, (String)("Rows removed: " + rowsDeleted));
        }
    }

    void deleteEventsFromVisit(long visitorId, long sessionId) {
        this.getWritableDatabase().delete(TABLE_EVENT, "visitor_id= ? AND session_id= ?", new String[]{String.valueOf(visitorId), String.valueOf(sessionId)});
    }

    boolean deleteAllEvents() {
        return this.getWritableDatabase().delete(TABLE_EVENT, null, null) > 0;
    }

    public Cursor fetchEvents() {
        return this.fetchEvents(0L);
    }

    public Cursor fetchEvents(long minRowId) {
        String[] cols = new String[]{COLUMN_ROW_ID, COLUMN_VISITOR_ID, COLUMN_SESSION_ID, COLUMN_SEQUENCE_NUMBER, COLUMN_BASIC_SEGMENT, COLUMN_EVENT_SEGMENT, COLUMN_EVENT_ID, COLUMN_SESSION_START, COLUMN_EVENT_START, COLUMN_MULTIPLICITY, COLUMN_SERVER_ID, COLUMN_APP_ID, COLUMN_SR_PARAM};
        return this.getReadableDatabase().query(true, TABLE_EVENT, cols, "id >= " + minRowId, null, null, null, "visitor_id ASC, session_id ASC, sequence_nr ASC, server_id ASC, id ASC", null);
    }

    public boolean updateSrAndMultiplicity(Session session) {
        ContentValues cvArgs = new ContentValues();
        cvArgs.put(COLUMN_MULTIPLICITY, Integer.valueOf(session.multiplicity));
        cvArgs.put(COLUMN_SR_PARAM, session.srBasicParam);
        return this.getWritableDatabase().update(TABLE_EVENT, cvArgs, "visitor_id= ? AND session_id= ?", new String[]{String.valueOf(session.visitorId), String.valueOf(session.sessionId)}) > 0;
    }
}

