/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.comm.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SimpleX509TrustManager
implements X509TrustManager {
    private X509TrustManager myTrustManager = null;
    private X509Certificate[] acceptedIssuers = null;

    public SimpleX509TrustManager(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore);
        this.myTrustManager = this.findX509TrustManager(factory);
        if (this.myTrustManager == null) {
            throw new NoSuchAlgorithmException("no trust manager found");
        }
        this.acceptedIssuers = this.myTrustManager.getAcceptedIssuers();
    }

    private X509TrustManager findX509TrustManager(TrustManagerFactory factory) {
        TrustManager[] trustmanagers = factory.getTrustManagers();
        for (int i = 0; i < trustmanagers.length; ++i) {
            if (!(trustmanagers[i] instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustmanagers[i];
        }
        return null;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.myTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain != null && chain.length == 1 && chain[0] != null) {
            chain[0].checkValidity();
            X509Certificate[] certs = this.getAcceptedIssuers();
            if (certs != null) {
                for (int i = 0; i < certs.length; ++i) {
                    if (!chain[0].equals(certs[i])) continue;
                    return;
                }
            }
        }
        this.myTrustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }
}

