/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.conf.RageTapConfiguration;
import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;

public class ServerConfiguration {
    public static final int NU_POST_SIZE = 5;
    public static final boolean DEFAULT_SELFMONITORING = true;
    public static final int DEFAULT_SEND_INTERVAL_SEC = 120;
    public static final int DEFAULT_MAX_CACHED_CRASHES = 0;
    public static final int DEFAULT_CAPTURE = 1;
    public static final int DEFAULT_TRAFFIC_CONTROL_PERCENTAGE = 100;
    public static final boolean DEFAULT_BP4_ENABLED = false;
    public static final int DEFAULT_MULTIPLICITY = 1;
    public static final int DEFAULT_SERVERID = 1;
    public static final boolean DEFAULT_SWITCH_SERVER = false;
    public static final int DEFAULT_MAX_BEACON_SIZE_KB_SAAS = 150;
    public static final int DEFAULT_MAX_BEACON_SIZE_KB_APPMON = 30;
    private static final Status DEFAULT_STATUS = Status.OK;
    private final int maxBeaconSizeKb;
    private final boolean selfmonitoring;
    private final SessionSplitConfiguration sessionSplitConfiguration;
    private final int sendIntervalSec;
    private final int maxCachedCrashesCount;
    private final RageTapConfiguration rageTapConfiguration;
    private final int capture;
    private final int trafficControlPercentage;
    private final boolean bp4Enabled;
    private final ReplayConfiguration replayConfiguration;
    private final int multiplicity;
    private final int serverId;
    private final boolean switchServer;
    private final Status status;
    private final long timestamp;

    private ServerConfiguration(Builder builder) {
        this.maxBeaconSizeKb = builder.maxBeaconSizeKb;
        this.selfmonitoring = builder.selfmonitoring;
        this.sessionSplitConfiguration = builder.sessionSplitConfiguration;
        this.sendIntervalSec = builder.sendIntervalSec;
        this.maxCachedCrashesCount = builder.maxCachedCrashesCount;
        this.rageTapConfiguration = builder.rageTapConfiguration;
        this.capture = builder.capture;
        this.trafficControlPercentage = builder.trafficControlPercentage;
        this.replayConfiguration = builder.replayConfiguration;
        this.bp4Enabled = builder.bp4Enabled;
        this.multiplicity = builder.multiplicity;
        this.serverId = builder.serverId;
        this.switchServer = builder.switchServer;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long maxSendLength() {
        return (long)this.maxBeaconSizeKb * 1024L - 5L;
    }

    public int getMaxBeaconSizeKb() {
        return this.maxBeaconSizeKb;
    }

    public boolean isSelfmonitoring() {
        return this.selfmonitoring;
    }

    public SessionSplitConfiguration getSessionSplitConfiguration() {
        return this.sessionSplitConfiguration;
    }

    public int getSendIntervalSec() {
        return this.sendIntervalSec;
    }

    public int getMaxCachedCrashesCount() {
        return this.maxCachedCrashesCount;
    }

    public RageTapConfiguration getRageTapConfiguration() {
        return this.rageTapConfiguration;
    }

    public boolean isCachingCrashes() {
        return this.maxCachedCrashesCount > 0;
    }

    public int getCapture() {
        return this.capture;
    }

    public boolean isCaptureOn() {
        return this.capture == 1;
    }

    public int getTrafficControlPercentage() {
        return this.trafficControlPercentage;
    }

    public boolean isBp4Enabled() {
        return this.bp4Enabled;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public int getServerId() {
        return this.serverId;
    }

    public boolean isSwitchServer() {
        return this.switchServer;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public ReplayConfiguration getReplayConfiguration() {
        return this.replayConfiguration;
    }

    public Builder newBuilder(boolean useDefaultDynamicConfig) {
        return new Builder(this, useDefaultDynamicConfig);
    }

    public Builder newBuilder() {
        return this.newBuilder(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfiguration serverConfig = (ServerConfiguration)o;
        return this.maxBeaconSizeKb == serverConfig.maxBeaconSizeKb && this.selfmonitoring == serverConfig.selfmonitoring && this.sessionSplitConfiguration.equals(serverConfig.sessionSplitConfiguration) && this.sendIntervalSec == serverConfig.sendIntervalSec && this.maxCachedCrashesCount == serverConfig.maxCachedCrashesCount && this.rageTapConfiguration.equals(serverConfig.rageTapConfiguration) && this.capture == serverConfig.capture && this.trafficControlPercentage == serverConfig.trafficControlPercentage && this.bp4Enabled == serverConfig.bp4Enabled && this.replayConfiguration.equals(serverConfig.replayConfiguration) && this.multiplicity == serverConfig.multiplicity && this.serverId == serverConfig.serverId && this.switchServer == serverConfig.switchServer && this.timestamp == serverConfig.timestamp && this.status == serverConfig.status;
    }

    public int hashCode() {
        int result = this.maxBeaconSizeKb;
        result = 31 * result + (this.selfmonitoring ? 1 : 0);
        result = 31 * result + this.sessionSplitConfiguration.hashCode();
        result = 31 * result + this.sendIntervalSec;
        result = 31 * result + this.maxCachedCrashesCount;
        result = 31 * result + this.rageTapConfiguration.hashCode();
        result = 31 * result + this.capture;
        result = 31 * result + this.trafficControlPercentage;
        result = 31 * result + (this.bp4Enabled ? 1 : 0);
        result = 31 * result + this.replayConfiguration.hashCode();
        result = 31 * result + this.multiplicity;
        result = 31 * result + this.serverId;
        result = 31 * result + (this.switchServer ? 1 : 0);
        result = 31 * result + this.status.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "ServerConfiguration{maxBeaconSizeKb=" + this.maxBeaconSizeKb + ", selfmonitoring=" + this.selfmonitoring + ", sessionSplitConfiguration=" + this.sessionSplitConfiguration + ", sendIntervalSec=" + this.sendIntervalSec + ", maxCachedCrashesCount=" + this.maxCachedCrashesCount + ", rageTapConfiguration=" + this.rageTapConfiguration + ", capture=" + this.capture + ", trafficControlPercentage=" + this.trafficControlPercentage + ", bp4Enabled=" + this.bp4Enabled + ", replayConfiguration=" + this.replayConfiguration + ", multiplicity=" + this.multiplicity + ", serverId=" + this.serverId + ", switchServer=" + this.switchServer + ", status=" + (Object)((Object)this.status) + ", timestamp=" + this.timestamp + '}';
    }

    public static class Builder {
        private int maxBeaconSizeKb;
        private boolean selfmonitoring;
        private SessionSplitConfiguration sessionSplitConfiguration;
        private int sendIntervalSec;
        private int maxCachedCrashesCount;
        private RageTapConfiguration rageTapConfiguration;
        private int capture;
        private int trafficControlPercentage;
        private boolean bp4Enabled;
        private ReplayConfiguration replayConfiguration;
        private int multiplicity;
        private int serverId;
        private boolean switchServer;
        private Status status;
        private long timestamp;

        public Builder() {
            this.maxBeaconSizeKb = 150;
            this.selfmonitoring = true;
            this.sessionSplitConfiguration = SessionSplitConfiguration.DEFAULT_SESSION_SPLIT_CONFIGURATION;
            this.sendIntervalSec = 120;
            this.maxCachedCrashesCount = 0;
            this.rageTapConfiguration = RageTapConfiguration.DEFAULT_RAGE_TAP_CONFIGURATION;
            this.capture = 1;
            this.trafficControlPercentage = 100;
            this.bp4Enabled = false;
            this.replayConfiguration = ReplayConfiguration.DEFAULT_REPLAY_CONFIGURATION;
            this.multiplicity = 1;
            this.serverId = 1;
            this.switchServer = false;
            this.status = DEFAULT_STATUS;
            this.timestamp = 0L;
        }

        public Builder(ServerConfiguration oldServerConfig, boolean useDefaultDynamicConfig) {
            this.maxBeaconSizeKb = oldServerConfig.maxBeaconSizeKb;
            this.selfmonitoring = oldServerConfig.selfmonitoring;
            this.sessionSplitConfiguration = oldServerConfig.sessionSplitConfiguration;
            this.sendIntervalSec = oldServerConfig.sendIntervalSec;
            this.maxCachedCrashesCount = oldServerConfig.maxCachedCrashesCount;
            this.rageTapConfiguration = oldServerConfig.rageTapConfiguration;
            this.capture = oldServerConfig.capture;
            this.trafficControlPercentage = oldServerConfig.trafficControlPercentage;
            this.bp4Enabled = oldServerConfig.bp4Enabled;
            this.replayConfiguration = oldServerConfig.replayConfiguration.newBuilder().build();
            this.timestamp = oldServerConfig.timestamp;
            if (useDefaultDynamicConfig) {
                this.multiplicity = 1;
                this.serverId = 1;
                this.switchServer = false;
                this.status = DEFAULT_STATUS;
            } else {
                this.multiplicity = oldServerConfig.multiplicity;
                this.serverId = oldServerConfig.serverId;
                this.switchServer = oldServerConfig.switchServer;
                this.status = oldServerConfig.status;
            }
        }

        public Builder(ServerConfiguration oldServerConfig) {
            this(oldServerConfig, false);
        }

        public ServerConfiguration build() {
            return new ServerConfiguration(this);
        }

        public Builder withMaxBeaconSizeKb(int maxBeaconSizeKb) {
            this.maxBeaconSizeKb = maxBeaconSizeKb;
            return this;
        }

        public Builder withSelfmonitoring(boolean selfmonitoring) {
            this.selfmonitoring = selfmonitoring;
            return this;
        }

        public Builder withSessionSplitConfiguration(SessionSplitConfiguration sessionSplitConfiguration) {
            this.sessionSplitConfiguration = sessionSplitConfiguration;
            return this;
        }

        public Builder withSendIntervalSec(int sendIntervalSec) {
            this.sendIntervalSec = sendIntervalSec;
            return this;
        }

        public Builder withMaxCachedCrashesCount(int maxCachedCrashesCount) {
            this.maxCachedCrashesCount = maxCachedCrashesCount;
            return this;
        }

        public Builder withRageTapConfiguration(RageTapConfiguration rageTapConfiguration) {
            this.rageTapConfiguration = rageTapConfiguration;
            return this;
        }

        public Builder withCapture(int capture) {
            this.capture = capture;
            return this;
        }

        public Builder withCaptureOff() {
            this.capture = 0;
            return this;
        }

        public Builder withTrafficControlPercentage(int trafficControlPercentage) {
            this.trafficControlPercentage = trafficControlPercentage;
            return this;
        }

        public Builder withBp4Enabled(boolean bp4Enabled) {
            this.bp4Enabled = bp4Enabled;
            return this;
        }

        public Builder withMultiplicity(int multiplicity) {
            this.multiplicity = multiplicity;
            return this;
        }

        public Builder withServerId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withSwitchServer(boolean switchServer) {
            this.switchServer = switchServer;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withReplayConfiguration(ReplayConfiguration replayConfiguration) {
            this.replayConfiguration = replayConfiguration;
            return this;
        }
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

