/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.lifecycle.DisplaySegment;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.SegmentFactory;
import com.dynatrace.android.lifecycle.SimpleClassNameGenerator;
import com.dynatrace.android.lifecycle.action.LifecycleAction;
import com.dynatrace.android.lifecycle.event.ActivityEventType;
import java.util.Map;

public class DisplaySegmentFactory
implements SegmentFactory<LifecycleAction<ActivityEventType>, DisplaySegment> {
    private static final String LOG_TAG = Global.LOG_PREFIX + "DisplaySegmentFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisplaySegment createSegment(LifecycleAction<ActivityEventType> action, Session session, int serverId) {
        LifecycleAction<ActivityEventType> lifecycleAction = action;
        synchronized (lifecycleAction) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "captured lifecycle action: " + action);
            }
            Map<ActivityEventType, MeasurementPoint> events = action.getLifecycleEvents();
            long absoluteSessionStartTime = session.getSessionStartTime();
            long absoluteActionStartTime = action.getStartPoint().getTimestamp();
            MeasurementPoint relativeActionStartPoint = DisplaySegmentFactory.toRelativeMeasurementPoint(absoluteSessionStartTime, action.getStartPoint());
            SimpleClassNameGenerator nameCustomizer = new SimpleClassNameGenerator();
            return new DisplaySegment.Builder().withLifecycleOwner(nameCustomizer.customize(action.getName())).withSession(session).withServerId(serverId).withParentActionId(action.getParentAction() != null ? action.getParentAction().getTagId() : 0L).withEventType(events.containsKey((Object)ActivityEventType.ON_CREATE) ? EventType.DISPLAY : EventType.REDISPLAY).withActionCreationPoint(relativeActionStartPoint).withCreateEvent(DisplaySegmentFactory.toRelativeMeasurementPoint(absoluteActionStartTime, events.get((Object)ActivityEventType.ON_CREATE))).withStartEvent(DisplaySegmentFactory.toRelativeMeasurementPoint(absoluteActionStartTime, events.get((Object)ActivityEventType.ON_START))).withResumeEvent(DisplaySegmentFactory.toRelativeMeasurementPoint(absoluteActionStartTime, events.get((Object)ActivityEventType.ON_RESUME))).withEndPoint(DisplaySegmentFactory.toRelativeMeasurementPoint(absoluteActionStartTime, action.getEndPoint())).withForwardToGrail(true).build();
        }
    }

    private static MeasurementPoint toRelativeMeasurementPoint(long absoluteBaseTime, MeasurementPoint timeToAdjust) {
        if (timeToAdjust == null) {
            return null;
        }
        return new MeasurementPoint(timeToAdjust.getTimestamp() - absoluteBaseTime, timeToAdjust.getSequenceNumber());
    }
}

