/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.eventsapi;

public class EventMetrics {
    private final String applicationId;
    private final String agentVersion;
    private final String agentTechnologyType;
    private final String agentFlavor;
    private final String deviceManufacturer;
    private final String deviceModelIdentifier;
    private final boolean deviceIsRooted;
    private final String osName;
    private final String osVersion;
    private final String appVersion;
    private final String appShortVersion;
    private final String appBundle;
    private final String instanceId;
    private final String sessionId;
    private final Integer deviceBatteryLevel;
    private final String windowOrientation;
    private final String schemaVersion;

    private EventMetrics(Builder builder) {
        this.applicationId = builder.applicationId;
        this.instanceId = builder.instanceId;
        this.sessionId = builder.sessionId;
        this.agentVersion = builder.agentVersion;
        this.agentTechnologyType = builder.agentTechnologyType;
        this.agentFlavor = builder.agentFlavor;
        this.deviceManufacturer = builder.deviceManufacturer;
        this.deviceModelIdentifier = builder.deviceModelIdentifier;
        this.deviceBatteryLevel = builder.deviceBatteryLevel;
        this.deviceIsRooted = builder.deviceIsRooted;
        this.windowOrientation = builder.windowOrientation;
        this.osName = builder.osName;
        this.osVersion = builder.osVersion;
        this.appVersion = builder.appVersion;
        this.appShortVersion = builder.appShortVersion;
        this.appBundle = builder.appBundle;
        this.schemaVersion = builder.schemaVersion;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getAgentTechnologyType() {
        return this.agentTechnologyType;
    }

    public String getAgentFlavor() {
        return this.agentFlavor;
    }

    public String getDeviceManufacturer() {
        return this.deviceManufacturer;
    }

    public String getDeviceModelIdentifier() {
        return this.deviceModelIdentifier;
    }

    public Integer getDeviceBatteryLevel() {
        return this.deviceBatteryLevel;
    }

    public boolean isDeviceRooted() {
        return this.deviceIsRooted;
    }

    public String getWindowOrientation() {
        return this.windowOrientation;
    }

    public String getOsName() {
        return this.osName;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppShortVersion() {
        return this.appShortVersion;
    }

    public String getAppBundle() {
        return this.appBundle;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventMetrics that = (EventMetrics)o;
        if (this.deviceIsRooted != that.deviceIsRooted) {
            return false;
        }
        if (this.applicationId != null ? !this.applicationId.equals(that.applicationId) : that.applicationId != null) {
            return false;
        }
        if (this.agentVersion != null ? !this.agentVersion.equals(that.agentVersion) : that.agentVersion != null) {
            return false;
        }
        if (this.agentTechnologyType != null ? !this.agentTechnologyType.equals(that.agentTechnologyType) : that.agentTechnologyType != null) {
            return false;
        }
        if (this.agentFlavor != null ? !this.agentFlavor.equals(that.agentFlavor) : that.agentFlavor != null) {
            return false;
        }
        if (this.deviceManufacturer != null ? !this.deviceManufacturer.equals(that.deviceManufacturer) : that.deviceManufacturer != null) {
            return false;
        }
        if (this.deviceModelIdentifier != null ? !this.deviceModelIdentifier.equals(that.deviceModelIdentifier) : that.deviceModelIdentifier != null) {
            return false;
        }
        if (this.osName != null ? !this.osName.equals(that.osName) : that.osName != null) {
            return false;
        }
        if (this.osVersion != null ? !this.osVersion.equals(that.osVersion) : that.osVersion != null) {
            return false;
        }
        if (this.appVersion != null ? !this.appVersion.equals(that.appVersion) : that.appVersion != null) {
            return false;
        }
        if (this.appShortVersion != null ? !this.appShortVersion.equals(that.appShortVersion) : that.appShortVersion != null) {
            return false;
        }
        if (this.appBundle != null ? !this.appBundle.equals(that.appBundle) : that.appBundle != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.sessionId != null ? !this.sessionId.equals(that.sessionId) : that.sessionId != null) {
            return false;
        }
        if (this.deviceBatteryLevel != null ? !this.deviceBatteryLevel.equals(that.deviceBatteryLevel) : that.deviceBatteryLevel != null) {
            return false;
        }
        if (this.schemaVersion != null ? !this.schemaVersion.equals(that.schemaVersion) : that.schemaVersion != null) {
            return false;
        }
        return this.windowOrientation != null ? this.windowOrientation.equals(that.windowOrientation) : that.windowOrientation == null;
    }

    public int hashCode() {
        int result = this.applicationId != null ? this.applicationId.hashCode() : 0;
        result = 31 * result + (this.agentVersion != null ? this.agentVersion.hashCode() : 0);
        result = 31 * result + (this.agentTechnologyType != null ? this.agentTechnologyType.hashCode() : 0);
        result = 31 * result + (this.agentFlavor != null ? this.agentFlavor.hashCode() : 0);
        result = 31 * result + (this.deviceManufacturer != null ? this.deviceManufacturer.hashCode() : 0);
        result = 31 * result + (this.deviceModelIdentifier != null ? this.deviceModelIdentifier.hashCode() : 0);
        result = 31 * result + (this.deviceIsRooted ? 1 : 0);
        result = 31 * result + (this.osName != null ? this.osName.hashCode() : 0);
        result = 31 * result + (this.osVersion != null ? this.osVersion.hashCode() : 0);
        result = 31 * result + (this.appVersion != null ? this.appVersion.hashCode() : 0);
        result = 31 * result + (this.appShortVersion != null ? this.appShortVersion.hashCode() : 0);
        result = 31 * result + (this.appBundle != null ? this.appBundle.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.sessionId != null ? this.sessionId.hashCode() : 0);
        result = 31 * result + (this.deviceBatteryLevel != null ? this.deviceBatteryLevel.hashCode() : 0);
        result = 31 * result + (this.windowOrientation != null ? this.windowOrientation.hashCode() : 0);
        result = 31 * result + (this.schemaVersion != null ? this.schemaVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EventMetrics{applicationId='" + this.applicationId + '\'' + ", agentVersion='" + this.agentVersion + '\'' + ", agentTechnologyType='" + this.agentTechnologyType + '\'' + ", agentFlavor='" + this.agentFlavor + '\'' + ", deviceManufacturer='" + this.deviceManufacturer + '\'' + ", deviceModelIdentifier='" + this.deviceModelIdentifier + '\'' + ", deviceIsRooted=" + this.deviceIsRooted + ", osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", appVersion='" + this.appVersion + '\'' + ", appShortVersion='" + this.appShortVersion + '\'' + ", appBundle='" + this.appBundle + '\'' + ", instanceId='" + this.instanceId + '\'' + ", sessionId='" + this.sessionId + '\'' + ", deviceBatteryLevel=" + this.deviceBatteryLevel + ", windowOrientation='" + this.windowOrientation + '\'' + ", schemaVersion='" + this.schemaVersion + '\'' + '}';
    }

    public static class Builder {
        private String applicationId;
        private String instanceId;
        private String sessionId;
        private String agentVersion;
        private String agentTechnologyType;
        private String agentFlavor;
        private String deviceManufacturer;
        private String deviceModelIdentifier;
        private Integer deviceBatteryLevel;
        private boolean deviceIsRooted;
        private String windowOrientation;
        private String osName;
        private String osVersion;
        private String appVersion;
        private String appShortVersion;
        private String appBundle;
        private String schemaVersion;

        public Builder withApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public Builder withAgentTechnologyType(String agentTechnologyType) {
            this.agentTechnologyType = agentTechnologyType;
            return this;
        }

        public Builder withAgentFlavor(String agentFlavor) {
            this.agentFlavor = agentFlavor;
            return this;
        }

        public Builder withDeviceManufacturer(String deviceManufacturer) {
            this.deviceManufacturer = deviceManufacturer;
            return this;
        }

        public Builder withDeviceModelIdentifier(String deviceModelIdentifier) {
            this.deviceModelIdentifier = deviceModelIdentifier;
            return this;
        }

        public Builder withDeviceBatteryLevel(Integer deviceBatteryLevel) {
            this.deviceBatteryLevel = deviceBatteryLevel;
            return this;
        }

        public Builder withDeviceRooted(boolean deviceIsRooted) {
            this.deviceIsRooted = deviceIsRooted;
            return this;
        }

        public Builder withWindowOrientation(String windowOrientation) {
            this.windowOrientation = windowOrientation;
            return this;
        }

        public Builder withOsName(String osName) {
            this.osName = osName;
            return this;
        }

        public Builder withOsVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder withAppVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder withAppShortVersion(String appShortVersion) {
            this.appShortVersion = appShortVersion;
            return this;
        }

        public Builder withAppBundle(String appBundle) {
            this.appBundle = appBundle;
            return this;
        }

        public Builder withSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public EventMetrics build() {
            return new EventMetrics(this);
        }
    }
}

