/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.comm;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.Version;
import com.dynatrace.android.agent.comm.CommHandler;
import com.dynatrace.android.agent.comm.HttpResponse;
import com.dynatrace.android.agent.comm.InvalidConfigurationException;
import com.dynatrace.android.agent.comm.InvalidResponseException;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationParser;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;

public class RequestExecutor {
    public static final String APPMON_DEFAULT_MONITOR = "dynaTraceMonitor";
    private static final String TAG = Global.LOG_PREFIX + "RequestExecutor";
    private static final int BEACON_MAX_ATTEMPTS = 3;
    private AtomicInteger failedBeaconAttempts = new AtomicInteger(0);
    private String monitor;
    private String serverUrl;
    private Configuration configuration;
    private CommHandler commHandler;
    private ServerConfigurationParser settingsParser;

    public RequestExecutor(CommHandler commHandler, Configuration configuration, ServerConfigurationParser settingsParser) {
        this.configuration = configuration;
        this.commHandler = commHandler;
        this.settingsParser = settingsParser;
        if (configuration.mode == AgentMode.SAAS) {
            this.serverUrl = configuration.getServerUrl();
        } else {
            this.monitor = AdkSettings.getInstance().preferencesManager.getBeacon();
            this.serverUrl = configuration.getServerUrl() + "/" + this.monitor;
        }
    }

    String getUriParms(ServerConfiguration currentServerConfig, boolean isNewSession, int serverId, long visitorId, long sessionId) {
        StringBuilder sb = new StringBuilder(this.serverUrl);
        sb.append("?");
        sb.append("type");
        sb.append("=");
        sb.append("m");
        sb.append("&");
        sb.append("srvid").append("=").append(serverId);
        sb.append("&");
        sb.append("app").append("=").append(AdkSettings.appIdEncoded);
        sb.append("&");
        sb.append("va").append("=").append(Utility.urlEncode(Version.getFullVersion()));
        sb.append("&");
        sb.append("tt").append("=").append("maandroid");
        sb.append("&");
        sb.append("pt").append("=").append("0");
        if (this.configuration.mode == AgentMode.SAAS) {
            sb.append("&");
            sb.append("resp").append("=").append("json");
            sb.append("&");
            sb.append("cts").append("=").append(currentServerConfig.getTimestamp());
        }
        if (isNewSession) {
            sb.append("&").append("ns").append("=").append("1");
        }
        sb.append("&").append("si").append("=").append(visitorId).append("_").append(sessionId);
        return sb.toString();
    }

    public ServerConfiguration sendBeacon(ServerConfiguration currentServerConfig, boolean newSession, int serverId, Session session) throws Exception {
        return this.handleBeaconRequest(currentServerConfig, newSession, null, serverId, session.visitorId, session.sessionId, false);
    }

    public ServerConfiguration sendData(ServerConfiguration currentServerConfig, String data, int serverId, long visitorId, long sessionId, boolean outstandingData) throws Exception {
        return this.handleBeaconRequest(currentServerConfig, false, data, serverId, visitorId, sessionId, outstandingData);
    }

    private ServerConfiguration handleBeaconRequest(ServerConfiguration currentServerConfig, boolean newSession, String data, int serverId, long visitorId, long sessionId, boolean outstandingData) throws Exception {
        HttpResponse response = this.commHandler.executeRequest(this.getUriParms(currentServerConfig, newSession, serverId, visitorId, sessionId), data, outstandingData);
        if (response.isSuccessful()) {
            return this.processConfigResponse(currentServerConfig, response);
        }
        if (response.responseCode == 404) {
            this.handleInvalidBeacon();
        }
        throw new InvalidResponseException("invalid response code " + response.responseCode, response);
    }

    ServerConfiguration processConfigResponse(ServerConfiguration currentServerConfig, HttpResponse response) throws InvalidResponseException {
        ServerConfiguration newServerConfig;
        if (response == null || response.body == null) {
            throw new InvalidResponseException("no message body", response);
        }
        if (response.body.startsWith("{")) {
            if (this.configuration.mode == AgentMode.APP_MON) {
                throw new InvalidResponseException("invalid configuration format", response);
            }
            try {
                newServerConfig = this.settingsParser.fromJSON(currentServerConfig, response.body);
            }
            catch (InvalidConfigurationException | ClassCastException | JSONException e) {
                throw new InvalidResponseException("invalid message protocol", e, response);
            }
        } else {
            Map<String, String> keyValueConfig = Utility.parseKeyValueString(response.body);
            if (keyValueConfig == null || !"m".equals(keyValueConfig.get("type"))) {
                throw new InvalidResponseException("invalid message protocol", response);
            }
            newServerConfig = this.settingsParser.fromMap(keyValueConfig, this.configuration.mode);
            if (this.configuration.mode == AgentMode.APP_MON) {
                this.setMonitor(keyValueConfig.get("bn"));
            }
        }
        return newServerConfig;
    }

    private void setMonitor(String _monitor) {
        if (_monitor == null || _monitor.length() <= 0 || this.failedBeaconAttempts.get() > 3) {
            _monitor = APPMON_DEFAULT_MONITOR;
        } else if (Global.DEBUG) {
            Utility.zlogD(TAG, String.format("Setting dtMonitor: %s attempt: %s ", _monitor, this.failedBeaconAttempts.get()));
        }
        if (_monitor.equals(this.monitor)) {
            return;
        }
        this.monitor = _monitor;
        this.serverUrl = this.configuration.getServerUrl() + "/" + this.monitor;
        AdkSettings.getInstance().preferencesManager.setBeacon(this.monitor);
    }

    public void resetBeaconRetries() {
        this.failedBeaconAttempts.set(0);
    }

    private void handleInvalidBeacon() {
        if (this.configuration.mode == AgentMode.APP_MON && !APPMON_DEFAULT_MONITOR.equals(this.monitor)) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, String.format("Resetting beacon signal (%s) to (%s)", this.monitor, APPMON_DEFAULT_MONITOR));
            }
            this.monitor = APPMON_DEFAULT_MONITOR;
            AdkSettings.getInstance().preferencesManager.removeBeacon();
            this.failedBeaconAttempts.incrementAndGet();
        }
    }
}

