/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.measure;

import android.view.MotionEvent;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.ragetap.detection.RageTapDetector;
import com.dynatrace.android.ragetap.detection.TapData;
import com.dynatrace.android.ragetap.detection.TapEventData;
import com.dynatrace.android.ragetap.measure.MotionEventConverter;
import com.dynatrace.android.window.OnTouchEventListener;

public class TapMonitor
implements OnTouchEventListener {
    private static final String LOG_TAG = Global.LOG_PREFIX + "TapMonitor";
    private final RageTapDetector detector;
    private final MotionEventConverter converter;
    private final TimeLineProvider timeLineProvider;
    private State state = State.NO_TAP;
    private TapEventData tapDown;

    public TapMonitor(RageTapDetector detector, MotionEventConverter converter, TimeLineProvider timeLineProvider) {
        this.detector = detector;
        this.converter = converter;
        this.timeLineProvider = timeLineProvider;
    }

    @Override
    public void onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 0: {
                long timestamp = this.timeLineProvider.now();
                this.tapDown = this.converter.convertToTapEvent(motionEvent, timestamp);
                this.state = State.TAP_DOWN;
                break;
            }
            case 1: {
                if (this.state == State.TAP_DOWN) {
                    long timestamp = this.timeLineProvider.now();
                    TapEventData tapUp = this.converter.convertToTapEvent(motionEvent, timestamp);
                    this.detector.onTapDetected(new TapData(this.tapDown, tapUp));
                }
                this.state = State.NO_TAP;
                this.tapDown = null;
                break;
            }
            case 2: {
                break;
            }
            case 5: 
            case 6: {
                if (this.state == State.TAP_DOWN) {
                    if (Global.DEBUG) {
                        Utility.zlogD(LOG_TAG, "multi-touch tap detected");
                    }
                    this.detector.evaluateAndReset();
                }
                this.state = State.INVALID_TAP_STATE;
                this.tapDown = null;
                break;
            }
            default: {
                if (!Global.DEBUG) break;
                Utility.zlogD(LOG_TAG, "unexpected event type detected: " + motionEvent.toString());
            }
        }
    }

    static enum State {
        NO_TAP,
        TAP_DOWN,
        INVALID_TAP_STATE;

    }
}

