/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.appstate;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.appstate.ApplicationStateListener;
import java.util.LinkedHashSet;

public class ApplicationStateTracker
implements Application.ActivityLifecycleCallbacks {
    private static final String LOG_TAG = Global.LOG_PREFIX + "ApplicationStateTracker";
    private final LinkedHashSet<ApplicationStateListener> applicationStateListeners = new LinkedHashSet();
    private int startedActivities = 0;
    private boolean isConfigurationChange = false;

    public void registerAppStateListener(ApplicationStateListener applicationStateListener) {
        if (applicationStateListener != null) {
            this.applicationStateListeners.add(applicationStateListener);
        }
    }

    public void unregisterAppStateListener(ApplicationStateListener applicationStateListener) {
        this.applicationStateListeners.remove(applicationStateListener);
    }

    LinkedHashSet<ApplicationStateListener> getApplicationStateListeners() {
        return this.applicationStateListeners;
    }

    public void onActivityStarted(Activity activity) {
        if (++this.startedActivities == 1 && !this.isConfigurationChange) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "app returns to foreground");
            }
            for (ApplicationStateListener listener : this.applicationStateListeners) {
                listener.onForeground();
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        this.isConfigurationChange = activity.isChangingConfigurations();
        if (this.startedActivities > 0) {
            --this.startedActivities;
        }
        if (this.startedActivities == 0 && !this.isConfigurationChange) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "app goes into background");
            }
            for (ApplicationStateListener listener : this.applicationStateListeners) {
                listener.onBackground();
            }
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

