/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.activitytracking;

import android.app.Application;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.lifecycle.activitytracking.ActiveActivityListener;
import com.dynatrace.android.lifecycle.activitytracking.ActiveActivityTracker;
import com.dynatrace.android.lifecycle.callback.ActivityComponentIdentifier;

public class ActiveActivityMonitor
implements ActiveActivityListener {
    private ActiveActivityTracker activityTracker;

    public void startMonitoring(Application application) {
        this.activityTracker = new ActiveActivityTracker(new ActivityComponentIdentifier(), this);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityTracker);
    }

    public void stopMonitoring(Application application) {
        if (this.activityTracker != null) {
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityTracker);
            this.activityTracker = null;
        }
    }

    @Override
    public void onActiveActivityChanged(String currentActivityName) {
        AndroidMetrics metrics = AndroidMetrics.getInstance();
        metrics.setCurrentActivityName(currentActivityName);
    }
}

