/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.cloudevents.v1;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.internal.api.cloudevents.v1.CloudEvent;
import java.util.HashMap;
import java.util.Map;

public class CloudEventSerializer {
    private static final String LOGTAG = Global.LOG_PREFIX + "CloudEventBuilder";
    private static final String CLOUD_EVENT_PREFIX = "{";
    private static final String CLOUD_EVENT_SUFFIX = "}";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String KEY_VALUE_PAIR_SEPARATOR = ",";
    private static final char JSON_STRING_PREFIX_AND_SUFFIX = '\"';
    private static final Map<Character, String> JSON_ESCAPED_CHARACTERS = new HashMap<Character, String>();
    private static final String NULL_LITERAL = "null";
    private static final String BOOLEAN_TRUE_LITERAL = "true";
    private static final String BOOLEAN_FALSE_LITERAL = "false";
    private final CloudEvent cloudEvent;

    public CloudEventSerializer(CloudEvent cloudEvent) {
        this.cloudEvent = cloudEvent;
    }

    public String serialize() {
        StringBuilder cloudEventBuilder = new StringBuilder();
        this.serializeMandatoryAttributes(cloudEventBuilder);
        this.serializeOptionalAttributes(cloudEventBuilder);
        this.serializeContextAttributes(cloudEventBuilder);
        this.serializeEventData(cloudEventBuilder);
        return CLOUD_EVENT_PREFIX + cloudEventBuilder.toString() + CLOUD_EVENT_SUFFIX;
    }

    private void serializeMandatoryAttributes(StringBuilder cloudEventBuilder) {
        this.appendKeyAndValue(cloudEventBuilder, "id", this.cloudEvent.getId());
        this.appendKeyAndValue(cloudEventBuilder, "source", this.cloudEvent.getSource());
        this.appendKeyAndValue(cloudEventBuilder, "specversion", this.cloudEvent.getSpecVersion());
        this.appendKeyAndValue(cloudEventBuilder, "type", this.cloudEvent.getType());
    }

    private void serializeOptionalAttributes(StringBuilder cloudEventBuilder) {
        if (this.cloudEvent.hasDataContentType()) {
            this.appendKeyAndValue(cloudEventBuilder, "datacontenttype", this.cloudEvent.getDataContentType());
        }
        if (this.cloudEvent.hasDataSchema()) {
            this.appendKeyAndValue(cloudEventBuilder, "dataschema", this.cloudEvent.getDataSchema());
        }
        if (this.cloudEvent.hasSubject()) {
            this.appendKeyAndValue(cloudEventBuilder, "subject", this.cloudEvent.getSubject());
        }
        if (this.cloudEvent.hasTime()) {
            this.appendKeyAndValue(cloudEventBuilder, "time", this.cloudEvent.getTime());
        }
    }

    private void serializeContextAttributes(StringBuilder cloudEventBuilder) {
        for (CloudEvent.ExtensionContextAttribute extensionContextAttribute : this.cloudEvent.getExtensionContextAttributes()) {
            if (extensionContextAttribute.getValue() == null) {
                this.appendKeyAndRawValue(cloudEventBuilder, extensionContextAttribute.getName(), NULL_LITERAL);
                continue;
            }
            if (extensionContextAttribute.getValue() instanceof String) {
                String stringValue = (String)extensionContextAttribute.getValue();
                this.appendKeyAndValue(cloudEventBuilder, extensionContextAttribute.getName(), stringValue);
                continue;
            }
            if (extensionContextAttribute.getValue() instanceof Boolean) {
                boolean booleanValue = (Boolean)extensionContextAttribute.getValue();
                this.appendKeyAndRawValue(cloudEventBuilder, extensionContextAttribute.getName(), booleanValue ? BOOLEAN_TRUE_LITERAL : BOOLEAN_FALSE_LITERAL);
                continue;
            }
            if (extensionContextAttribute.getValue() instanceof Number) {
                Number numberValue = (Number)extensionContextAttribute.getValue();
                this.appendKeyAndRawValue(cloudEventBuilder, extensionContextAttribute.getName(), numberValue.toString());
                continue;
            }
            if (!Global.DEBUG) continue;
            Utility.zlogD(LOGTAG, "Unsupported extension context attribute type " + extensionContextAttribute.getValue().getClass());
        }
    }

    private void serializeEventData(StringBuilder cloudEventBuilder) {
        if (this.cloudEvent.hasEventData()) {
            if ("application/json".equals(this.cloudEvent.getDataContentType())) {
                this.appendKeyAndRawValue(cloudEventBuilder, "data", this.cloudEvent.getEventData());
            } else {
                this.appendKeyAndValue(cloudEventBuilder, "data", this.cloudEvent.getEventData());
            }
        }
    }

    private void appendKeyAndValue(StringBuilder cloudEventBuilder, String attributeName, String attributeValue) {
        if (cloudEventBuilder.length() > 0) {
            cloudEventBuilder.append(KEY_VALUE_PAIR_SEPARATOR);
        }
        this.appendJsonEscapedString(cloudEventBuilder, attributeName);
        cloudEventBuilder.append(KEY_VALUE_SEPARATOR);
        this.appendJsonEscapedString(cloudEventBuilder, attributeValue);
    }

    private void appendKeyAndRawValue(StringBuilder cloudEventBuilder, String attributeName, String attributeValue) {
        if (cloudEventBuilder.length() > 0) {
            cloudEventBuilder.append(KEY_VALUE_PAIR_SEPARATOR);
        }
        this.appendJsonEscapedString(cloudEventBuilder, attributeName);
        cloudEventBuilder.append(KEY_VALUE_SEPARATOR).append(attributeValue);
    }

    private void appendJsonEscapedString(StringBuilder jsonStringBuilder, String unescapedString) {
        jsonStringBuilder.append('\"');
        for (int i = 0; i < unescapedString.length(); ++i) {
            char c = unescapedString.charAt(i);
            if (JSON_ESCAPED_CHARACTERS.containsKey(Character.valueOf(c))) {
                jsonStringBuilder.append(JSON_ESCAPED_CHARACTERS.get(Character.valueOf(c)));
                continue;
            }
            jsonStringBuilder.append(c);
        }
        jsonStringBuilder.append('\"');
    }

    static {
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\"'), "\\\"");
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\\'), "\\\\");
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\b'), "\\b");
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\f'), "\\f");
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\n'), "\\n");
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\r'), "\\r");
        JSON_ESCAPED_CHARACTERS.put(Character.valueOf('\t'), "\\t");
        for (char controlCharacter = '\u0000'; controlCharacter <= '\u001f'; controlCharacter = (char)(controlCharacter + '\u0001')) {
            if (JSON_ESCAPED_CHARACTERS.containsKey(Character.valueOf(controlCharacter))) continue;
            JSON_ESCAPED_CHARACTERS.put(Character.valueOf(controlCharacter), "\\u" + String.format("%04X", controlCharacter));
        }
    }
}

