/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.cloudevents.v1;

import com.dynatrace.android.internal.api.cloudevents.v1.CloudEvent;
import com.dynatrace.android.internal.api.cloudevents.v1.CloudEventBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CloudEventImpl
implements CloudEvent {
    private final String id;
    private final String source;
    private final String specVersion;
    private final String type;
    private final String dataContentType;
    private final String dataSchema;
    private final String subject;
    private final String time;
    private final List<CloudEvent.ExtensionContextAttribute> extensionContextAttributes;
    private final String data;

    public CloudEventImpl(CloudEventBuilder cloudEventBuilder) {
        this.id = cloudEventBuilder.getId();
        this.source = cloudEventBuilder.getSource();
        this.specVersion = cloudEventBuilder.getSpecVersion();
        this.type = cloudEventBuilder.getType();
        this.dataContentType = cloudEventBuilder.getDataContentType();
        this.dataSchema = cloudEventBuilder.getDataSchema();
        this.subject = cloudEventBuilder.getSubject();
        this.time = cloudEventBuilder.getTime();
        this.extensionContextAttributes = this.from(cloudEventBuilder.getExtensionContextAttributes());
        this.data = cloudEventBuilder.getData();
    }

    private List<CloudEvent.ExtensionContextAttribute> from(Map<String, Object> extensionContextAttributes) {
        ArrayList<ExtensionContextAttributeImpl> result = new ArrayList<ExtensionContextAttributeImpl>(extensionContextAttributes.size());
        for (Map.Entry<String, Object> attribute : extensionContextAttributes.entrySet()) {
            result.add(new ExtensionContextAttributeImpl(attribute.getKey(), attribute.getValue()));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean hasDataContentType() {
        return this.dataContentType != null;
    }

    @Override
    public String getDataContentType() {
        return this.dataContentType;
    }

    @Override
    public boolean hasDataSchema() {
        return this.dataSchema != null;
    }

    @Override
    public String getDataSchema() {
        return this.dataSchema;
    }

    @Override
    public boolean hasSubject() {
        return this.subject != null;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public boolean hasTime() {
        return this.time != null;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public List<CloudEvent.ExtensionContextAttribute> getExtensionContextAttributes() {
        return this.extensionContextAttributes;
    }

    @Override
    public boolean hasEventData() {
        return this.data != null;
    }

    @Override
    public String getEventData() {
        return this.data;
    }

    private static final class ExtensionContextAttributeImpl
    implements CloudEvent.ExtensionContextAttribute {
        private final String name;
        private final Object value;

        private ExtensionContextAttributeImpl(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }
}

