/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.ragetap;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.ragetap.RageTapSegment;
import com.dynatrace.android.agent.events.ragetap.RageTapSegmentFactory;
import com.dynatrace.android.agent.metrics.AndroidMetrics;
import com.dynatrace.android.lifecycle.SimpleClassNameGenerator;
import com.dynatrace.android.ragetap.detection.RageTap;
import com.dynatrace.android.ragetap.detection.RageTapListener;
import com.dynatrace.android.useraction.ActionNameCustomizer;

public class RageTapObserver
implements RageTapListener {
    private final RageTapSegmentFactory rageTapSegmentFactory = new RageTapSegmentFactory();
    private final ActionNameCustomizer activityNameCustomizer = new SimpleClassNameGenerator();

    @Override
    public void onRageTap(Session session, RageTap rageTap, boolean evaluateSessionSplit) {
        if (Dynatrace.getCaptureStatus()) {
            String activityName = AndroidMetrics.getInstance().getCurrentActivityName();
            String customizedName = activityName == null ? null : this.activityNameCustomizer.customize(activityName);
            Session curSession = Session.determineActiveSession(!evaluateSessionSplit, false);
            RageTapSegment segment = this.rageTapSegmentFactory.createSegment(rageTap, customizedName, curSession, AdkSettings.getInstance().serverId);
            Core.getCalloutTable().addOtherEvent();
            Core.saveSegment(segment);
        }
    }
}

