/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.lifecycle.AppStartSegment;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.SegmentFactory;
import com.dynatrace.android.lifecycle.SimpleClassNameGenerator;
import com.dynatrace.android.lifecycle.appstart.AppStartAction;

public class AppStartSegmentFactory
implements SegmentFactory<AppStartAction, AppStartSegment> {
    private static final String LOG_TAG = Global.LOG_PREFIX + "AppStartSegmentFactory";

    @Override
    public AppStartSegment createSegment(AppStartAction action, Session session, int serverId) {
        if (Global.DEBUG) {
            Utility.zlogD(LOG_TAG, "captured AppStart action: " + action);
        }
        long absoluteSessionStartTime = session.getSessionStartTime();
        long absoluteActionStartTime = action.getStartPoint().getTimestamp();
        MeasurementPoint relativeActionStartPoint = this.toRelativeMeasurementPoint(absoluteSessionStartTime, action.getStartPoint());
        String name = null;
        if (action.getName() != null) {
            SimpleClassNameGenerator nameCustomizer = new SimpleClassNameGenerator();
            name = nameCustomizer.customize(action.getName());
        }
        return new AppStartSegment.Builder().withActivityName(name).withSession(session).withServerId(serverId).withParentActionId(action.getParentAction() != null ? action.getParentAction().getTagId() : 0L).withEventType(EventType.APP_START).withStartPoint(relativeActionStartPoint).withEndPoint(this.toRelativeMeasurementPoint(absoluteActionStartTime, action.getEndPoint())).build();
    }

    private MeasurementPoint toRelativeMeasurementPoint(long absoluteBaseTime, MeasurementPoint timeToAdjust) {
        if (timeToAdjust == null) {
            return null;
        }
        return new MeasurementPoint(timeToAdjust.getTimestamp() - absoluteBaseTime, timeToAdjust.getSequenceNumber());
    }
}

