/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.callback;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.callback.CallbackCore;
import com.dynatrace.android.callback.CbConstants;
import com.dynatrace.android.callback.WebReqStateParms;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ConnStateParms
extends WebReqStateParms {
    private static final String LOGTAG = "caa-aConnStateParms";
    private static final Map<String, Integer> additionalHeader;
    private static final int BYTES_CONTENT_TYPE_HEADER;
    HttpURLConnection conn;

    ConnStateParms(HttpURLConnection conn, CbConstants.WrMethod method, CbConstants.WrStates state, int respCode) {
        super(method, state, respCode);
        this.conn = conn;
    }

    @Override
    String getRequestDesc() {
        if (this.desc != null) {
            return this.desc;
        }
        this.desc = "NA";
        if (this.conn != null) {
            this.desc = Utility.trimWebRequest((String)this.conn.getURL().toString());
        }
        return this.desc;
    }

    @Override
    String getRequestHost() {
        String host = "NA";
        if (this.conn != null) {
            host = this.conn.getURL().getHost();
        }
        return host;
    }

    @Override
    String getRequestMethod() {
        if (this.conn != null) {
            return this.conn.getRequestMethod();
        }
        return "NA";
    }

    @Override
    URL getUrl() {
        if (this.conn != null) {
            return this.conn.getURL();
        }
        return null;
    }

    @Override
    protected String getRequestClassName() {
        return this.getRequestClassName(this.conn);
    }

    void calcRequestBytes(boolean hasBody) {
        if (this.requestLength >= 0L) {
            return;
        }
        try {
            this.requestLength = this.calcRequestFirstLineLength(this.conn.getRequestMethod(), this.conn.getURL().getFile());
            Map<String, List<String>> headers = this.conn.getRequestProperties();
            this.requestLength += this.calcHeader(headers) + 2L;
            for (Map.Entry<String, Integer> entry : additionalHeader.entrySet()) {
                if (headers.containsKey(entry.getKey())) continue;
                this.requestLength += (long)(entry.getValue() + 2);
            }
            if (!headers.containsKey("Host")) {
                this.requestLength += (long)("Host".length() + this.conn.getURL().toURI().getAuthority().length() + 4);
            }
            if (hasBody && !headers.containsKey("Content-Type")) {
                this.requestLength += (long)BYTES_CONTENT_TYPE_HEADER;
            }
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"can't calculate request size", (Throwable)e);
            }
            this.requestLength = -1L;
        }
    }

    void calcResponseBytes() {
        if (this.responseLength >= 0L) {
            return;
        }
        try {
            this.responseLength = this.calcHeader(this.conn.getHeaderFields()) + 2L;
        }
        catch (Exception e) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"can't calculate request size", (Throwable)e);
            }
            this.responseLength = -1L;
        }
    }

    private int calcRequestFirstLineLength(String method, String file) {
        int requestLineLength = method.length() + 12;
        requestLineLength = file == null || file.length() < 1 ? ++requestLineLength : (requestLineLength += file.length());
        return requestLineLength;
    }

    private long calcHeader(Map<String, List<String>> headers) {
        long length = 0L;
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (header.getKey() == null) {
                if (header.getValue().size() <= 0) continue;
                length += (long)(header.getValue().get(0).length() + 2);
                continue;
            }
            if (header.getKey().startsWith("X-Android")) continue;
            long keyLength = header.getKey().length() + 4;
            for (String value : header.getValue()) {
                length += keyLength + (long)value.length();
            }
            if (!"Content-Length".equalsIgnoreCase(header.getKey()) || header.getValue().size() <= 0) continue;
            try {
                length += Long.parseLong(header.getValue().get(0));
            }
            catch (NumberFormatException e) {
                if (!Global.DEBUG) continue;
                Utility.zlogD((String)LOGTAG, (String)"invalid content length", (Throwable)e);
            }
        }
        return length;
    }

    public void evaluateServerTiming() {
        this.evaluateServerTiming(this.conn.getHeaderFields().get("Server-Timing"));
    }

    static {
        BYTES_CONTENT_TYPE_HEADER = "Content-Type: application/x-www-form-urlencoded".length() + 2;
        additionalHeader = new HashMap<String, Integer>();
        additionalHeader.put("User-Agent", "User-Agent: ".length() + CallbackCore.defaultUserAgent().length());
        additionalHeader.put("Connection", "Connection: keep-alive".length());
        additionalHeader.put("Accept-Encoding", "Accept-Encoding: gzip".length());
    }
}

