/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.api;

import com.dynatrace.agent.OneAgentEventDispatcher;
import com.dynatrace.agent.api.HttpRequestEventBuilder;
import com.dynatrace.agent.api.ViewContextApi;
import com.dynatrace.agent.api.internal.HttpRequestEventBuilderInternal;
import com.dynatrace.agent.di.SessionInformationProvider;
import com.dynatrace.agent.metrics.SessionInformationMetrics;
import com.dynatrace.agent.view.ViewContextManager;
import com.dynatrace.android.agent.util.Utility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/agent/api/OneAgentFacade;", "Lcom/dynatrace/agent/api/ViewContextApi;", "sessionInformationProvider", "Lcom/dynatrace/agent/di/SessionInformationProvider;", "viewContextManager", "Lcom/dynatrace/agent/view/ViewContextManager;", "eventDispatcher", "Lcom/dynatrace/agent/OneAgentEventDispatcher;", "<init>", "(Lcom/dynatrace/agent/di/SessionInformationProvider;Lcom/dynatrace/agent/view/ViewContextManager;Lcom/dynatrace/agent/OneAgentEventDispatcher;)V", "startView", "", "name", "", "stopView", "sendHttpRequestEvent", "httpRequestEventBuilder", "Lcom/dynatrace/agent/api/HttpRequestEventBuilder;", "isActiveGrailSession", "", "Lcom/dynatrace/agent/metrics/SessionInformationMetrics;", "com.dynatrace.agent_release"})
public final class OneAgentFacade
implements ViewContextApi {
    @NotNull
    private final SessionInformationProvider sessionInformationProvider;
    @NotNull
    private final ViewContextManager viewContextManager;
    @NotNull
    private final OneAgentEventDispatcher eventDispatcher;

    public OneAgentFacade(@NotNull SessionInformationProvider sessionInformationProvider, @NotNull ViewContextManager viewContextManager, @NotNull OneAgentEventDispatcher eventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)sessionInformationProvider, (String)"sessionInformationProvider");
        Intrinsics.checkNotNullParameter((Object)viewContextManager, (String)"viewContextManager");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        this.sessionInformationProvider = sessionInformationProvider;
        this.viewContextManager = viewContextManager;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void startView(@Nullable String name) {
        CharSequence charSequence;
        SessionInformationMetrics sessionInfo = this.sessionInformationProvider.collectSessionInfo();
        if (this.isActiveGrailSession(sessionInfo) && !((charSequence = (CharSequence)name) == null || charSequence.length() == 0)) {
            this.viewContextManager.storeContext(name);
        } else {
            Utility.devLog("dtxViewContext", "start view can't be executed, sessionInfo: " + sessionInfo + " name: " + name);
        }
    }

    @Override
    public void stopView() {
        SessionInformationMetrics sessionInfo = this.sessionInformationProvider.collectSessionInfo();
        if (this.isActiveGrailSession(sessionInfo)) {
            this.viewContextManager.clearContext();
        } else {
            Utility.devLog("dtxViewContext", "stop view can't be executed, sessionInfo: " + sessionInfo);
        }
    }

    public final void sendHttpRequestEvent(@NotNull HttpRequestEventBuilder httpRequestEventBuilder) {
        Intrinsics.checkNotNullParameter((Object)httpRequestEventBuilder, (String)"httpRequestEventBuilder");
        SessionInformationMetrics sessionInfo = this.sessionInformationProvider.collectSessionInfo();
        if (this.isActiveGrailSession(sessionInfo) && sessionInfo.getEventReporting()) {
            HttpRequestEventBuilderInternal.HttpRequestEvent requestEvent = httpRequestEventBuilder.build();
            if (requestEvent != null) {
                Utility.devLog("dtxEventGeneration", "sendHttpRequestEvent with request: " + requestEvent.getRequest() + " and properties: " + requestEvent.getEventProperties());
                this.eventDispatcher.dispatchEventWithRestrictions(requestEvent.getEventProperties(), requestEvent.getRequest(), sessionInfo, null);
            }
        } else {
            Utility.devLog("dtxEventGeneration", "sendHttpRequestEvent: event cannot be sent on this session, sessionInfo: " + sessionInfo);
        }
    }

    private final boolean isActiveGrailSession(SessionInformationMetrics $this$isActiveGrailSession) {
        return $this$isActiveGrailSession.isGrailEventsCanBeCaptured() && $this$isActiveGrailSession.getSessionActive();
    }
}

