/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.userinteraction.model;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import com.dynatrace.agent.userinteraction.model.TouchAction;
import com.dynatrace.agent.userinteraction.model.TouchEvent;
import com.dynatrace.agent.userinteraction.model.TouchEventKt;
import com.dynatrace.agent.userinteraction.model.TouchUserInteraction;
import com.dynatrace.agent.userinteraction.model.UiElement;
import com.dynatrace.agent.userinteraction.util.UserInteractionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\fH\u0002J\f\u0010\u0012\u001a\u00020\u0011*\u00020\fH\u0002J\f\u0010\u0013\u001a\u00020\u0011*\u00020\fH\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\fH\u0002J\f\u0010\u0015\u001a\u00020\u0011*\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/agent/userinteraction/model/TouchUserInteractionNativeGenerator;", "", "<init>", "()V", "generate", "Lcom/dynatrace/agent/userinteraction/model/TouchUserInteraction;", "touchList", "", "Lcom/dynatrace/agent/userinteraction/model/TouchEvent;", "rootView", "Landroid/view/ViewGroup;", "interactView", "Landroid/view/View;", "generate$com_dynatrace_agent_release", "getUiElement", "Lcom/dynatrace/agent/userinteraction/model/UiElement;", "getUIElementId", "", "getViewId", "getHierarchyPath", "getViewName", "getClassName", "Companion", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nTouchUserInteractionNativeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TouchUserInteractionNativeGenerator.kt\ncom/dynatrace/agent/userinteraction/model/TouchUserInteractionNativeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n774#2:117\n865#2,2:118\n774#2:120\n865#2,2:121\n1#3:123\n*S KotlinDebug\n*F\n+ 1 TouchUserInteractionNativeGenerator.kt\ncom/dynatrace/agent/userinteraction/model/TouchUserInteractionNativeGenerator\n*L\n28#1:117\n28#1:118,2\n29#1:120\n29#1:121,2\n*E\n"})
public final class TouchUserInteractionNativeGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DT_MASK_TAG = "dt_rum_masked";
    @NotNull
    private static final String MASKED_LABEL = "***";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TouchUserInteraction generate$com_dynatrace_agent_release(@NotNull List<TouchEvent> touchList, @NotNull ViewGroup rootView, @Nullable View interactView) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(touchList, (String)"touchList");
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        TouchEvent touchEvent = (TouchEvent)CollectionsKt.lastOrNull(touchList);
        if (touchEvent == null) {
            return null;
        }
        TouchEvent lastMotionEvent = touchEvent;
        View topView = UserInteractionUtilKt.findTopView(rootView, (int)lastMotionEvent.getX(), (int)lastMotionEvent.getY());
        Iterable $this$filter$iv = touchList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            TouchEvent it = (TouchEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() == TouchAction.MOVE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validMoveEvents = TouchEventKt.filterDistantTouches$default((List)destination$iv$iv, 0, 1, null);
        Iterable $this$filter$iv2 = touchList;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TouchEvent it = (TouchEvent)element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() != TouchAction.MOVE || validMoveEvents.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List finalTouchEvents = (List)destination$iv$iv2;
        UiElement element = this.getUiElement(topView);
        View view = interactView;
        UiElement ancestor = view != null ? this.getUiElement(view) : null;
        return new TouchUserInteraction(finalTouchEvents, element, ancestor);
    }

    private final UiElement getUiElement(View $this$getUiElement) {
        return new UiElement(this.getViewName($this$getUiElement), this.getClassName($this$getUiElement), this.getUIElementId($this$getUiElement));
    }

    private final String getUIElementId(View $this$getUIElementId) {
        String string;
        String hierarchyPath = this.getHierarchyPath($this$getUIElementId);
        ViewParent viewParent = $this$getUIElementId.getParent();
        ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
        Integer index = viewGroup != null ? Integer.valueOf(viewGroup.indexOfChild($this$getUIElementId)) : null;
        String viewId = this.getViewId($this$getUIElementId);
        if (((CharSequence)viewId).length() == 0 || index == null) {
            Integer n = index;
            string = hierarchyPath + '/' + this.getClassName($this$getUIElementId) + '[' + (n != null ? n : 0) + ']';
        } else {
            hierarchyPath = StringsKt.substringBeforeLast$default((String)hierarchyPath, (String)"/", null, (int)2, null);
            string = hierarchyPath + '/' + viewId + '[' + index + ']';
        }
        return string;
    }

    private final String getViewId(View $this$getViewId) {
        String string;
        try {
            int viewId = $this$getViewId.getId();
            String resourceName = $this$getViewId.getResources().getResourceName(viewId);
            Intrinsics.checkNotNull((Object)resourceName);
            string = StringsKt.contains$default((CharSequence)resourceName, (CharSequence)":id/", (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)resourceName, (String)":id/", null, (int)2, null) : resourceName;
        }
        catch (Resources.NotFoundException notFoundException) {
            string = $this$getViewId.getContentDescription() != null ? ((Object)$this$getViewId.getContentDescription()).toString() : ($this$getViewId.getTag() != null && !Intrinsics.areEqual((Object)$this$getViewId.getTag(), (Object)DT_MASK_TAG) ? $this$getViewId.getTag().toString() : this.getClassName($this$getViewId));
        }
        return string;
    }

    private final String getHierarchyPath(View $this$getHierarchyPath) {
        String string;
        if ($this$getHierarchyPath.getParent() == null || !($this$getHierarchyPath.getParent() instanceof ViewGroup)) {
            string = this.getClassName($this$getHierarchyPath);
        } else {
            String viewId = this.getViewId($this$getHierarchyPath);
            if (((CharSequence)viewId).length() == 0) {
                ViewParent viewParent = $this$getHierarchyPath.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
                string = this.getHierarchyPath((View)viewParent);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append(viewId).append('[');
                ViewParent viewParent = $this$getHierarchyPath.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
                String hierarchyId = stringBuilder.append(((ViewGroup)viewParent).indexOfChild($this$getHierarchyPath)).append(']').toString();
                StringBuilder stringBuilder2 = new StringBuilder();
                ViewParent viewParent2 = $this$getHierarchyPath.getParent();
                Intrinsics.checkNotNull((Object)viewParent2, (String)"null cannot be cast to non-null type android.view.View");
                string = stringBuilder2.append(this.getHierarchyPath((View)viewParent2)).append('/').append(hierarchyId).toString();
            }
        }
        return string;
    }

    private final String getViewName(View $this$getViewName) {
        String string;
        if (Intrinsics.areEqual((Object)$this$getViewName.getTag(), (Object)DT_MASK_TAG)) {
            string = MASKED_LABEL;
        } else if ($this$getViewName instanceof TextView) {
            String string2;
            CharSequence charSequence = ((TextView)$this$getViewName).getText();
            String it = string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            boolean bl = false;
            CharSequence charSequence2 = it;
            string = !(charSequence2 == null || charSequence2.length() == 0) ? string2 : null;
            if (string == null) {
                string = this.getClassName($this$getViewName);
            }
        } else {
            string = this.getClassName($this$getViewName);
        }
        return string;
    }

    private final String getClassName(View $this$getClassName) {
        String string = $this$getClassName.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/dynatrace/agent/userinteraction/model/TouchUserInteractionNativeGenerator$Companion;", "", "<init>", "()V", "DT_MASK_TAG", "", "MASKED_LABEL", "com.dynatrace.agent_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

