/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.compiler.internal;

import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.ValType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

final class TypeStack {
    public static final Instruction FUNCTION_SCOPE = new Instruction(-1, OpCode.NOP, Instruction.EMPTY_OPERANDS);
    private final Deque<Deque<ValType>> types = new ArrayDeque<Deque<ValType>>();
    private final Deque<Deque<ValType>> restore = new ArrayDeque<Deque<ValType>>();
    private final Map<Instruction, Integer> scopes = new HashMap<Instruction, Integer>();

    public TypeStack() {
        this.types.push(new ArrayDeque());
    }

    public ValType peek() {
        return this.types().getFirst();
    }

    public void push(ValType type) {
        this.types().push(type);
    }

    public void pop(ValType expected) {
        ValType actual = this.types().pop();
        if (!ValType.matches((ValType)actual, (ValType)expected)) {
            throw new IllegalArgumentException("Expected type " + String.valueOf(expected) + " <> " + String.valueOf(actual));
        }
    }

    public void popRef() {
        ValType actual = this.types().pop();
        if (!actual.equals((Object)ValType.FuncRef) && !actual.equals((Object)ValType.ExternRef)) {
            throw new IllegalArgumentException("Expected reference type <> " + String.valueOf(actual));
        }
    }

    public void pushTypes() {
        this.types.push(new ArrayDeque<ValType>(this.types()));
    }

    public void popTypes() {
        this.types.pop();
    }

    public void enterScope(Instruction scope, FunctionType scopeType) {
        this.scopes.put(scope, this.types().size());
        ArrayDeque<ValType> stack = new ArrayDeque<ValType>(this.types());
        for (int i = 0; i < scopeType.params().size(); ++i) {
            stack.pop();
        }
        for (ValType type : scopeType.returns()) {
            stack.push(type);
        }
        this.restore.push(stack);
    }

    public void exitScope(Instruction scope) {
        this.scopes.remove(scope);
        this.restore.pop();
    }

    public void scopeRestore() {
        this.types.pop();
        this.types.push(this.restore.getFirst());
    }

    public int scopeStackSize(Instruction scope) {
        return this.scopes.get(scope);
    }

    public Deque<ValType> types() {
        return this.types.getFirst();
    }

    public void verifyEmpty() {
        if (this.types.size() != 1) {
            throw new RuntimeException("Bad types stack: " + String.valueOf(this.types));
        }
        if (!this.types().isEmpty()) {
            throw new RuntimeException("Types not empty: " + String.valueOf(this.types()));
        }
    }
}

