/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.Configuration;
import com.dslplatform.json.JsonAttribute;
import com.dslplatform.json.JsonConverter;
import com.dslplatform.json.JsonObject;
import com.dslplatform.json.JsonValue;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.AnnotationUsage;
import com.dslplatform.json.processor.AttributeInfo;
import com.dslplatform.json.processor.BuilderInfo;
import com.dslplatform.json.processor.ConverterInfo;
import com.dslplatform.json.processor.LogLevel;
import com.dslplatform.json.processor.ObjectType;
import com.dslplatform.json.processor.StructInfo;
import com.dslplatform.json.processor.TypeSupport;
import com.dslplatform.json.processor.UnknownTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class Analysis {
    private final AnnotationUsage annotationUsage;
    private final LogLevel logLevel;
    private final UnknownTypes unknownTypes;
    private final boolean onlyBasicFeatures;
    private final boolean includeFields;
    private final boolean includeBeanMethods;
    private final boolean includeExactMethods;
    private final Elements elements;
    private final Types types;
    private final Messager messager;
    public final TypeElement compiledJsonElement;
    public final DeclaredType compiledJsonType;
    public final TypeElement attributeElement;
    public final DeclaredType attributeType;
    public final TypeElement converterElement;
    public final DeclaredType converterType;
    private final TypeSupport typeSupport;
    private final Set<String> alternativeIgnore;
    private final Map<String, List<AnnotationMapping<Boolean>>> alternativeNonNullable;
    private final Map<String, String> alternativeAlias;
    private final Map<String, List<AnnotationMapping<Boolean>>> alternativeMandatory;
    private final Set<String> alternativeCreators;
    private final Map<String, String> alternativeIndex;
    private final TypeMirror baseListType;
    private final TypeMirror baseSetType;
    private final TypeMirror baseMapType;
    private final Map<String, StructInfo> structs = new LinkedHashMap<String, StructInfo>();
    private boolean hasError;

    public boolean hasError() {
        return this.hasError;
    }

    public Analysis(ProcessingEnvironment processingEnv, AnnotationUsage annotationUsage, LogLevel logLevel, TypeSupport typeSupport) {
        this(processingEnv, annotationUsage, logLevel, typeSupport, null, null, null, null, null, null, UnknownTypes.ERROR, false, true, true, true);
    }

    public Analysis(ProcessingEnvironment processingEnv, AnnotationUsage annotationUsage, LogLevel logLevel, TypeSupport typeSupport, @Nullable Set<String> alternativeIgnore, @Nullable Map<String, List<AnnotationMapping<Boolean>>> alternativeNonNullable, @Nullable Map<String, String> alternativeAlias, @Nullable Map<String, List<AnnotationMapping<Boolean>>> alternativeMandatory, @Nullable Set<String> alternativeCreators, @Nullable Map<String, String> alternativeIndex, @Nullable UnknownTypes unknownTypes, boolean onlyBasicFeatures, boolean includeFields, boolean includeBeanMethods, boolean includeExactMethods) {
        this.annotationUsage = annotationUsage;
        this.logLevel = logLevel;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.compiledJsonElement = this.elements.getTypeElement(CompiledJson.class.getName());
        this.compiledJsonType = this.types.getDeclaredType(this.compiledJsonElement, new TypeMirror[0]);
        this.attributeElement = this.elements.getTypeElement(JsonAttribute.class.getName());
        this.attributeType = this.types.getDeclaredType(this.attributeElement, new TypeMirror[0]);
        this.converterElement = this.elements.getTypeElement(JsonConverter.class.getName());
        this.converterType = this.types.getDeclaredType(this.converterElement, new TypeMirror[0]);
        this.typeSupport = typeSupport;
        this.alternativeIgnore = alternativeIgnore == null ? new HashSet() : alternativeIgnore;
        this.alternativeNonNullable = alternativeNonNullable == null ? new HashMap() : alternativeNonNullable;
        this.alternativeAlias = alternativeAlias == null ? new HashMap() : alternativeAlias;
        this.alternativeMandatory = alternativeMandatory == null ? new HashMap() : alternativeMandatory;
        this.alternativeCreators = alternativeCreators == null ? new HashSet() : alternativeCreators;
        this.alternativeIndex = alternativeIndex == null ? new HashMap() : alternativeIndex;
        this.unknownTypes = unknownTypes == null ? UnknownTypes.ERROR : unknownTypes;
        this.onlyBasicFeatures = onlyBasicFeatures;
        this.includeFields = includeFields;
        this.includeBeanMethods = includeBeanMethods;
        this.includeExactMethods = includeExactMethods;
        this.baseListType = this.types.erasure(this.elements.getTypeElement(List.class.getName()).asType());
        this.baseSetType = this.types.erasure(this.elements.getTypeElement(Set.class.getName()).asType());
        this.baseMapType = this.types.erasure(this.elements.getTypeElement(Map.class.getName()).asType());
    }

    public Map<String, Element> processConverters(Set<? extends Element> converters) {
        LinkedHashMap<String, Element> configurations = new LinkedHashMap<String, Element>();
        block0: for (Element element : converters) {
            this.findConverters(element);
            if (!(element instanceof TypeElement)) continue;
            TypeElement te = (TypeElement)element;
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            for (TypeElement it : this.getTypeHierarchy((TypeElement)element)) {
                if (!Configuration.class.getName().equals(it.toString())) continue;
                if (te.getNestingKind().isNested()) {
                    configurations.put(te.getEnclosingElement().asType().toString() + "$" + te.getSimpleName().toString(), te);
                    continue block0;
                }
                configurations.put(te.asType().toString(), te);
                continue block0;
            }
        }
        return configurations;
    }

    public void processAnnotation(DeclaredType currentAnnotationType, Set<? extends Element> targets) {
        Stack<String> path = new Stack<String>();
        for (Element element : targets) {
            Element classElement;
            ExecutableElement factory = null;
            ExecutableElement builder = null;
            if (element instanceof TypeElement) {
                classElement = element;
            } else if (element instanceof ExecutableElement && element.getKind() == ElementKind.METHOD) {
                ExecutableElement ee = (ExecutableElement)element;
                Element returnClass = this.types.asElement(ee.getReturnType());
                Element enclosing = ee.getEnclosingElement();
                if (!element.getModifiers().contains((Object)Modifier.STATIC) && !this.types.isSameType(ee.getReturnType(), enclosing.asType()) && returnClass.toString().equals(enclosing.getEnclosingElement().toString())) {
                    builder = ee;
                }
                factory = ee;
                classElement = returnClass;
            } else {
                classElement = element.getEnclosingElement();
            }
            this.findStructs(classElement, currentAnnotationType, currentAnnotationType + " requires accessible public constructor", path, factory, builder);
        }
        this.findRelatedReferences();
        this.findImplementations(this.structs.values());
        block1: for (StructInfo structInfo : this.structs.values()) {
            if (!structInfo.hasAnnotation() || structInfo.type == ObjectType.CONVERTER || this.requiresPublic(structInfo.element) || structInfo.element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            String siName = structInfo.binaryName.substring(0, structInfo.binaryName.length() - structInfo.element.getSimpleName().length());
            for (StructInfo parent : this.structs.values()) {
                String parentName;
                if (!parent.hasAnnotation() || !parent.implementations.contains(structInfo) || siName.equals(parentName = parent.binaryName.substring(0, parent.binaryName.length() - parent.element.getSimpleName().length()))) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Inheritance detected on non-public type: '" + structInfo.element.asType() + "'. Either make type public or remove @CompiledJson annotation from '" + structInfo.element.asType() + "' or '" + parent.element.asType() + "'", structInfo.element, structInfo.annotation);
                continue block1;
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public Map<String, StructInfo> analyze() {
        for (Map.Entry<String, StructInfo> it : this.structs.entrySet()) {
            AttributeInfo attr;
            String argName;
            Object r2;
            StructInfo info = it.getValue();
            String className = it.getKey();
            if (info.type == ObjectType.CLASS && info.selectedConstructor() == null && info.annotatedFactory == null && info.builder == null && !info.hasKnownConversion() && info.matchingConstructors != null) {
                this.hasError = true;
                if (info.matchingConstructors.size() == 0) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "No matching constructors found for '" + info.element.asType() + "'. Make sure there is at least one matching constructor available.", info.element, info.annotation);
                } else {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Multiple matching constructors found for '" + info.element.asType() + "'. Use @CompiledJson or alternative annotations to select the appropriate constructor.", info.element, info.annotation);
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW && !info.unknowns.isEmpty()) {
                for (Map.Entry kv : info.unknowns.entrySet()) {
                    AttributeInfo attr2 = info.attributes.get(kv.getKey());
                    if (attr2 != null && (attr2.converter != null || attr2.isJsonObject)) continue;
                    Map<String, PartKind> references = this.analyzeParts((TypeMirror)kv.getValue());
                    for (Map.Entry pair : references.entrySet()) {
                        switch ((PartKind)((Object)pair.getValue())) {
                            case UNKNOWN: {
                                Diagnostic.Kind kind;
                                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                                Diagnostic.Kind kind2 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                                if (kind != Diagnostic.Kind.ERROR && !this.logLevel.isVisible(LogLevel.INFO)) break;
                                if (((TypeMirror)kv.getValue()).toString().equals(pair.getKey())) {
                                    this.messager.printMessage(kind, "Property " + (String)kv.getKey() + " is referencing unknown type: '" + kv.getValue() + "'. Register custom converter, mark property as ignored or enable unknown types", attr2 != null ? attr2.element : info.element, info.annotation);
                                    break;
                                }
                                this.messager.printMessage(kind, "Property " + (String)kv.getKey() + " is referencing unknown type: '" + kv.getValue() + "' which has an unknown part: '" + (String)pair.getKey() + "'. Register custom converter, mark property as ignored or enable unknown types", attr2 != null ? attr2.element : info.element, info.annotation);
                                break;
                            }
                            case RAW_TYPE: {
                                Diagnostic.Kind kind;
                                if (this.structs.containsKey("java.lang.Object")) break;
                                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                                Diagnostic.Kind kind3 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                                if (kind != Diagnostic.Kind.ERROR && !this.logLevel.isVisible(LogLevel.INFO)) break;
                                if (((TypeMirror)kv.getValue()).toString().equals(pair.getKey())) {
                                    this.messager.printMessage(kind, "Property " + (String)kv.getKey() + " is referencing raw type: '" + kv.getValue() + "'. Specify type arguments, register custom converter, mark property as ignored or enable unknown types", attr2 != null ? attr2.element : info.element, info.annotation);
                                    break;
                                }
                                this.messager.printMessage(kind, "Property " + (String)kv.getKey() + " is referencing type: '" + kv.getValue() + "' which has a raw type part: '" + (String)pair.getKey() + "'. Specify type arguments, register custom converter, mark property as ignored or enable unknown types", attr2 != null ? attr2.element : info.element, info.annotation);
                            }
                        }
                    }
                }
            }
            if (this.unknownTypes != UnknownTypes.ALLOW) {
                for (AttributeInfo attr3 : info.attributes.values()) {
                    if (attr3.converter != null || attr3.isJsonObject) continue;
                    Map<String, PartKind> references = this.analyzeParts(attr3.type);
                    for (Object r2 : references.keySet()) {
                        StructInfo target = this.structs.get(r2);
                        if (target == null || target.type != ObjectType.MIXIN || target.implementations.size() != 0) continue;
                        String what = target.element.getKind() == ElementKind.INTERFACE ? "interface" : "abstract class";
                        String one = target.element.getKind() == ElementKind.INTERFACE ? "implementation" : "concrete extension";
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Property " + attr3.name + " is referencing " + what + " (" + target.element.getQualifiedName() + ") which doesn't have registered implementations with @CompiledJson. At least one " + one + " of specified " + what + " must be annotated with CompiledJson annotation or allow unknown types during analysis", attr3.element, info.annotation);
                    }
                }
            }
            if (info.builder == null && this.unknownTypes != UnknownTypes.ALLOW && info.type == ObjectType.MIXIN && info.implementations.isEmpty()) {
                Diagnostic.Kind kind;
                String what = info.element.getKind() == ElementKind.INTERFACE ? "Interface" : "Abstract class";
                String one = info.element.getKind() == ElementKind.INTERFACE ? "implementation" : "concrete extension";
                this.hasError = this.hasError || this.unknownTypes == UnknownTypes.ERROR;
                Diagnostic.Kind kind4 = kind = this.unknownTypes == UnknownTypes.ERROR ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
                if (kind == Diagnostic.Kind.ERROR || this.logLevel.isVisible(LogLevel.INFO)) {
                    this.messager.printMessage(kind, (String)what + " (" + className + ") is referenced, but it doesn't have registered implementations with @CompiledJson. At least one " + one + " of specified " + (String)what + " must be annotated with CompiledJson annotation or allow unknown types during analysis", info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && !info.hasKnownConversion() && info.annotatedFactory != null) {
                if (this.onlyBasicFeatures) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Factory methods are not available with current analysis setup. Use annotation processor which supports such feature", info.annotatedFactory, info.annotation);
                } else if (!this.types.isAssignable(info.annotatedFactory.getReturnType(), info.element.asType())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Wrong factory result type: '" + info.annotatedFactory.getReturnType() + "'. Result must be assignable to '" + info.element.asType() + "'", info.annotatedFactory, info.annotation);
                } else {
                    for (Object p : info.annotatedFactory.getParameters()) {
                        boolean found = false;
                        argName = p.getSimpleName().toString();
                        r2 = info.attributes.values().iterator();
                        while (r2.hasNext()) {
                            attr = r2.next();
                            if (!attr.name.equals(argName)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            r2 = info.inheritedAttributes().iterator();
                            while (r2.hasNext()) {
                                attr = r2.next();
                                if (!attr.name.equals(argName)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        this.hasError = true;
                        if (info.objectFormatPolicy == CompiledJson.ObjectFormatPolicy.EXPLICIT) {
                            this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Since EXPLICIT object format policy is used, please check if all relevant fields are marked with @JsonAttribute.", info.selectedConstructor(), info.annotation);
                            continue;
                        }
                        if (!info.inheritedAttributes().isEmpty()) {
                            this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Please use the same name as the property in the base class to let dsl-json match them.", info.selectedConstructor(), info.annotation);
                            continue;
                        }
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in method factory. Either use annotation processor on source code, on bytecode with -parameters flag (to enable parameter names) or manually create an instance via converter", info.annotatedFactory, info.annotation);
                    }
                }
            }
            if (info.type == ObjectType.CLASS && info.hasAnnotation() && !info.hasKnownConversion() && info.attributes.isEmpty() && info.implementations.isEmpty()) {
                Object p;
                boolean isUsedAsImplementation = false;
                p = this.structs.values().iterator();
                while (p.hasNext()) {
                    StructInfo si = (StructInfo)p.next();
                    if (!si.implementations.contains(info)) continue;
                    isUsedAsImplementation = true;
                    break;
                }
                if (!isUsedAsImplementation) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "No properties found on: '" + info.element + "'. Since it's not used as implementation for some mixin, it's most likely an invalid class configuration (name mismatch, missing setter, etc...)", info.annotatedFactory, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && !info.hasKnownConversion() && info.usesCtorWithArguments()) {
                for (Object p : info.selectedConstructor().getParameters()) {
                    boolean found = false;
                    argName = p.getSimpleName().toString();
                    r2 = info.attributes.values().iterator();
                    while (r2.hasNext()) {
                        attr = r2.next();
                        if (!attr.name.equals(argName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        r2 = info.inheritedAttributes().iterator();
                        while (r2.hasNext()) {
                            attr = r2.next();
                            if (!attr.name.equals(argName)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    this.hasError = true;
                    if (info.objectFormatPolicy == CompiledJson.ObjectFormatPolicy.EXPLICIT) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Since EXPLICIT object format policy is used, please check if all relevant fields are marked with @JsonAttribute.", info.selectedConstructor(), info.annotation);
                        continue;
                    }
                    if (!info.inheritedAttributes().isEmpty()) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Please use the same name as the property in the base class to let dsl-json match them.", info.selectedConstructor(), info.annotation);
                        continue;
                    }
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find matching property: '" + argName + "' used in constructor. Either use annotation processor on source code, on bytecode with -parameters flag (to enable parameter names) or manually create an instance via converter", info.selectedConstructor(), info.annotation);
                }
            }
            if (!info.hasKnownConversion() && info.annotatedFactory == null && info.selectedConstructor() == null && info.builder != null) {
                if (this.onlyBasicFeatures) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder pattern is not available with current analysis setup. Use annotation processor which supports such feature", info.builder.type, info.builder.annotation);
                } else if (this.requiresPublic(info.builder.type) && !info.builder.type.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder type: '" + info.builder.type + "' is not accessible", info.builder.build, info.builder.annotation);
                } else if (!this.types.isAssignable(info.builder.build.getReturnType(), info.element.asType())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Wrong builder result type: '" + info.builder.build.getReturnType() + "'. Result must be assignable to '" + info.element.asType() + "'", info.builder.build, info.builder.annotation);
                } else if (!info.builder.build.getParameters().isEmpty()) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder method: '" + info.builder.build.getSimpleName() + "' can't have parameters", info.builder.build, info.builder.annotation);
                } else if (info.builder.ctor != null && info.builder.factory == null && !info.builder.ctor.getParameters().isEmpty()) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder constructor for: '" + info.builder.type + "' can't have parameters", info.builder.ctor, info.builder.annotation);
                } else if (info.builder.factory != null && !this.types.isSameType(info.builder.factory.getReturnType(), info.builder.type.asType())) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Wrong builder factory result type: '" + info.builder.build.getReturnType() + "'. Expecting: '" + info.builder.type + "'", info.builder.factory, info.builder.annotation);
                }
            }
            if (info.checkHashCollision()) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate hash value detected. Unable to create binding for: '" + className + "'. Remove (or reduce) alternativeNames from @JsonAttribute to resolve this issue." + info.pathDescription(), info.element, info.annotation);
            }
            if (info.deserializeAs != null) {
                StructInfo target = this.structs.get(info.deserializeAs.asType().toString());
                info.setDeserializeTarget(target);
                if (target == null) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find DSL-JSON metadata for: '" + info.deserializeAs.getQualifiedName() + "'. Add @CompiledJson annotation to target type.", info.element, info.annotation);
                }
            }
            if (info.deserializeAs == null && info.type == ObjectType.MIXIN) {
                HashSet<String> names = new HashSet<String>();
                String discriminator = info.discriminator;
                if (discriminator.length() > 0 && this.onlyBasicFeatures) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Custom $type discriminator is not supported with current analysis setup", info.element, info.annotation);
                }
                int invalidChartAt = -1;
                for (int i = 0; i < discriminator.length(); ++i) {
                    char c = discriminator.charAt(i);
                    if (c >= ' ' && c != '\"' && c != '\\' && c <= '~') continue;
                    invalidChartAt = i;
                    break;
                }
                if (invalidChartAt != -1) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Invalid discriminator value: '" + discriminator + "' for mixin: " + className + ". Invalid char at: " + invalidChartAt, info.element, info.annotation);
                }
                for (StructInfo im : info.implementations) {
                    String actualName = im.deserializeName.isEmpty() ? im.element.getQualifiedName().toString() : im.deserializeName;
                    AttributeInfo attr4 = im.attributes.get(discriminator);
                    if (attr4 != null) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Conflicting discriminator name detected: '" + discriminator + "' for mixin: " + className + " with property '" + attr4.name + "' in class " + im.element.toString(), info.element, info.annotation);
                    }
                    if (!names.add(actualName)) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate deserialization name detected: '" + actualName + "' for mixin: " + className, info.element, info.annotation);
                        continue;
                    }
                    if (!actualName.contains("\\") && !actualName.contains("\"")) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Invalid deserialization name (with quotes or escape chars) detected: '" + actualName + "' for mixin: " + className, info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.MIXIN && info.discriminator.length() > 0 && info.implementations.isEmpty()) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Custom discriminator found: '" + info.discriminator + "', but no implementation detected for mixin: " + className, info.element, info.annotation);
            }
            if (info.type == ObjectType.CLASS && info.discriminator.length() > 0) {
                if (info.attributes.containsKey(info.discriminator)) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Discriminator has the same value as one of the attributes. Discriminator will be excluded in favor of attribute value", info.element, info.annotation);
                }
                int hash = StructInfo.calcHash(info.discriminator);
                for (AttributeInfo attr5 : info.attributes.values()) {
                    boolean sameHash = StructInfo.calcHash(attr5.id) == hash;
                    for (String name : attr5.alternativeNames) {
                        sameHash = sameHash || StructInfo.calcHash(name) == hash;
                    }
                    if (!sameHash) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Discriminator has the same hash value as property: " + attr5.name + ". Either simulate class discriminator via property, or remove the discriminator value from class", info.element, info.annotation);
                }
            }
            if (info.type == ObjectType.CLASS && this.onlyBasicFeatures && !info.hasKnownConversion() && !info.hasEmptyCtor()) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + className + "' requires public no argument constructor" + info.pathDescription(), info.element, info.annotation);
            } else if (!(info.type != ObjectType.CLASS || this.onlyBasicFeatures || info.hasEmptyCtor() || info.hasKnownConversion() || info.annotatedFactory != null || info.builder != null || info.selectedConstructor() != null && info.selectedConstructor().getParameters().size() == info.attributes.size())) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + className + "' does not have an empty or matching constructor" + info.pathDescription(), info.element, info.annotation);
            }
            if (info.formats.contains((Object)CompiledJson.Format.ARRAY)) {
                HashSet<Integer> ids = new HashSet<Integer>();
                for (AttributeInfo attr6 : info.attributes.values()) {
                    if (attr6.index == -1 && info.createFromEmptyInstance() && info.attributes.size() > 1) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "When array format is used on class with multiple properties all properties must have index order defined. Property " + attr6.name + " doesn't have index defined", attr6.element, attr6.annotation);
                        continue;
                    }
                    if (attr6.index == -1 || ids.add(attr6.index)) continue;
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate index detected on " + attr6.name + ". Index values must be distinct to be used in array format", attr6.element, attr6.annotation);
                }
            }
            if (info.objectFormatPolicy == CompiledJson.ObjectFormatPolicy.FULL) {
                for (AttributeInfo attr3 : info.attributes.values()) {
                    if (attr3.includeToMinimal != JsonAttribute.IncludePolicy.ALWAYS) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "When object format is set to  FULL, all properties will always be included in the output. It is not necessary to explicitly mark property to be ALWAYS included, since minimal format is not used", attr3.element, attr3.annotation);
                }
            }
            if (info.isMinified) {
                info.prepareMinifiedNames();
            }
            info.sortAttributes();
        }
        return new LinkedHashMap<String, StructInfo>(this.structs);
    }

    private void findConverters(Element el) {
        AnnotationMirror dslAnn = this.getAnnotation(el, this.converterType);
        if (!(el instanceof TypeElement) || dslAnn == null) {
            return;
        }
        TypeElement converter = (TypeElement)el;
        TypeMirror target = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("target()")) continue;
            target = (TypeMirror)values.get(executableElement).getValue();
            break;
        }
        if (target == null) {
            return;
        }
        ConverterInfo signature = this.validateConverter(converter, target);
        String string = signature.targetSignature;
        if (!this.structs.containsKey(string)) {
            String objectType = Analysis.objectName(string);
            Element declaredType = signature.targetType;
            String name = "struct" + this.structs.size();
            TypeElement element = (TypeElement)declaredType;
            String binaryName = this.elements.getBinaryName(element).toString();
            StructInfo info = new StructInfo(signature, this.converterType, element, name, objectType.equals(string) ? binaryName : string);
            this.structs.put(string, info);
        }
    }

    @Nullable
    private Element findElement(TypeMirror type) {
        String javaType = AttributeInfo.stripAnnotations(type.toString());
        String fullName = Analysis.objectName(javaType);
        return fullName.equals(javaType) ? this.types.asElement(type) : this.elements.getTypeElement(fullName);
    }

    private void findAllElements(TypeMirror type, Set<Element> usedTypes, Set<TypeMirror> processed) {
        if (!processed.add(type)) {
            return;
        }
        if (type instanceof ArrayType) {
            this.findAllElements(((ArrayType)type).getComponentType(), usedTypes, processed);
        } else if (type instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)type;
            usedTypes.add(dt.asElement());
            for (TypeMirror typeMirror : dt.getTypeArguments()) {
                this.findAllElements(typeMirror, usedTypes, processed);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            if (wt.getExtendsBound() != null) {
                this.findAllElements(wt.getExtendsBound(), usedTypes, processed);
            }
        } else {
            Element element = this.findElement(type);
            if (element != null) {
                usedTypes.add(element);
            }
        }
    }

    private ConverterInfo validateConverter(TypeElement converter, TypeMirror type) {
        String allowed;
        String javaType = AttributeInfo.stripAnnotations(type.toString());
        String fullName = Analysis.objectName(javaType);
        Element declaredType = this.findElement(type);
        HashSet<Element> usedTypes = new HashSet<Element>();
        this.findAllElements(type, usedTypes, new HashSet<TypeMirror>());
        VariableElement jsonReaderField = null;
        VariableElement jsonWriterField = null;
        ExecutableElement jsonReaderMethod = null;
        ExecutableElement jsonWriterMethod = null;
        boolean hasInstance = false;
        for (VariableElement field : ElementFilter.fieldsIn(converter.getEnclosedElements())) {
            if ("INSTANCE".equals(field.getSimpleName().toString())) {
                if (!field.asType().toString().equals(converter.getQualifiedName().toString()) || !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                hasInstance = true;
                continue;
            }
            if ("JSON_READER".equals(field.getSimpleName().toString())) {
                jsonReaderField = field;
                continue;
            }
            if (!"JSON_WRITER".equals(field.getSimpleName().toString())) continue;
            jsonWriterField = field;
        }
        if (!this.onlyBasicFeatures) {
            for (ExecutableElement method : ElementFilter.methodsIn(converter.getEnclosedElements())) {
                if ("JSON_READER".equals(method.getSimpleName().toString()) || "getJSON_READER".equals(method.getSimpleName().toString())) {
                    jsonReaderMethod = method;
                    continue;
                }
                if (!"JSON_WRITER".equals(method.getSimpleName().toString()) && !"getJSON_WRITER".equals(method.getSimpleName().toString())) continue;
                jsonWriterMethod = method;
            }
        }
        for (Element used : usedTypes) {
            if (used == null || used.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified target: '" + used + "' must be public", converter, this.getAnnotation(converter, this.converterType));
        }
        String string = allowed = this.onlyBasicFeatures ? "field" : "field/method";
        if (!converter.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.asType() + "' must be public", converter, this.getAnnotation(converter, this.converterType));
        } else if (converter.getNestingKind().isNested() && !converter.getModifiers().contains((Object)Modifier.STATIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.asType() + "' can't be a nested member. Only public static nested classes are supported", converter, this.getAnnotation(converter, this.converterType));
        } else if (this.onlyBasicFeatures && (converter.getQualifiedName().contentEquals(converter.getSimpleName()) || converter.getNestingKind().isNested() && converter.getModifiers().contains((Object)Modifier.STATIC) && converter.getEnclosingElement() instanceof TypeElement && ((TypeElement)converter.getEnclosingElement()).getQualifiedName().contentEquals(converter.getEnclosingElement().getSimpleName()))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' is defined without a package name and cannot be accessed", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonReaderField == null && jsonReaderMethod == null || jsonWriterField == null && jsonWriterMethod == null) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' doesn't have a JSON_READER or JSON_WRITER " + allowed + ". It must have public static JSON_READER/JSON_WRITER " + allowed + " for conversion.", converter, this.getAnnotation(converter, this.converterType));
        } else if (!((jsonReaderMethod != null || jsonReaderField.getModifiers().contains((Object)Modifier.PUBLIC) && jsonReaderField.getModifiers().contains((Object)Modifier.STATIC)) && (jsonWriterMethod != null || jsonWriterField.getModifiers().contains((Object)Modifier.PUBLIC) && jsonWriterField.getModifiers().contains((Object)Modifier.STATIC)) && (jsonReaderMethod == null || jsonReaderMethod.getModifiers().contains((Object)Modifier.PUBLIC) && (hasInstance || jsonReaderMethod.getModifiers().contains((Object)Modifier.STATIC))) && (jsonWriterMethod == null || jsonWriterMethod.getModifiers().contains((Object)Modifier.PUBLIC) && (hasInstance || jsonWriterMethod.getModifiers().contains((Object)Modifier.STATIC))))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' doesn't have public and static JSON_READER and JSON_WRITER " + allowed + ". They must be public and static for converter to work properly.", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonReaderField != null && !("com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">").equals(jsonReaderField.asType().toString()) || jsonReaderMethod != null && !("com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">").equals(jsonReaderMethod.getReturnType().toString())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' has invalid type for JSON_READER field. It must be of type: 'com.dslplatform.json.JsonReader.ReadObject<" + fullName + ">'", converter, this.getAnnotation(converter, this.converterType));
        } else if (jsonWriterField != null && !("com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">").equals(jsonWriterField.asType().toString()) || jsonWriterMethod != null && !("com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">").equals(jsonWriterMethod.getReturnType().toString())) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Specified converter: '" + converter.getQualifiedName() + "' has invalid type for JSON_WRITER " + allowed + ". It must be of type: 'com.dslplatform.json.JsonWriter.WriteObject<" + fullName + ">'", converter, this.getAnnotation(converter, this.converterType));
        }
        return new ConverterInfo(converter, jsonReaderMethod != null ? (hasInstance ? "INSTANCE." : "") + jsonReaderMethod.getSimpleName().toString() + "()" : (jsonReaderField != null ? jsonReaderField.getSimpleName().toString() : ""), jsonWriterMethod != null ? (hasInstance ? "INSTANCE." : "") + jsonWriterMethod.getSimpleName().toString() + "()" : (jsonWriterField != null ? jsonWriterField.getSimpleName().toString() : ""), javaType, declaredType);
    }

    private List<TypeElement> getTypeHierarchy(TypeElement element) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        this.getAllTypes(element, result, new HashSet<TypeElement>());
        return result;
    }

    private void getAllTypes(TypeElement element, List<TypeElement> result, Set<TypeElement> processed) {
        if (!processed.add(element) || element.getQualifiedName().contentEquals("java.lang.Object")) {
            return;
        }
        result.add(element);
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            Element current = this.types.asElement(typeMirror);
            if (!(current instanceof TypeElement)) continue;
            this.getAllTypes((TypeElement)current, result, processed);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findRelatedReferences() {
        int total;
        do {
            total = this.structs.size();
            ArrayList<StructInfo> items = new ArrayList<StructInfo>(this.structs.values());
            Stack<String> path = new Stack<String>();
            for (StructInfo info : items) {
                if (info.hasKnownConversion()) continue;
                path.push(info.element.getSimpleName().toString());
                if (!this.onlyBasicFeatures && info.builder != null && info.annotatedConstructor == null && info.annotatedFactory == null) {
                    for (Map.Entry<String, AccessElements> entry : this.getBuilderProperties(info.element, info.builder, this.includeBeanMethods, this.includeExactMethods, this.includeFields).entrySet()) {
                        AccessElements ae = entry.getValue();
                        if (ae.field == null && ae.read == null) continue;
                        this.analyzeAttribute(info, ae.field != null ? ae.field.asType() : ae.read.getReturnType(), entry.getKey(), ae, "builder property", path, null);
                    }
                } else {
                    void var7_12;
                    HashMap<ExecutableElement, Map<String, VariableElement>> creatorArguments = new HashMap<ExecutableElement, Map<String, VariableElement>>();
                    if (info.annotatedFactory != null) {
                        creatorArguments.put(info.annotatedFactory, this.getArguments(info.annotatedFactory));
                    } else if (info.annotatedConstructor != null) {
                        creatorArguments.put(info.annotatedConstructor, this.getArguments(info.annotatedConstructor));
                    } else if (info.matchingConstructors != null) {
                        for (ExecutableElement ctor : info.matchingConstructors) {
                            if (this.onlyBasicFeatures && ctor.getParameters().size() != 0) continue;
                            creatorArguments.put(ctor, this.getArguments(ctor));
                        }
                    }
                    Object var7_11 = null;
                    for (Map.Entry entry : creatorArguments.entrySet()) {
                        int oldKeys;
                        PropertyAnalysis analysis = new PropertyAnalysis((ExecutableElement)entry.getKey(), info.element, (Map)entry.getValue());
                        if (var7_12 == null) {
                            PropertyAnalysis propertyAnalysis = analysis;
                            continue;
                        }
                        int foundKeys = analysis.allKeys.size();
                        if (foundKeys > (oldKeys = var7_12.allKeys.size())) {
                            PropertyAnalysis propertyAnalysis = analysis;
                            continue;
                        }
                        if (foundKeys != oldKeys || analysis.creator.getParameters().size() != 0) continue;
                        PropertyAnalysis propertyAnalysis = analysis;
                    }
                    if (var7_12 != null) {
                        AccessElements field;
                        if (info.annotatedFactory == null) {
                            info.useConstructor(var7_12.creator);
                        }
                        for (Map.Entry<Object, Object> entry : var7_12.beans.entrySet()) {
                            field = var7_12.allFieldDetails.get(entry.getKey());
                            this.analyzeAttribute(info, ((AccessElements)entry.getValue()).read.getReturnType(), (String)entry.getKey(), (AccessElements)entry.getValue(), "bean property", path, field != null ? field.field : null);
                        }
                        for (Map.Entry<Object, Object> entry : var7_12.exact.entrySet()) {
                            if (info.attributes.containsKey(entry.getKey()) && info.annotation == null) continue;
                            field = var7_12.allFieldDetails.get(entry.getKey());
                            this.analyzeAttribute(info, ((AccessElements)entry.getValue()).read.getReturnType(), (String)entry.getKey(), (AccessElements)entry.getValue(), "exact property", path, field != null ? field.field : null);
                        }
                        for (Map.Entry<Object, Object> entry : var7_12.fields.entrySet()) {
                            if (info.attributes.containsKey(entry.getKey()) && info.annotation == null) continue;
                            this.analyzeAttribute(info, ((AccessElements)entry.getValue()).field.asType(), (String)entry.getKey(), (AccessElements)entry.getValue(), "field", path, null);
                        }
                    }
                }
                path.pop();
            }
        } while (total != this.structs.size());
    }

    private Map<String, TypeMirror> findGenericSignatures(TypeMirror type) {
        ArrayDeque<? extends TypeMirror> queue = new ArrayDeque<TypeMirror>(this.types.directSupertypes(type));
        HashMap<String, TypeMirror> genericAttributes = new HashMap<String, TypeMirror>();
        while (!queue.isEmpty()) {
            DeclaredType declaredType;
            Element element;
            TypeMirror mirror = (TypeMirror)queue.poll();
            if (!(mirror instanceof DeclaredType) || !((element = (declaredType = (DeclaredType)mirror).asElement()) instanceof TypeElement)) continue;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            List<? extends TypeParameterElement> typeParameters = ((TypeElement)element).getTypeParameters();
            for (int i = 0; i < typeParameters.size(); ++i) {
                genericAttributes.put(typeParameters.get(i).toString(), typeArguments.get(i));
            }
            queue.addAll(this.types.directSupertypes(mirror));
        }
        return genericAttributes;
    }

    public static String objectName(String type) {
        return "int".equals(type) ? "java.lang.Integer" : ("long".equals(type) ? "java.lang.Long" : ("double".equals(type) ? "java.lang.Double" : ("float".equals(type) ? "java.lang.Float" : ("char".equals(type) ? "java.lang.Character" : ("byte".equals(type) ? "java.lang.Byte" : ("short".equals(type) ? "java.lang.Short" : ("boolean".equals(type) ? "java.lang.Boolean" : type)))))));
    }

    private TypeMirror unpackType(TypeMirror type) {
        String typeName = type.toString();
        if (typeName.startsWith("(@") || typeName.startsWith("@")) {
            if (type.getKind().isPrimitive()) {
                return this.types.getPrimitiveType(type.getKind());
            }
            String actualType = AttributeInfo.stripAnnotations(typeName);
            if (!actualType.contains("<") && !actualType.contains("[")) {
                Element element = this.types.asElement(type);
                return element.asType();
            }
        }
        return type;
    }

    private void analyzeAttribute(StructInfo info, TypeMirror originalType, String name, AccessElements access, String target, Stack<String> path, @Nullable VariableElement field) {
        Element element;
        Element element2 = element = access.field != null ? access.field : access.read;
        if (element == null) {
            return;
        }
        path.push(name);
        AnnotationMirror annotation = access.annotation;
        if (!(info.properties.contains(element) || this.hasIgnoredAnnotation(element, annotation, field) || info.objectFormatPolicy == CompiledJson.ObjectFormatPolicy.EXPLICIT && annotation == null)) {
            AttributeInfo other;
            String[] alternativeNames;
            ConverterInfo converter;
            TypeMirror referenceType = this.unpackType(access.field != null ? access.field.asType() : access.read.getReturnType());
            TypeMirror type = this.unpackType(originalType.getKind() == TypeKind.TYPEVAR && info.genericSignatures.containsKey(originalType.toString()) ? info.genericSignatures.get(originalType.toString()) : originalType);
            Element referenceElement = this.types.asElement(referenceType);
            TypeMirror converterMirror = this.findConverter(annotation);
            if (converterMirror != null) {
                TypeElement typeConverter = this.elements.getTypeElement(converterMirror.toString());
                converter = this.validateConverter(typeConverter, type);
            } else {
                converter = null;
            }
            String referenceName = referenceType.toString();
            boolean isJsonObject = this.jsonObjectReaderPath(referenceElement, false) != null;
            boolean typeResolved = converter != null || isJsonObject || this.structs.containsKey(referenceName);
            boolean hasUnknown = false;
            boolean hasOwnerStructType = false;
            HashMap<String, Integer> typeVariablesIndex = new HashMap<String, Integer>();
            HashMap<String, PartKind> references = new HashMap<String, PartKind>();
            LinkedHashSet<TypeMirror> usedTypes = new LinkedHashSet<TypeMirror>();
            this.analyzePartsRecursively(referenceType, references, usedTypes);
            if (!typeResolved || info.isParameterized) {
                for (Map.Entry kv : references.entrySet()) {
                    String partTypeName = (String)kv.getKey();
                    PartKind partKind = (PartKind)((Object)kv.getValue());
                    if (partKind == PartKind.UNKNOWN || partKind == PartKind.RAW_TYPE) {
                        hasUnknown = true;
                    }
                    if (partKind == PartKind.TYPE_VARIABLE) {
                        int typeIndex = info.typeParametersNames.indexOf(partTypeName);
                        if (typeIndex >= 0) {
                            typeVariablesIndex.put(partTypeName, typeIndex);
                        } else {
                            TypeMirror mirror = info.genericSignatures.get(partTypeName);
                            if (mirror == null) {
                                this.hasError = true;
                                this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to resolve generic signature on " + name + " in " + info.name, element, annotation);
                            } else {
                                partTypeName = mirror.toString();
                            }
                        }
                    }
                    if (!partTypeName.equals(info.element.toString())) continue;
                    hasOwnerStructType = true;
                }
            }
            CompiledJson.TypeSignature typeSignature = this.typeSignatureValue(annotation);
            JsonAttribute.IncludePolicy includeToMinimal = this.includeToMinimalValue(annotation);
            AttributeInfo attr = new AttributeInfo(name, access.read, access.write, access.field, access.arg, type, this.isCompatibileCollection(type, this.baseListType), this.isCompatibileCollection(type, this.baseSetType), this.isCompatibileCollection(type, this.baseMapType), annotation, this.hasNonNullable(element, field, annotation), this.hasMandatoryAnnotation(element, annotation) || field != null && this.hasMandatoryAnnotation(field, null), this.index(element, annotation), this.findNameAlias(element, field, annotation, name), this.isFullMatch(annotation), typeSignature, includeToMinimal, converter, isJsonObject, usedTypes, typeVariablesIndex, info.genericSignatures, hasOwnerStructType);
            String[] stringArray = alternativeNames = attr.annotation == null ? null : this.getAlternativeNames(attr.annotation);
            if (alternativeNames != null) {
                attr.alternativeNames.addAll(Arrays.asList(alternativeNames));
            }
            if ((other = info.attributes.get(attr.id)) != null && (other.annotation != null && attr.annotation == null || other.annotation == null && attr.annotation == null && other.field == null && attr.field != null)) {
                path.pop();
                return;
            }
            if (other != null && (!other.name.equals(attr.name) || other.id.equals(attr.id) && other.field == null && attr.field == null)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate alias detected on " + (attr.field != null ? "field: " : "property: ") + attr.name, attr.element, info.annotation);
            }
            if (!typeResolved && hasUnknown) {
                info.unknowns.put(attr.id, referenceType);
            }
            info.attributes.put(attr.id, attr);
            info.properties.add(attr.element);
            this.checkRelatedProperty(type, info.discoveredBy, target, info.element, element, path);
        }
        path.pop();
    }

    private void checkRelatedProperty(TypeMirror returnType, DeclaredType discoveredBy, String access, Element inside, Element property, Stack<String> path) {
        TypeMirror converter = this.findConverter(property);
        if (converter != null) {
            return;
        }
        this.checkRelatedPropertyRecursively(returnType, discoveredBy, access, inside, path);
    }

    private void checkRelatedPropertyRecursively(TypeMirror returnType, DeclaredType discoveredBy, String access, Element inside, Stack<String> path) {
        String typeName = returnType.toString();
        if (this.structs.containsKey(typeName) || this.typeSupport.isSupported(typeName)) {
            return;
        }
        if (returnType.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)returnType;
            String rawTypeName = declaredType.asElement().toString();
            if (!this.structs.containsKey(rawTypeName) && !this.typeSupport.isSupported(rawTypeName)) {
                Element el = declaredType.asElement();
                this.findStructs(el, discoveredBy, el + " is referenced as " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path, null, null);
            }
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                this.checkRelatedPropertyRecursively(typeMirror, discoveredBy, access, inside, path);
            }
        } else if (returnType.getKind() == TypeKind.ARRAY) {
            ArrayType at = (ArrayType)returnType;
            this.checkRelatedPropertyRecursively(at.getComponentType(), discoveredBy, access, inside, path);
        } else {
            TypeElement el = this.elements.getTypeElement(typeName);
            if (el != null) {
                this.findStructs(el, discoveredBy, el + " is referenced as " + access + " from '" + inside.asType() + "' through CompiledJson annotation.", path, null, null);
            }
        }
    }

    private boolean requiresPublic(Element element) {
        if (this.onlyBasicFeatures) {
            return true;
        }
        String name = element.asType().toString();
        if (name.startsWith("java.")) {
            return true;
        }
        PackageElement pkg = this.elements.getPackageOf(element);
        if (pkg == null) {
            return false;
        }
        Package packageClass = Package.getPackage(pkg.getQualifiedName().toString());
        return packageClass != null && packageClass.isSealed();
    }

    private void findStructs(Element el, DeclaredType discoveredBy, String errorMessge, Stack<String> path, @Nullable ExecutableElement factory, @Nullable ExecutableElement builder) {
        if (!(el instanceof TypeElement)) {
            return;
        }
        String typeName = el.toString();
        if (this.structs.containsKey(typeName) || this.typeSupport.isSupported(typeName) || "java.lang.Object".equals(typeName)) {
            return;
        }
        TypeElement element = (TypeElement)el;
        boolean isMixin = element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT);
        String jsonObjectReaderPath = this.jsonObjectReaderPath(element, true);
        boolean isJsonObject = jsonObjectReaderPath != null;
        AnnotationMirror annotation = this.scanClassForAnnotation(element, discoveredBy, factory);
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' can't be private ", element, annotation);
        } else if (this.requiresPublic(element) && !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' must be public ", element, annotation);
        } else if (element.getNestingKind().isNested() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.asType() + "' can't be a nested member. Only static nested classes are supported.", element, annotation);
        } else if (this.onlyBasicFeatures && (element.getQualifiedName().contentEquals(element.getSimpleName()) || element.getNestingKind().isNested() && element.getModifiers().contains((Object)Modifier.STATIC) && element.getEnclosingElement() instanceof TypeElement && ((TypeElement)element.getEnclosingElement()).getQualifiedName().contentEquals(element.getEnclosingElement().getSimpleName()))) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", but class '" + element.getQualifiedName() + "' is defined without a package name and cannot be accessed.", element, annotation);
        } else if (element.getNestingKind().isNested() && this.requiresPublic(element.getEnclosingElement()) && !element.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", therefore '" + element.getEnclosingElement().asType() + "' must be public ", element, annotation);
        } else {
            ObjectType type = isMixin ? ObjectType.MIXIN : (element.getKind() == ElementKind.ENUM ? ObjectType.ENUM : ObjectType.CLASS);
            CompiledJson.Behavior onUnknown = CompiledJson.Behavior.DEFAULT;
            CompiledJson.TypeSignature typeSignature = CompiledJson.TypeSignature.DEFAULT;
            TypeElement deserializeAs = null;
            if (!isJsonObject) {
                if (annotation != null) {
                    onUnknown = this.onUnknownValue(annotation);
                    typeSignature = this.typeSignatureValue(annotation);
                    deserializeAs = Analysis.deserializeAs(annotation);
                    if (deserializeAs != null) {
                        String error = this.validateDeserializeAs(element, deserializeAs);
                        if (error != null) {
                            this.hasError = true;
                            this.messager.printMessage(Diagnostic.Kind.ERROR, errorMessge + ", but specified deserializeAs target: '" + deserializeAs.getQualifiedName() + "' " + error, element, annotation);
                            deserializeAs = null;
                        } else if (deserializeAs.asType().toString().equals(element.asType().toString())) {
                            deserializeAs = null;
                        } else {
                            this.findStructs(deserializeAs, discoveredBy, errorMessge, path, null, null);
                        }
                    }
                } else if (this.annotationUsage != AnnotationUsage.IMPLICIT) {
                    if (this.annotationUsage == AnnotationUsage.EXPLICIT) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Annotation usage is set to explicit, but '" + element.getQualifiedName() + "' is used implicitly through references. Either change usage to implicit, use @Ignore on property referencing this type or register custom converter for problematic type. " + errorMessge, element);
                    } else if (element.getQualifiedName().toString().startsWith("java.")) {
                        this.hasError = true;
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Annotation usage is set to non-java, but '" + element.getQualifiedName() + "' is found in java package. Either change usage to implicit, use @Ignore on property referencing this type, register custom converter for problematic type or add annotation to this type. " + errorMessge, element);
                    }
                }
            }
            CompiledJson.ObjectFormatPolicy objectFormatPolicy = this.objectFormatPolicyValue(annotation);
            CompiledJson.Format[] formats = this.getFormats(annotation);
            if (new HashSet<CompiledJson.Format>(Arrays.asList(formats)).size() != formats.length) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate format detected on '" + element.getQualifiedName() + "'.", element, annotation);
            }
            String name = "struct" + this.structs.size();
            String binaryName = this.elements.getBinaryName(element).toString();
            BuilderInfo builderInfo = this.findBuilder(element, discoveredBy, builder);
            ExecutableElement factoryAnn = this.findAnnotatedFactory(element, discoveredBy, factory, builderInfo);
            StructInfo info = new StructInfo(element, discoveredBy, name, binaryName, type, jsonObjectReaderPath, this.findMatchingConstructors(element, isMixin), this.findAnnotatedConstructor(element, discoveredBy), factoryAnn, builderInfo, annotation, onUnknown, typeSignature, objectFormatPolicy, deserializeAs, Analysis.classDiscriminator(annotation), Analysis.className(annotation), type == ObjectType.ENUM ? this.findEnumConstantNameSource(element) : null, this.isMinified(annotation), formats, this.findGenericSignatures(element.asType()));
            info.path.addAll(path);
            if (type == ObjectType.ENUM) {
                info.constants.addAll(Analysis.getEnumConstants(info.element));
            }
            this.structs.put(typeName, info);
        }
    }

    @Nullable
    private String validateDeserializeAs(TypeElement source, TypeElement target) {
        if (target.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return "can't be private";
        }
        if (this.requiresPublic(target) && !target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "must be public";
        }
        if (target.getNestingKind().isNested() && !target.getModifiers().contains((Object)Modifier.STATIC)) {
            return "can't be a nested member. Only public static nested classes are supported";
        }
        if (target.getNestingKind().isNested() && !target.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return "must be public when nested in another class";
        }
        if (this.onlyBasicFeatures && (target.getQualifiedName().contentEquals(target.getSimpleName()) || target.getNestingKind().isNested() && target.getModifiers().contains((Object)Modifier.STATIC) && target.getEnclosingElement() instanceof TypeElement && ((TypeElement)target.getEnclosingElement()).getQualifiedName().contentEquals(target.getEnclosingElement().getSimpleName()))) {
            return "is defined without a package name and cannot be accessed";
        }
        if (target.getKind() == ElementKind.INTERFACE || target.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return "must be a concrete type";
        }
        if (!source.asType().toString().equals(target.asType().toString()) && source.getKind() != ElementKind.INTERFACE && !source.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return "can only be specified for interfaces and abstract classes. '" + source + "' is neither interface nor abstract class";
        }
        if (!this.types.isAssignable(target.asType(), source.asType())) {
            return "is not assignable to '" + source.getQualifiedName() + "'";
        }
        return null;
    }

    @Nullable
    private List<ExecutableElement> findMatchingConstructors(Element element, boolean isMixin) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || !isMixin && element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        ArrayList<ExecutableElement> matchingCtors = new ArrayList<ExecutableElement>();
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || (!isMixin || !constructor.getModifiers().contains((Object)Modifier.PROTECTED)) && this.requiresPublic(element) && !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            matchingCtors.add(constructor);
        }
        return matchingCtors;
    }

    @Nullable
    private ExecutableElement findAnnotatedConstructor(Element element, DeclaredType discoveredBy) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM || element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            AnnotationMirror discAnn = this.getAnnotation(constructor, discoveredBy);
            if (discAnn != null) {
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || constructor.getModifiers().contains((Object)Modifier.PROTECTED) || this.requiresPublic(element) && !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Constructor in '" + element.asType() + "' is annotated with " + discoveredBy + ", but it's not accessible.", constructor, discAnn);
                }
                return constructor;
            }
            for (AnnotationMirror annotationMirror : constructor.getAnnotationMirrors()) {
                if (!this.alternativeCreators.contains(annotationMirror.getAnnotationType().toString())) continue;
                if (constructor.getModifiers().contains((Object)Modifier.PRIVATE) || constructor.getModifiers().contains((Object)Modifier.PROTECTED) || this.requiresPublic(element) && !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.hasError = true;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Constructor in '" + element.asType() + "' is annotated with " + annotationMirror.getAnnotationType() + ", but it's not public.", constructor, annotationMirror);
                }
                return constructor;
            }
        }
        return null;
    }

    @Nullable
    private ExecutableElement findAnnotatedFactory(Element element, DeclaredType discoveredBy, @Nullable ExecutableElement factory, @Nullable BuilderInfo builder) {
        if (element.getKind() == ElementKind.INTERFACE || element.getKind() == ElementKind.ENUM) {
            return null;
        }
        AnnotationMirror annotation = null;
        if (factory == null) {
            block0: for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
                AnnotationMirror discAnn = this.getAnnotation(method, discoveredBy);
                if (discAnn != null) {
                    factory = method;
                    annotation = discAnn;
                    break;
                }
                for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                    if (!this.alternativeCreators.contains(annotationMirror.getAnnotationType().toString()) || !method.getModifiers().contains((Object)Modifier.PRIVATE) && (!this.requiresPublic(element) || method.getModifiers().contains((Object)Modifier.PUBLIC))) continue;
                    factory = method;
                    annotation = annotationMirror;
                    continue block0;
                }
            }
        }
        if (factory == null) {
            return null;
        }
        boolean isStaticMethod = factory.getModifiers().contains((Object)Modifier.STATIC);
        boolean isSingletonInstanceMethod = false;
        TypeElement parent = (TypeElement)factory.getEnclosingElement();
        if (!isStaticMethod && parent.getEnclosingElement() instanceof TypeElement && parent.getModifiers().contains((Object)Modifier.STATIC)) {
            TypeElement grandparent = (TypeElement)parent.getEnclosingElement();
            for (VariableElement field : ElementFilter.fieldsIn(grandparent.getEnclosedElements())) {
                if (!field.getSimpleName().equals(parent.getSimpleName()) || !field.getModifiers().contains((Object)Modifier.PUBLIC) || !field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) continue;
                isSingletonInstanceMethod = true;
                break;
            }
        }
        if (factory.getModifiers().contains((Object)Modifier.PRIVATE) || !isStaticMethod && !isSingletonInstanceMethod || this.requiresPublic(factory.getEnclosingElement()) && !factory.getModifiers().contains((Object)Modifier.PUBLIC)) {
            if (builder != null) {
                return null;
            }
            this.hasError = true;
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Factory method in '" + factory.getEnclosingElement().asType() + "' is annotated with " + discoveredBy + ", but it's not accessible.", factory, annotation != null ? annotation : this.getAnnotation(factory, discoveredBy));
        }
        return factory;
    }

    @Nullable
    private BuilderInfo findBuilder(Element element, DeclaredType discoveredBy, @Nullable ExecutableElement builder) {
        Iterator<TypeElement> ee;
        if (element.getKind() == ElementKind.ENUM) {
            return null;
        }
        ExecutableElement factory = null;
        ExecutableElement build = builder;
        TypeElement builderType = null;
        if (builder != null && (ee = builder.getEnclosingElement()) instanceof TypeElement) {
            builderType = (TypeElement)((Object)ee);
        }
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            Object nested;
            if (!method.getModifiers().contains((Object)Modifier.STATIC) || !method.getModifiers().contains((Object)Modifier.PUBLIC) || !((nested = this.types.asElement(method.getReturnType())) instanceof TypeElement) || !element.getEnclosedElements().contains(nested) || !method.getParameters().isEmpty() || builderType != null && !builderType.toString().equals(nested.toString())) continue;
            factory = method;
            builderType = (TypeElement)nested;
            break;
        }
        if (builderType == null) {
            return null;
        }
        if (build == null) {
            block1: for (TypeElement inheritance : this.getTypeHierarchy(builderType)) {
                for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                    if (!method.getParameters().isEmpty() || method.getModifiers().contains((Object)Modifier.STATIC) || !this.types.isSameType(method.getReturnType(), element.asType())) continue;
                    build = method;
                    continue block1;
                }
            }
            if (build == null) {
                return null;
            }
        }
        AnnotationMirror annotation = this.getAnnotation(build, discoveredBy);
        List<ExecutableElement> ctors = this.findMatchingConstructors(builderType, false);
        ExecutableElement ctor = ctors != null && ctors.size() == 1 ? ctors.get(0) : null;
        return new BuilderInfo(factory, ctor, builderType, build, annotation);
    }

    private Map<String, PartKind> analyzeParts(TypeMirror target) {
        HashMap<String, PartKind> parts = new HashMap<String, PartKind>();
        HashSet<TypeMirror> used = new HashSet<TypeMirror>();
        this.analyzePartsRecursively(target, parts, used);
        return parts;
    }

    private void analyzePartsRecursively(TypeMirror target, Map<String, PartKind> parts, Set<TypeMirror> usedTypes) {
        String typeName = AttributeInfo.stripAnnotations(target.toString());
        if (this.typeSupport.isSupported(typeName)) {
            usedTypes.add(target);
            if (this.isRawType(target)) {
                parts.put(typeName, PartKind.RAW_TYPE);
            } else {
                parts.put(typeName, PartKind.OTHER);
            }
            return;
        }
        switch (target.getKind()) {
            case ARRAY: {
                ArrayType at = (ArrayType)target;
                this.analyzePartsRecursively(at.getComponentType(), parts, usedTypes);
                break;
            }
            case DECLARED: {
                boolean knownAndValidStruct;
                DeclaredType declaredType = (DeclaredType)target;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                String rawTypeName = declaredType.asElement().toString();
                usedTypes.add(declaredType.asElement().asType());
                StructInfo struct = this.structs.get(rawTypeName);
                boolean bl = knownAndValidStruct = struct != null && (struct.type != ObjectType.CLASS || struct.hasAnnotation() || !struct.attributes.isEmpty() || !struct.implementations.isEmpty() || struct.hasKnownConversion());
                if (knownAndValidStruct || this.typeSupport.isSupported(rawTypeName)) {
                    if (this.isRawType(target)) {
                        parts.put(rawTypeName, PartKind.RAW_TYPE);
                    } else {
                        parts.put(rawTypeName, PartKind.OTHER);
                    }
                } else {
                    parts.put(rawTypeName, PartKind.UNKNOWN);
                }
                for (TypeMirror typeMirror : typeArguments) {
                    this.analyzePartsRecursively(typeMirror, parts, usedTypes);
                }
                break;
            }
            case TYPEVAR: {
                usedTypes.add(target);
                parts.put(typeName, PartKind.TYPE_VARIABLE);
                break;
            }
            case WILDCARD: {
                WildcardType wt = (WildcardType)target;
                this.analyzePartsRecursively(wt.getExtendsBound(), parts, usedTypes);
                break;
            }
            default: {
                usedTypes.add(target);
                parts.put(typeName, PartKind.UNKNOWN);
            }
        }
    }

    private boolean isRawType(TypeMirror target) {
        if (target.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)target;
            return declaredType.getTypeArguments().isEmpty() && !((TypeElement)declaredType.asElement()).getTypeParameters().isEmpty();
        }
        return false;
    }

    private static List<String> getEnumConstants(TypeElement element) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result.add(element2.getSimpleName().toString());
        }
        return result;
    }

    @Nullable
    private Element findEnumConstantNameSource(TypeElement element) {
        Element nameSource = null;
        block3: for (Element element2 : element.getEnclosedElements()) {
            if (element2.getAnnotation(JsonValue.class) == null) continue;
            switch (element2.getKind()) {
                case FIELD: 
                case METHOD: {
                    if (nameSource == null) {
                        if (!element2.getModifiers().contains((Object)Modifier.PUBLIC)) {
                            this.printError((element2.getKind().isField() ? "Field '" : "Method '") + element2.toString() + "' annotated with @JsonValue must be public.", element2);
                            continue block3;
                        }
                        if (!this.isSupportedEnumNameType(element2)) {
                            this.printError((element2.getKind().isField() ? "Field '" : "Method '") + element2.toString() + "' annotated with @JsonValue must be of a supported type. Unknown types can be supported by enabling unknown types configuration option or whitelisting that specific unknown type", element2);
                            continue block3;
                        }
                        nameSource = element2;
                        continue block3;
                    }
                    this.printError("Duplicate @JsonValue annotation found. Only one enum field or getter can be annotated.", element2);
                    continue block3;
                }
            }
            this.printError("Unexpected @JsonValue annotation found. It must be placed on enum field or getter.", element2);
        }
        return nameSource;
    }

    private boolean isSupportedEnumNameType(Element element) {
        String enumNameType = this.extractReturnType(element);
        if (enumNameType == null) {
            return false;
        }
        if (this.typeSupport.isSupported(enumNameType) || this.unknownTypes == UnknownTypes.ALLOW) {
            return true;
        }
        StructInfo target = this.structs.get(enumNameType);
        if (target != null && target.hasKnownConversion()) {
            return true;
        }
        if (this.unknownTypes == UnknownTypes.WARNING) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, (element.getKind().isField() ? "Field '" : "Method '") + element.toString() + "' annotated with @JsonValue is of unknown type.", element);
            return true;
        }
        return false;
    }

    @Nullable
    private String extractReturnType(Element element) {
        switch (element.getKind()) {
            case FIELD: {
                return element.asType().toString();
            }
            case METHOD: {
                return ((ExecutableElement)element).getReturnType().toString();
            }
        }
        return null;
    }

    private void printError(String message, Element element) {
        this.hasError = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private String jsonObjectReaderPath(Element el, boolean includeErrors) {
        void var6_8;
        String string;
        if (!(el instanceof TypeElement)) {
            return null;
        }
        TypeElement element = (TypeElement)el;
        boolean isJsonObject = false;
        for (TypeMirror typeMirror : element.getInterfaces()) {
            if (!JsonObject.class.getName().equals(typeMirror.toString())) continue;
            isJsonObject = true;
            break;
        }
        if (!isJsonObject) {
            return null;
        }
        VariableElement jsonReaderField = null;
        Object var6_7 = null;
        Element companion = null;
        for (VariableElement variableElement : ElementFilter.fieldsIn(el.getEnclosedElements())) {
            if ("Companion".equals(variableElement.getSimpleName().toString())) {
                if (!variableElement.asType().toString().equals(el.asType().toString() + ".Companion") || !variableElement.getModifiers().contains((Object)Modifier.STATIC) || !variableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !variableElement.getModifiers().contains((Object)Modifier.FINAL)) continue;
                companion = this.types.asElement(variableElement.asType());
                continue;
            }
            if (!"JSON_READER".equals(variableElement.getSimpleName().toString())) continue;
            jsonReaderField = variableElement;
        }
        String signatureType = "com.dslplatform.json.JsonReader.ReadJsonObject<" + element.getQualifiedName() + ">";
        if (!this.onlyBasicFeatures && companion != null && companion.getModifiers().contains((Object)Modifier.STATIC)) {
            for (ExecutableElement method : ElementFilter.methodsIn(companion.getEnclosedElements())) {
                if (!"JSON_READER".equals(method.getSimpleName().toString()) && !"getJSON_READER".equals(method.getSimpleName().toString())) continue;
                ExecutableElement executableElement = method;
            }
        }
        String string2 = string = var6_8 != null ? var6_8.getSimpleName() + " method" : "JSON_READER field";
        if (includeErrors) {
            if (!el.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it's not public. Make it public so it can be used for serialization/deserialization.", el, this.getAnnotation(el, this.converterType));
            } else if (element.getNestingKind().isNested() && !el.getModifiers().contains((Object)Modifier.STATIC)) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it cant be non static nested member. Add static modifier so it can be used for serialization/deserialization.", el, this.getAnnotation(el, this.converterType));
            } else if (this.onlyBasicFeatures && (element.getQualifiedName().contentEquals(element.getSimpleName()) || element.getNestingKind().isNested() && element.getModifiers().contains((Object)Modifier.STATIC) && element.getEnclosingElement() instanceof TypeElement && ((TypeElement)element.getEnclosingElement()).getQualifiedName().contentEquals(element.getEnclosingElement().getSimpleName()))) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but its defined without a package name and cannot be accessed. Either add package to it or use a different analysis configuration which support classes without packages.", element, this.getAnnotation(element, this.converterType));
            } else if (jsonReaderField == null && var6_8 == null) {
                String allowed = this.onlyBasicFeatures ? "field" : "field/method";
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but it doesn't have JSON_READER " + allowed + ". It can't be used for serialization/deserialization this way. You probably want to add public static JSON_READER " + allowed + ".", element, this.getAnnotation(element, this.converterType));
            } else if (var6_8 == null && (!jsonReaderField.getModifiers().contains((Object)Modifier.PUBLIC) || !jsonReaderField.getModifiers().contains((Object)Modifier.STATIC)) || var6_8 != null && (!var6_8.getModifiers().contains((Object)Modifier.PUBLIC) || var6_8.getModifiers().contains((Object)Modifier.STATIC))) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but its " + string + " is not public and static. It can't be used for serialization/deserialization this way. You probably want to change " + string + " so it's public and static.", element, this.getAnnotation(element, this.converterType));
            } else if (jsonReaderField != null && !signatureType.equals(jsonReaderField.asType().toString()) || var6_8 != null && !signatureType.equals(var6_8.getReturnType().toString())) {
                this.hasError = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "'" + element.getQualifiedName() + "' is 'com.dslplatform.json.JsonObject', but its " + string + " is not of correct type. It can't be used for serialization/deserialization this way. You probably want to change " + string + " to: '" + signatureType + "'", element, this.getAnnotation(element, this.converterType));
            }
        }
        String prefix = companion == null ? "" : "Companion.";
        return prefix + (var6_8 != null ? var6_8.getSimpleName().toString() + "()" : "JSON_READER");
    }

    private Map<String, VariableElement> getArguments(@Nullable ExecutableElement element) {
        if (element == null) {
            return Collections.emptyMap();
        }
        HashMap<String, VariableElement> arguments = new HashMap<String, VariableElement>();
        for (VariableElement variableElement : element.getParameters()) {
            arguments.put(variableElement.getSimpleName().toString(), variableElement);
        }
        return arguments;
    }

    private boolean isCompatibileType(TypeMirror left, TypeMirror right) {
        String rightStr;
        if (left.equals(right)) {
            return true;
        }
        String leftStr = left.toString();
        if (leftStr.equals(rightStr = right.toString())) {
            return true;
        }
        int ind = leftStr.indexOf(60);
        if (ind == -1 || rightStr.indexOf(60) != ind) {
            return false;
        }
        if (left.getKind() != right.getKind()) {
            return false;
        }
        if (!leftStr.substring(0, ind).equals(rightStr.substring(0, ind))) {
            return false;
        }
        return this.types.isAssignable(right, left);
    }

    private boolean isCompatibileCollection(TypeMirror left, TypeMirror rawCollection) {
        String rightStr;
        String leftStr = left.toString();
        if (leftStr.equals(rightStr = rawCollection.toString())) {
            return true;
        }
        if (left.getKind() != rawCollection.getKind()) {
            return false;
        }
        TypeMirror leftRaw = this.types.erasure(left);
        return this.types.isAssignable(rawCollection, leftRaw);
    }

    @Deprecated
    public static String beanOrActualName(String name) {
        return Analysis.beanOrActualName(name, true);
    }

    public static String beanOrActualName(String name, boolean isBoolean) {
        if (isBoolean && name.startsWith("is") && name.length() > 2) {
            String after = name.substring(2);
            if (name.length() == 3) {
                return after.toLowerCase();
            }
            return after.toUpperCase().equals(after) ? after : Character.toLowerCase(after.charAt(0)) + after.substring(1);
        }
        if ((name.startsWith("get") || name.startsWith("set")) && name.length() > 3) {
            String after = name.substring(3);
            if (name.length() == 4) {
                return after.toLowerCase();
            }
            return after.toUpperCase().equals(after) ? after : Character.toLowerCase(after.charAt(0)) + after.substring(1);
        }
        return name;
    }

    private Map<String, AccessElements> getBeanProperties(TypeElement element, Map<String, VariableElement> arguments, Map<String, AccessElements> fieldDetails) {
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                String name = method.getSimpleName().toString();
                if (name.length() < 3) continue;
                boolean isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && !method.getModifiers().contains((Object)Modifier.ABSTRACT);
                AnnotationMirror annotation = this.getAnnotation(method, this.attributeType);
                boolean producesWarning = !isAccessible && annotation != null;
                boolean isBoolean = method.getReturnType() != null && "boolean".equals(method.getReturnType().toString());
                String property = Analysis.beanOrActualName(name, isBoolean);
                if (name.startsWith("is") && method.getParameters().size() == 0 && method.getReturnType() != null && method.getReturnType().getKind() == TypeKind.BOOLEAN) {
                    if (producesWarning) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible bean getter method which is ignored during processing. Put annotation on public method instead.", method, annotation);
                        continue;
                    }
                    if (getters.containsKey(property)) continue;
                    getters.put(property, method);
                    continue;
                }
                if (name.startsWith("get") && method.getParameters().size() == 0 && method.getReturnType() != null) {
                    if (producesWarning) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible bean getter method which is ignored during processing. Put annotation on public method instead.", method, annotation);
                        continue;
                    }
                    if (getters.containsKey(property)) continue;
                    getters.put(property, method);
                    continue;
                }
                if (!name.startsWith("set") || method.getParameters().size() != 1) continue;
                if (producesWarning) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible bean setter method which is ignored during processing. Put annotation on public method instead.", method, annotation);
                    continue;
                }
                setters.put(property, method);
            }
        }
        return this.findMatchingResult(setters, getters, arguments, fieldDetails);
    }

    private Map<String, AccessElements> findMatchingResult(Map<String, ExecutableElement> setters, Map<String, ExecutableElement> getters, Map<String, VariableElement> arguments, Map<String, AccessElements> fieldDetails) {
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry<String, ExecutableElement> kv : getters.entrySet()) {
            boolean hasMarker;
            AnnotationMirror annotation;
            ExecutableElement setter = setters.get(kv.getKey());
            VariableElement setterArgument = setter == null ? null : setter.getParameters().get(0);
            VariableElement arg = arguments.get(kv.getKey());
            String returnType = kv.getValue().getReturnType().toString();
            AnnotationMirror actualAnnotation = this.annotation(kv.getValue(), setter, null, arg);
            AccessElements field = fieldDetails.get(kv.getKey());
            AnnotationMirror annotationMirror = actualAnnotation != null ? actualAnnotation : (annotation = field != null ? field.annotation : null);
            if (setterArgument != null && setterArgument.asType().toString().equals(returnType)) {
                result.put(kv.getKey(), AccessElements.readWrite(kv.getValue(), setter, annotation));
                continue;
            }
            if (setterArgument != null && (setterArgument.asType() + "<").startsWith(returnType)) {
                result.put(kv.getKey(), AccessElements.readWrite(kv.getValue(), setter, annotation));
                continue;
            }
            if (!this.onlyBasicFeatures && arg != null && this.isCompatibileType(arg.asType(), kv.getValue().getReturnType())) {
                result.put(kv.getKey(), AccessElements.readOnly(kv.getValue(), arg, annotation));
                continue;
            }
            if (arg != null || setterArgument != null || !this.isAppendableCollection(kv.getValue())) continue;
            boolean bl = hasMarker = annotation != null || this.hasCustomMarker(kv.getValue()) || field != null && field.field != null && this.hasCustomMarker(field.field);
            if (!hasMarker) continue;
            if (this.hasNonNullable(kv.getValue(), field != null ? field.field : null, annotation)) {
                result.put(kv.getKey(), AccessElements.collection(kv.getValue(), annotation));
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on collection property, but non-nullable marker is missing. Property will be ignored.", kv.getValue(), annotation);
        }
        return result;
    }

    private boolean isAppendableCollection(ExecutableElement getter) {
        TypeMirror type = getter.getReturnType();
        return this.isCompatibileCollection(type, this.baseListType) || this.isCompatibileCollection(type, this.baseSetType);
    }

    private Map<String, AccessElements> getExactProperties(TypeElement element, Map<String, VariableElement> arguments, Map<String, AccessElements> fieldDetails) {
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean producesWarning;
                String name = method.getSimpleName().toString();
                if (name.startsWith("get") || name.startsWith("is") || name.startsWith("set")) continue;
                boolean isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT) && !method.getModifiers().contains((Object)Modifier.ABSTRACT);
                AnnotationMirror annotation = this.getAnnotation(method, this.attributeType);
                boolean bl = producesWarning = !isAccessible && annotation != null;
                if (method.getParameters().size() == 0 && method.getReturnType() != null) {
                    if (producesWarning) {
                        this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible setter method which is ignored during processing. Put annotation on public method instead.", method, annotation);
                        continue;
                    }
                    if (getters.containsKey(name)) continue;
                    getters.put(name, method);
                    continue;
                }
                if (method.getParameters().size() != 1) continue;
                if (producesWarning) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible setter method which is ignored during processing. Put annotation on public method instead.", method, annotation);
                    continue;
                }
                setters.put(name, method);
            }
        }
        return this.findMatchingResult(setters, getters, arguments, fieldDetails);
    }

    private Map<String, AccessElements> getPublicFields(TypeElement element, Map<String, VariableElement> arguments, Set<String> processed) {
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                boolean isAccessible;
                String name = field.getSimpleName().toString();
                boolean isFinal = field.getModifiers().contains((Object)Modifier.FINAL);
                VariableElement arg = arguments.get(name);
                boolean bl = isAccessible = field.getModifiers().contains((Object)Modifier.PUBLIC) && (!isFinal || arg != null) && !field.getModifiers().contains((Object)Modifier.NATIVE) && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
                if (!isAccessible) {
                    AnnotationMirror fieldAnnotation = this.getAnnotation(field, this.attributeType);
                    if (fieldAnnotation == null || processed.contains(name)) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible field which is ignored during processing. Put annotation on public field instead.", field, fieldAnnotation);
                    continue;
                }
                AnnotationMirror annotation = this.annotation(null, null, field, arg);
                result.put(name, AccessElements.field(field, arg, annotation));
            }
        }
        return result;
    }

    private Map<String, AccessElements> getFieldDetails(TypeElement element) {
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                String name = field.getSimpleName().toString();
                if (field.getModifiers().contains((Object)Modifier.NATIVE) || field.getModifiers().contains((Object)Modifier.TRANSIENT) || field.getModifiers().contains((Object)Modifier.STATIC)) continue;
                AnnotationMirror annotation = this.annotation(null, null, field, null);
                result.put(name, AccessElements.field(field, field, annotation));
            }
        }
        return result;
    }

    private Map<String, AccessElements> getBuilderProperties(TypeElement element, BuilderInfo builder, boolean withBeans, boolean withExact, boolean withFields) {
        VariableElement setArg;
        ExecutableElement setter;
        HashMap<String, ExecutableElement> setters = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> getters = new HashMap<String, ExecutableElement>();
        HashMap<String, VariableElement> fields = new HashMap<String, VariableElement>();
        TypeMirror builderType = builder.type.asType();
        for (TypeElement inheritance : this.getTypeHierarchy(element)) {
            String name;
            boolean isPublicInterface = inheritance.getKind() == ElementKind.INTERFACE && inheritance.getModifiers().contains((Object)Modifier.PUBLIC);
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean canAdd;
                boolean isAccessible;
                name = method.getSimpleName().toString();
                boolean bl = isAccessible = isPublicInterface && !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT);
                if (!isAccessible) {
                    if (this.getAnnotation(method, this.attributeType) == null) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible builder method which is ignored during processing. Put annotation on public method instead.", element);
                    continue;
                }
                boolean isBoolean = method.getReturnType() != null && "boolean".equals(method.getReturnType().toString());
                String property = Analysis.beanOrActualName(name, isBoolean);
                if (method.getParameters().size() != 0 || method.getReturnType() == null || !(canAdd = withExact || withBeans && name.startsWith("get") && name.length() > 4 || withBeans && name.startsWith("is") && name.length() > 3) || getters.containsKey(property)) continue;
                getters.put(property, method);
            }
            if (!withFields) continue;
            for (VariableElement field : ElementFilter.fieldsIn(inheritance.getEnclosedElements())) {
                boolean isAccessible;
                name = field.getSimpleName().toString();
                boolean isFinal = field.getModifiers().contains((Object)Modifier.FINAL);
                boolean bl = isAccessible = field.getModifiers().contains((Object)Modifier.PUBLIC) && !field.getModifiers().contains((Object)Modifier.NATIVE) && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
                if (!isAccessible || !isFinal) {
                    if (this.getAnnotation(field, this.attributeType) == null || getters.containsKey(name)) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible builder field which is ignored during processing. Put annotation on public field instead.", element);
                    continue;
                }
                fields.put(name, field);
            }
        }
        for (TypeElement inheritance : this.getTypeHierarchy(builder.type)) {
            for (ExecutableElement method : ElementFilter.methodsIn(inheritance.getEnclosedElements())) {
                boolean canAdd;
                boolean isAccessible;
                String name = method.getSimpleName().toString();
                boolean bl = isAccessible = !method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.PUBLIC) && !method.getModifiers().contains((Object)Modifier.STATIC) && !method.getModifiers().contains((Object)Modifier.NATIVE) && !method.getModifiers().contains((Object)Modifier.TRANSIENT);
                if (!isAccessible) {
                    if (this.getAnnotation(method, this.attributeType) == null) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, this.attributeType.toString() + " detected on non accessible builder method which is ignored during processing. Put annotation on public method instead.", element);
                    continue;
                }
                boolean isBoolean = method.getReturnType() != null && "boolean".equals(method.getReturnType().toString());
                String property = Analysis.beanOrActualName(name, isBoolean);
                if (method.getParameters().size() != 1 || !this.types.isSameType(method.getReturnType(), builderType) || !(canAdd = withExact || withBeans && name.startsWith("set") && name.length() > 4) || setters.containsKey(property)) continue;
                setters.put(property, method);
            }
        }
        HashMap<String, AccessElements> result = new HashMap<String, AccessElements>();
        for (Map.Entry kv : getters.entrySet()) {
            setter = (ExecutableElement)setters.get(kv.getKey());
            setArg = setter == null ? null : setter.getParameters().get(0);
            String returnType = ((ExecutableElement)kv.getValue()).getReturnType().toString();
            AnnotationMirror annotation = this.annotation((ExecutableElement)kv.getValue(), setter, null, null);
            if (setArg == null || !setArg.asType().toString().equals(returnType) && !(setArg.asType() + "<").startsWith(returnType)) continue;
            result.put((String)kv.getKey(), AccessElements.readWrite((ExecutableElement)kv.getValue(), setter, annotation));
        }
        for (Map.Entry kv : fields.entrySet()) {
            if (result.containsKey(kv.getKey())) continue;
            setter = (ExecutableElement)setters.get(kv.getKey());
            setArg = setter == null ? null : setter.getParameters().get(0);
            String returnType = ((VariableElement)kv.getValue()).asType().toString();
            AnnotationMirror annotation = this.annotation(null, setter, (VariableElement)kv.getValue(), null);
            if (setArg == null || !setArg.asType().toString().equals(returnType) && !(setArg.asType() + "<").startsWith(returnType)) continue;
            result.put((String)kv.getKey(), AccessElements.readOnly((VariableElement)kv.getValue(), setter, annotation));
        }
        return result;
    }

    private void findImplementations(Collection<StructInfo> structs) {
        for (StructInfo current : structs) {
            if (current.type != ObjectType.MIXIN) continue;
            String signature = current.element.asType().toString();
            for (StructInfo info : structs) {
                if (info.type != ObjectType.CLASS) continue;
                this.checkParentSignatures(info, info.element, current.implementations, signature, new HashSet<TypeElement>());
            }
        }
    }

    private void checkParentSignatures(StructInfo info, TypeElement element, Set<StructInfo> implementations, String signature, Set<TypeElement> processed) {
        if (!processed.add(element) || element.getQualifiedName().contentEquals("java.lang.Object")) {
            return;
        }
        if (element.asType().toString().equals(signature)) {
            implementations.add(info);
        }
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            Element current = this.types.asElement(typeMirror);
            if (!(current instanceof TypeElement)) continue;
            this.checkParentSignatures(info, (TypeElement)current, implementations, signature, processed);
            StructInfo child = this.structs.get(signature);
            info.supertype(child);
        }
    }

    @Nullable
    private String[] getAlternativeNames(AnnotationMirror dslAnn) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> ee : values.entrySet()) {
            if (!ee.getKey().toString().equals("alternativeNames()")) continue;
            List val = (List)ee.getValue().getValue();
            if (val == null) {
                return null;
            }
            String[] names = new String[val.size()];
            for (int i = 0; i < val.size(); ++i) {
                names[i] = ((AnnotationValue)val.get(i)).getValue().toString();
            }
            return names;
        }
        return null;
    }

    private boolean isFullMatch(@Nullable AnnotationMirror dslAnn) {
        if (dslAnn == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("hashMatch()")) continue;
            Object val = values.get(executableElement).getValue();
            return val != null && (Boolean)val == false;
        }
        return false;
    }

    private int index(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("index()")) continue;
                Object val = values.get(executableElement).getValue();
                if (val == null) {
                    return -1;
                }
                return (Integer)val;
            }
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Integer n = Analysis.matchCustomInteger(annotationMirror, this.alternativeIndex);
            if (n == null || n == -1) continue;
            return n;
        }
        return -1;
    }

    @Nullable
    private AnnotationMirror annotation(@Nullable ExecutableElement read, @Nullable ExecutableElement write, @Nullable VariableElement field, @Nullable VariableElement arg) {
        AnnotationMirror dslAnn;
        AnnotationMirror annotationMirror = dslAnn = read == null ? null : this.getAnnotation(read, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        AnnotationMirror annotationMirror2 = dslAnn = write == null ? null : this.getAnnotation(write, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        AnnotationMirror annotationMirror3 = dslAnn = field == null ? null : this.getAnnotation(field, this.attributeType);
        if (dslAnn != null) {
            return dslAnn;
        }
        return arg == null ? null : this.getAnnotation(arg, this.attributeType);
    }

    private boolean hasIgnoredAnnotation(Element property, @Nullable AnnotationMirror dslAnn, @Nullable VariableElement field) {
        if (dslAnn != null) {
            return Analysis.booleanAnnotationValue(dslAnn, "ignore()", false);
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            if (!this.alternativeIgnore.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        if (field != null) {
            for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
                if (!this.alternativeIgnore.contains(annotationMirror.getAnnotationType().toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private AnnotationMirror scanClassForAnnotation(TypeElement element, DeclaredType annotationType, @Nullable ExecutableElement custom) {
        AnnotationMirror discAnn;
        AnnotationMirror target;
        AnnotationMirror annotationMirror = target = custom != null ? this.getAnnotation(custom, annotationType) : null;
        if (target != null) {
            return target;
        }
        target = this.getAnnotation(element, annotationType);
        if (target != null) {
            return target;
        }
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            discAnn = this.getAnnotation(method, annotationType);
            if (discAnn == null) continue;
            return discAnn;
        }
        for (ExecutableElement constructor : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            discAnn = this.getAnnotation(constructor, annotationType);
            if (discAnn == null) continue;
            return discAnn;
        }
        return null;
    }

    @Nullable
    private AnnotationMirror getAnnotation(Element element, DeclaredType annotationType) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.types.isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    private boolean hasNonNullable(Element property, @Nullable VariableElement field, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("nullable()")) continue;
                Object val = values.get(executableElement).getValue();
                return val != null && (Boolean)val == false;
            }
            return false;
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Boolean bl = Analysis.matchCustomBoolean(annotationMirror, this.alternativeNonNullable);
            if (bl == null) continue;
            return bl;
        }
        if (field != null) {
            for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
                Boolean bl = Analysis.matchCustomBoolean(annotationMirror, this.alternativeNonNullable);
                if (bl == null) continue;
                return bl;
            }
        }
        return false;
    }

    @Nullable
    private static TypeElement deserializeAs(AnnotationMirror annotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("deserializeAs()")) continue;
            DeclaredType target = (DeclaredType)values.get(executableElement).getValue();
            return (TypeElement)target.asElement();
        }
        return null;
    }

    private static String classDiscriminator(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("discriminator()")) continue;
            return values.get(executableElement).getValue().toString();
        }
        return "";
    }

    private static String className(@Nullable AnnotationMirror annotation) {
        if (annotation == null) {
            return "";
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("name()")) continue;
            return values.get(executableElement).getValue().toString();
        }
        return "";
    }

    private boolean hasMandatoryAnnotation(Element property, @Nullable AnnotationMirror dslAnn) {
        if (dslAnn != null) {
            return Analysis.booleanAnnotationValue(dslAnn, "mandatory()", false);
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            Boolean match = Analysis.matchCustomBoolean(annotationMirror, this.alternativeMandatory);
            if (match == null) continue;
            return match;
        }
        return false;
    }

    private static boolean booleanAnnotationValue(AnnotationMirror ann, String method, boolean defaultValue) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals(method)) continue;
            Object val = values.get(executableElement).getValue();
            return val == null ? defaultValue : (Boolean)val;
        }
        return defaultValue;
    }

    @Nullable
    private CompiledJson.Behavior onUnknownValue(@Nullable AnnotationMirror annotation) {
        return Analysis.enumAnnotationElementValue(annotation, "onUnknown()", CompiledJson.Behavior.class);
    }

    @Nullable
    private CompiledJson.TypeSignature typeSignatureValue(@Nullable AnnotationMirror annotation) {
        return Analysis.enumAnnotationElementValue(annotation, "typeSignature()", CompiledJson.TypeSignature.class);
    }

    private CompiledJson.ObjectFormatPolicy objectFormatPolicyValue(@Nullable AnnotationMirror annotation) {
        CompiledJson.ObjectFormatPolicy value = Analysis.enumAnnotationElementValue(annotation, "objectFormatPolicy()", CompiledJson.ObjectFormatPolicy.class);
        return value != null ? value : CompiledJson.ObjectFormatPolicy.DEFAULT;
    }

    private JsonAttribute.IncludePolicy includeToMinimalValue(@Nullable AnnotationMirror annotation) {
        JsonAttribute.IncludePolicy value = Analysis.enumAnnotationElementValue(annotation, "includeToMinimal()", JsonAttribute.IncludePolicy.class);
        return value != null ? value : JsonAttribute.IncludePolicy.NON_DEFAULT;
    }

    private CompiledJson.Format[] getFormats(@Nullable AnnotationMirror ann) {
        if (ann == null) {
            return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!"formats()".equals(executableElement.toString())) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
            }
            List list = (List)val;
            CompiledJson.Format[] result = new CompiledJson.Format[list.size()];
            for (int i = 0; i < result.length; ++i) {
                AnnotationValue enumVal = (AnnotationValue)list.get(i);
                result[i] = CompiledJson.Format.valueOf(enumVal.getValue().toString());
            }
            return result;
        }
        return new CompiledJson.Format[]{CompiledJson.Format.OBJECT};
    }

    @Nullable
    private static <T extends Enum<T>> T enumAnnotationElementValue(@Nullable AnnotationMirror annotation, String elementName, Class<T> enumClass) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotation.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals(elementName)) continue;
            Object val = values.get(executableElement).getValue();
            if (val == null) {
                return null;
            }
            return Enum.valueOf(enumClass, val.toString());
        }
        return null;
    }

    private boolean isMinified(@Nullable AnnotationMirror ann) {
        if (ann == null) {
            return false;
        }
        for (ExecutableElement executableElement : ann.getElementValues().keySet()) {
            if (!"minified()".equals(executableElement.toString())) continue;
            AnnotationValue minified = ann.getElementValues().get(executableElement);
            return (Boolean)minified.getValue();
        }
        return false;
    }

    @Nullable
    private TypeMirror findConverter(Element property) {
        return this.findConverter(this.getAnnotation(property, this.attributeType));
    }

    @Nullable
    private TypeMirror findConverter(@Nullable AnnotationMirror dslAnn) {
        if (dslAnn == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
        for (ExecutableElement executableElement : values.keySet()) {
            if (!executableElement.toString().equals("converter()")) continue;
            TypeMirror mirror = (TypeMirror)values.get(executableElement).getValue();
            return mirror != null && mirror.toString().equals(JsonAttribute.class.getName()) ? null : mirror;
        }
        return null;
    }

    @Nullable
    private String findNameAlias(Element property, @Nullable VariableElement field, @Nullable AnnotationMirror dslAnn, String member) {
        if (dslAnn != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = dslAnn.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals("name()")) continue;
                String val = (String)values.get(executableElement).getValue();
                if (val != null && val.length() == 0) {
                    return null;
                }
                return val;
            }
            return null;
        }
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            String string = Analysis.matchCustomString(annotationMirror, this.alternativeAlias);
            if (string == null || string.isEmpty()) continue;
            return string;
        }
        if (field != null) {
            if (field.getModifiers().contains((Object)Modifier.NATIVE) || field.getModifiers().contains((Object)Modifier.TRANSIENT) || field.getModifiers().contains((Object)Modifier.STATIC)) {
                return null;
            }
            for (AnnotationMirror annotationMirror : field.getAnnotationMirrors()) {
                String string = Analysis.matchCustomString(annotationMirror, this.alternativeAlias);
                if (string == null || string.isEmpty()) continue;
                return string;
            }
        }
        return null;
    }

    private boolean hasCustomMarker(Element property) {
        for (AnnotationMirror annotationMirror : property.getAnnotationMirrors()) {
            if (!this.alternativeAlias.containsKey(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Boolean matchCustomBoolean(AnnotationMirror ann, Map<String, List<AnnotationMapping<Boolean>>> alternatives) {
        String name = ann.getAnnotationType().toString();
        if (alternatives.containsKey(name)) {
            List<AnnotationMapping<Boolean>> mappings = alternatives.get(name);
            if (mappings == null || mappings.isEmpty()) {
                return true;
            }
            for (AnnotationMapping<Boolean> m : mappings) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
                for (ExecutableElement executableElement : values.keySet()) {
                    if (!executableElement.toString().equals(m.name)) continue;
                    Object val = values.get(executableElement).getValue();
                    if (val == null && m.value == null) {
                        return true;
                    }
                    return val != null && val == m.value;
                }
            }
        }
        return null;
    }

    @Nullable
    private static String matchCustomString(AnnotationMirror ann, Map<String, String> alternatives) {
        String value = alternatives.get(ann.getAnnotationType().toString());
        if (value != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals(value)) continue;
                AnnotationValue val = values.get(executableElement);
                if (val == null) {
                    return null;
                }
                if (val.getValue() == null) {
                    return null;
                }
                return val.getValue().toString();
            }
        }
        return null;
    }

    @Nullable
    private static Integer matchCustomInteger(AnnotationMirror ann, Map<String, String> alternatives) {
        String value = alternatives.get(ann.getAnnotationType().toString());
        if (value != null) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = ann.getElementValues();
            for (ExecutableElement executableElement : values.keySet()) {
                if (!executableElement.toString().equals(value)) continue;
                AnnotationValue val = values.get(executableElement);
                if (val == null) {
                    return null;
                }
                if (val.getValue() == null) {
                    return null;
                }
                return (Integer)val.getValue();
            }
        }
        return null;
    }

    private static class AccessElements {
        @Nullable
        public final ExecutableElement read;
        @Nullable
        public final ExecutableElement write;
        @Nullable
        public final VariableElement field;
        @Nullable
        public final VariableElement arg;
        @Nullable
        public final AnnotationMirror annotation;

        private AccessElements(@Nullable ExecutableElement read, @Nullable ExecutableElement write, @Nullable VariableElement arg, @Nullable VariableElement field, @Nullable AnnotationMirror annotation) {
            this.read = read;
            this.write = write;
            this.field = field;
            this.arg = arg;
            this.annotation = annotation;
        }

        public static AccessElements readWrite(ExecutableElement read, ExecutableElement write, @Nullable AnnotationMirror annotation) {
            return new AccessElements(read, write, null, null, annotation);
        }

        public static AccessElements field(VariableElement field, VariableElement arg, @Nullable AnnotationMirror annotation) {
            return new AccessElements(null, null, arg, field, annotation);
        }

        public static AccessElements readOnly(ExecutableElement read, VariableElement arg, @Nullable AnnotationMirror annotation) {
            return new AccessElements(read, null, arg, null, annotation);
        }

        public static AccessElements readOnly(VariableElement field, ExecutableElement write, @Nullable AnnotationMirror annotation) {
            return new AccessElements(null, write, null, field, annotation);
        }

        public static AccessElements collection(ExecutableElement read, @Nullable AnnotationMirror annotation) {
            return new AccessElements(read, null, null, null, annotation);
        }
    }

    private static enum PartKind {
        UNKNOWN,
        RAW_TYPE,
        TYPE_VARIABLE,
        OTHER;

    }

    private class PropertyAnalysis {
        public final ExecutableElement creator;
        public final Map<String, AccessElements> allFieldDetails;
        public final Set<String> allKeys = new HashSet<String>();
        public final Map<String, AccessElements> beans;
        public final Map<String, AccessElements> exact;
        public final Map<String, AccessElements> fields;

        public PropertyAnalysis(ExecutableElement creator, TypeElement element, Map<String, VariableElement> arguments) {
            this.creator = creator;
            this.allFieldDetails = Analysis.this.getFieldDetails(element);
            this.beans = Analysis.this.includeBeanMethods ? Analysis.this.getBeanProperties(element, arguments, this.allFieldDetails) : Collections.emptyMap();
            this.exact = Analysis.this.includeExactMethods ? Analysis.this.getExactProperties(element, arguments, this.allFieldDetails) : Collections.emptyMap();
            this.allKeys.addAll(this.beans.keySet());
            this.allKeys.addAll(this.exact.keySet());
            this.fields = Analysis.this.includeFields ? Analysis.this.getPublicFields(element, arguments, this.allKeys) : Collections.emptyMap();
            this.allKeys.addAll(this.fields.keySet());
        }
    }

    public static class AnnotationMapping<T> {
        public final String name;
        public final T value;

        public AnnotationMapping(String name, @Nullable T value) {
            this.name = name;
            this.value = value;
        }
    }
}

