/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.Generics;
import com.dslplatform.json.runtime.GenericsMapper;
import com.dslplatform.json.runtime.InstanceFactory;
import com.dslplatform.json.runtime.ObjectFormatDescription;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class ObjectAnalyzer {
    public static final DslJson.ConverterFactory<ObjectFormatDescription> CONVERTER = new DslJson.ConverterFactory<ObjectFormatDescription>(){

        @Nullable
        public ObjectFormatDescription tryCreate(Type manifest, DslJson dslJson) {
            if (manifest instanceof Class) {
                return ObjectAnalyzer.analyze(manifest, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)manifest;
                return ObjectAnalyzer.analyze(manifest, (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static <T> ObjectFormatDescription<T, T> analyze(Type manifest, final Class<T> raw, DslJson json) {
        if (raw.isArray() || Object.class == manifest || Collection.class.isAssignableFrom(raw) || raw.isInterface() || (raw.getModifiers() & 0x400) != 0 || raw.getDeclaringClass() != null && (raw.getModifiers() & 8) == 0) {
            return null;
        }
        Set currentEncoders = json.getRegisteredEncoders();
        Set currentDecoders = json.getRegisteredDecoders();
        Set currentBinders = json.getRegisteredBinders();
        boolean hasEncoder = currentEncoders.contains(manifest);
        boolean hasDecoder = currentDecoders.contains(manifest);
        boolean hasBinder = currentBinders.contains(manifest);
        InstanceFactory newInstance = ObjectAnalyzer.pickMarkedFactory(raw, json);
        if (json.context != null && newInstance == null) {
            newInstance = ObjectAnalyzer.pickCtorFactory(raw, json);
        }
        if (newInstance == null) {
            try {
                raw.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ignore) {
                return null;
            }
            newInstance = new InstanceFactory(){

                public Object create() {
                    try {
                        return raw.newInstance();
                    }
                    catch (Exception ex) {
                        throw new ConfigurationException("Unable to create an instance of " + raw);
                    }
                }
            };
        }
        LazyObjectDescription lazy = new LazyObjectDescription(json, manifest);
        if (!hasEncoder) {
            json.registerWriter(manifest, (JsonWriter.WriteObject)lazy);
        }
        if (!hasDecoder) {
            json.registerReader(manifest, (JsonReader.ReadObject)lazy);
        }
        LinkedHashMap<String, JsonWriter.WriteObject> foundWrite = new LinkedHashMap<String, JsonWriter.WriteObject>();
        LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>> foundRead = new LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>>();
        GenericsMapper genericMappings = GenericsMapper.create(manifest, raw);
        int index = 0;
        for (Field field : raw.getFields()) {
            if (!ObjectAnalyzer.analyzeField(json, foundWrite, foundRead, field, index, field.getDeclaringClass(), genericMappings)) continue;
            ++index;
        }
        for (AccessibleObject accessibleObject : raw.getMethods()) {
            if (!ObjectAnalyzer.analyzeMethods((Method)accessibleObject, raw, json, foundWrite, foundRead, index, ((Method)accessibleObject).getDeclaringClass(), genericMappings)) continue;
            ++index;
        }
        JsonWriter.WriteObject[] writeProps = foundWrite.values().toArray(new JsonWriter.WriteObject[0]);
        DecodePropertyInfo[] readProps = foundRead.values().toArray(new DecodePropertyInfo[0]);
        ObjectFormatDescription<T, T> converter = ObjectFormatDescription.create(raw, newInstance, writeProps, readProps, json, true);
        if (!hasEncoder) {
            json.registerWriter(manifest, converter);
        }
        if (!hasDecoder) {
            json.registerReader(manifest, converter);
        }
        if (!hasBinder) {
            json.registerBinder(manifest, converter);
        }
        lazy.resolved = converter;
        return converter;
    }

    static boolean matchesContext(Type manifest, DslJson json) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        if (json.context == null) {
            return false;
        }
        Class<?> signature = json.context.getClass();
        if (manifest.equals(signature)) {
            return true;
        }
        if (manifest instanceof Class) {
            return ((Class)manifest).isAssignableFrom(signature);
        }
        if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            return ((Class)pt.getRawType()).isAssignableFrom(signature);
        }
        return false;
    }

    @Nullable
    private static <T> InstanceFactory pickCtorFactory(final Class<?> raw, final DslJson<T> json) {
        if (json.context == null) {
            return null;
        }
        Map creatorMarkers = json.getRegisteredCreatorMarkers();
        ArrayList matchedCtors = null;
        for (Constructor<?> ctor : raw.getDeclaredConstructors()) {
            if (ctor.getParameterCount() != 1 || !ObjectAnalyzer.matchesContext(ctor.getGenericParameterTypes()[0], json)) continue;
            boolean isPublic = (ctor.getModifiers() & 1) == 1;
            boolean hasMarker = false;
            if (!creatorMarkers.isEmpty()) {
                for (Map.Entry kv : creatorMarkers.entrySet()) {
                    if (ctor.getAnnotation((Class)kv.getKey()) == null || !isPublic && !((Boolean)kv.getValue()).booleanValue()) continue;
                    if (!isPublic) {
                        try {
                            ctor.setAccessible(true);
                        }
                        catch (Exception ex) {
                            throw new ConfigurationException("Unable to promote access for private constructor " + ctor + ". Please check environment setup, or set marker on public constructor", (Throwable)ex);
                        }
                    }
                    hasMarker = true;
                    break;
                }
            }
            try {
                ctor.newInstance(json.context);
                if (matchedCtors == null) {
                    matchedCtors = new ArrayList(1);
                }
                if (hasMarker) {
                    matchedCtors.add(0, ctor);
                    continue;
                }
                matchedCtors.add(ctor);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                if (!hasMarker) continue;
                throw new ConfigurationException("Unable to test marked constructor " + ctor + ". Please check environment setup or constructor implementation", (Throwable)ex);
            }
        }
        if (matchedCtors == null) {
            return null;
        }
        final Constructor ctor = (Constructor)matchedCtors.get(0);
        return new InstanceFactory(){

            public Object create() {
                try {
                    return ctor.newInstance(json.context);
                }
                catch (Exception ex) {
                    throw new ConfigurationException("Unable to create an instance of " + raw);
                }
            }
        };
    }

    @Nullable
    private static <T> InstanceFactory pickMarkedFactory(final Class<?> raw, final DslJson<T> json) {
        Map creatorMarkers = json.getRegisteredCreatorMarkers();
        if (creatorMarkers.isEmpty()) {
            return null;
        }
        for (final Method factory : raw.getDeclaredMethods()) {
            int modifiers = factory.getModifiers();
            if ((modifiers & 8) != 8 || factory.getParameterCount() > 1 || !raw.isAssignableFrom(factory.getReturnType()) || factory.getParameterCount() == 1 && !ObjectAnalyzer.matchesContext(factory.getGenericParameterTypes()[0], json)) continue;
            boolean isPublic = (modifiers & 1) == 1;
            for (Map.Entry kv : creatorMarkers.entrySet()) {
                if (factory.getAnnotation((Class)kv.getKey()) == null || !isPublic && !((Boolean)kv.getValue()).booleanValue()) continue;
                if (!isPublic) {
                    try {
                        factory.setAccessible(true);
                    }
                    catch (Exception ex) {
                        throw new ConfigurationException("Unable to promote access for private factory " + factory + ". Please check environment setup, or set marker on public method", (Throwable)ex);
                    }
                }
                try {
                    if (factory.getParameterCount() == 1) {
                        factory.invoke(null, json.context);
                        return new InstanceFactory(){

                            public Object create() {
                                try {
                                    return factory.invoke(null, json.context);
                                }
                                catch (Exception ex) {
                                    throw new ConfigurationException("Unable to create an instance of " + raw);
                                }
                            }
                        };
                    }
                    factory.invoke(null, new Object[0]);
                    return new InstanceFactory(){

                        public Object create() {
                            try {
                                return factory.invoke(null, new Object[0]);
                            }
                            catch (Exception ex) {
                                throw new ConfigurationException("Unable to create an instance of " + raw);
                            }
                        }
                    };
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new ConfigurationException("Unable to test marked factory " + factory + ". Please check environment setup or factory implementation", (Throwable)ex);
                }
            }
        }
        return null;
    }

    private static boolean analyzeField(DslJson json, LinkedHashMap<String, JsonWriter.WriteObject> foundWrite, LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>> foundRead, Field field, int index, Class<?> raw, GenericsMapper genericMappings) {
        if (!ObjectAnalyzer.canRead(field.getModifiers()) || !ObjectAnalyzer.canWrite(field.getModifiers())) {
            return false;
        }
        Type type = field.getGenericType();
        Type concreteType = genericMappings.makeConcrete(type, raw);
        boolean isUnknown = Generics.isUnknownType(type);
        if (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null) {
            foundWrite.put(field.getName(), Settings.createEncoder(new Reflection.ReadField(field), field.getName(), json, isUnknown ? null : concreteType));
            foundRead.put(field.getName(), Settings.createDecoder(new Reflection.SetField(field), field.getName(), json, false, false, index, false, concreteType));
            return true;
        }
        return false;
    }

    private static boolean analyzeMethods(Method mget, Class<?> manifest, DslJson json, LinkedHashMap<String, JsonWriter.WriteObject> foundWrite, LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>> foundRead, int index, Class<?> declaringClass, GenericsMapper genericMappings) {
        Method mset;
        if (mget.getParameterTypes().length != 0) {
            return false;
        }
        String setName = mget.getName().startsWith("get") ? "set" + mget.getName().substring(3) : mget.getName();
        try {
            mset = manifest.getMethod(setName, mget.getReturnType());
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
        boolean isBoolean = Boolean.TYPE.equals(mget.getReturnType());
        String name = Analysis.beanOrActualName((String)mget.getName(), (boolean)isBoolean);
        if (!ObjectAnalyzer.canRead(mget.getModifiers()) || !ObjectAnalyzer.canWrite(mset.getModifiers())) {
            return false;
        }
        if (foundRead.containsKey(name) && foundWrite.containsKey(name)) {
            return false;
        }
        Type type = mget.getGenericReturnType();
        Type concreteType = genericMappings.makeConcrete(type, declaringClass);
        boolean isUnknown = Generics.isUnknownType(type);
        if (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null) {
            foundWrite.put(name, Settings.createEncoder(new Reflection.ReadMethod(mget), name, json, isUnknown ? null : concreteType));
            foundRead.put(name, Settings.createDecoder(new Reflection.SetMethod(mset), name, json, false, false, index, false, concreteType));
            return true;
        }
        return false;
    }

    private static boolean canRead(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 8) == 0;
    }

    private static boolean canWrite(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 0x10) == 0 && (modifiers & 8) == 0;
    }

    private static class LazyObjectDescription
    implements JsonWriter.WriteObject,
    JsonReader.ReadObject,
    JsonReader.BindObject {
        private final DslJson json;
        private final Type type;
        private JsonWriter.WriteObject resolvedWriter;
        private JsonReader.BindObject resolvedBinder;
        private JsonReader.ReadObject resolvedReader;
        volatile ObjectFormatDescription resolved;

        LazyObjectDescription(DslJson json, Type type) {
            this.json = json;
            this.type = type;
        }

        private boolean checkSignatureNotFound() {
            ObjectFormatDescription local = null;
            for (int i = 0; i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new ConfigurationException((Throwable)e);
                }
                local = this.resolved;
                if (local == null) continue;
                this.resolvedWriter = local;
                this.resolvedReader = local;
                this.resolvedBinder = local;
                break;
            }
            return local == null;
        }

        public Object read(JsonReader reader) throws IOException {
            if (this.resolvedReader == null && this.checkSignatureNotFound()) {
                JsonReader.ReadObject tmp = this.json.tryFindReader(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find reader for " + this.type);
                }
                this.resolvedReader = tmp;
            }
            return this.resolvedReader.read(reader);
        }

        public Object bind(JsonReader reader, Object instance) throws IOException {
            if (this.resolvedBinder == null && this.checkSignatureNotFound()) {
                JsonReader.BindObject tmp = this.json.tryFindBinder(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find binder for " + this.type);
                }
                this.resolvedBinder = tmp;
            }
            return this.resolvedBinder.bind(reader, instance);
        }

        public void write(JsonWriter writer, @Nullable Object value) {
            if (this.resolvedWriter == null && this.checkSignatureNotFound()) {
                JsonWriter.WriteObject tmp = this.json.tryFindWriter(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find writer for " + this.type);
                }
                this.resolvedWriter = tmp;
            }
            this.resolvedWriter.write(writer, value);
        }
    }

    public static class Runtime {
        public static final JsonReader.ReadObject<Object> JSON_READER = new JsonReader.ReadObject<Object>(){

            public Object read(JsonReader r) throws IOException {
                if (r.wasNull()) {
                    return null;
                }
                return ObjectConverter.deserializeObject((JsonReader)r);
            }
        };
        public static final JsonWriter.WriteObject<Object> JSON_WRITER = new JsonWriter.WriteObject<Object>(){

            public void write(JsonWriter writer, @Nullable Object value) {
                if (value != null) {
                    writer.serializeObject(value);
                } else {
                    writer.writeNull();
                }
            }
        };
    }
}

