/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.codec;

import com.github.mauricio.async.db.exceptions.NegativeMessageSizeException;
import com.github.mauricio.async.db.postgresql.codec.MessageDecoder$;
import com.github.mauricio.async.db.postgresql.exceptions.MessageTooLongException;
import com.github.mauricio.async.db.postgresql.messages.backend.SSLResponseMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ServerMessage;
import com.github.mauricio.async.db.postgresql.parsers.AuthenticationStartupParser$;
import com.github.mauricio.async.db.postgresql.parsers.MessageParsersRegistry;
import com.github.mauricio.async.db.util.BufferDumper;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}r!B\u0001\u0003\u0011\u0003\t\u0012AD'fgN\fw-\u001a#fG>$WM\u001d\u0006\u0003\u0007\u0011\tQaY8eK\u000eT!!\u0002\u0004\u0002\u0015A|7\u000f^4sKN\fHN\u0003\u0002\b\u0011\u0005\u0011AM\u0019\u0006\u0003\u0013)\tQ!Y:z]\u000eT!a\u0003\u0007\u0002\u00115\fWO]5dS>T!!\u0004\b\u0002\r\u001dLG\u000f[;c\u0015\u0005y\u0011aA2p[\u000e\u0001\u0001C\u0001\n\u0014\u001b\u0005\u0011a!\u0002\u000b\u0003\u0011\u0003)\"AD'fgN\fw-\u001a#fG>$WM]\n\u0003'Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007\"B\u000f\u0014\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001\u0012\u0011\u001d\u00013C1A\u0005\u0002\u0005\n1\u0001\\8h+\u0005\u0011\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0013aA8sO&\u0011\u0011\u0006\n\u0002\u0007\u0019><w-\u001a:\t\r-\u001a\u0002\u0015!\u0003#\u0003\u0011awn\u001a\u0011\t\u000f5\u001a\"\u0019!C\u0001]\u0005\u0011B)\u001a4bk2$X*\u0019=j[Vl7+\u001b>f+\u0005y\u0003CA\f1\u0013\t\t\u0004DA\u0002J]RDaaM\n!\u0002\u0013y\u0013a\u0005#fM\u0006,H\u000e^'bq&lW/\\*ju\u0016\u0004\u0003bB\u001b\u0014#\u0003%\tAN\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003]R#a\f\u001d,\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0013Ut7\r[3dW\u0016$'B\u0001 \u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0001n\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\r\u0011!\"\u0001\u0001\"\u0014\u0005\u0005\u001b\u0005C\u0001#M\u001b\u0005)%BA\u0002G\u0015\t9\u0005*A\u0004iC:$G.\u001a:\u000b\u0005%S\u0015!\u00028fiRL(\"A&\u0002\u0005%|\u0017BA'F\u0005Q\u0011\u0015\u0010^3U_6+7o]1hK\u0012+7m\u001c3fe\"Aq*\u0011B\u0001B\u0003%\u0001+\u0001\u0006tg2,e.\u00192mK\u0012\u0004\"aF)\n\u0005IC\"a\u0002\"p_2,\u0017M\u001c\u0005\t)\u0006\u0013\t\u0011)A\u0005+\u000691\r[1sg\u0016$\bC\u0001,]\u001b\u00059&B\u0001+Y\u0015\tI&,A\u0002oS>T\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^/\n91\t[1sg\u0016$\b\u0002C0B\u0005\u0003\u0005\u000b\u0011B\u0018\u0002%5\f\u00070[7v[6+7o]1hKNK'0\u001a\u0005\u0006;\u0005#\t!\u0019\u000b\u0005E\u000e$W\r\u0005\u0002\u0013\u0003\")q\n\u0019a\u0001!\")A\u000b\u0019a\u0001+\"9q\f\u0019I\u0001\u0002\u0004y\u0003bB4B\u0005\u0004%I\u0001[\u0001\u0007a\u0006\u00148/\u001a:\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0003\u0002\u000fA\f'o]3sg&\u0011an\u001b\u0002\u0017\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:t%\u0016<\u0017n\u001d;ss\"1\u0001/\u0011Q\u0001\n%\fq\u0001]1sg\u0016\u0014\b\u0005C\u0004s\u0003\u0002\u0007I\u0011B:\u0002\u0015M\u001cHn\u00115fG.,G-F\u0001Q\u0011\u001d)\u0018\t1A\u0005\nY\fab]:m\u0007\",7m[3e?\u0012*\u0017\u000f\u0006\u0002xuB\u0011q\u0003_\u0005\u0003sb\u0011A!\u00168ji\"91\u0010^A\u0001\u0002\u0004\u0001\u0016a\u0001=%c!1Q0\u0011Q!\nA\u000b1b]:m\u0007\",7m[3eA!1q0\u0011C!\u0003\u0003\ta\u0001Z3d_\u0012,GcB<\u0002\u0004\u0005M\u00111\u0005\u0005\b\u0003\u000bq\b\u0019AA\u0004\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002%\u0002\u000f\rD\u0017M\u001c8fY&!\u0011\u0011CA\u0006\u0005U\u0019\u0005.\u00198oK2D\u0015M\u001c3mKJ\u001cuN\u001c;fqRDq!!\u0006\u007f\u0001\u0004\t9\"A\u0001c!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u0011\u00061!-\u001e4gKJLA!!\t\u0002\u001c\t9!)\u001f;f\u0005V4\u0007bBA\u0013}\u0002\u0007\u0011qE\u0001\u0004_V$\bCBA\u0015\u0003_\t\u0019$\u0004\u0002\u0002,)\u0019\u0011Q\u0006.\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003c\tYC\u0001\u0003MSN$\b\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005e\",\u0001\u0003mC:<\u0017\u0002BA\u001f\u0003o\u0011aa\u00142kK\u000e$\b")
public class MessageDecoder
extends ByteToMessageDecoder {
    private final boolean sslEnabled;
    private final int maximumMessageSize;
    private final MessageParsersRegistry parser;
    private boolean sslChecked;

    public static int $lessinit$greater$default$3() {
        return MessageDecoder$.MODULE$.$lessinit$greater$default$3();
    }

    public static int DefaultMaximumSize() {
        return MessageDecoder$.MODULE$.DefaultMaximumSize();
    }

    public static Logger log() {
        return MessageDecoder$.MODULE$.log();
    }

    private MessageParsersRegistry parser() {
        return this.parser;
    }

    private boolean sslChecked() {
        return this.sslChecked;
    }

    private void sslChecked_$eq(boolean x$1) {
        this.sslChecked = x$1;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf b, List<Object> out) {
        if (this.sslEnabled & !this.sslChecked()) {
            byte code = b.readByte();
            this.sslChecked_$eq(true);
            out.add(new SSLResponseMessage(code == 83));
        } else if (b.readableBytes() >= 5) {
            b.markReaderIndex();
            byte code = b.readByte();
            int lengthWithSelf = b.readInt();
            int length = lengthWithSelf - 4;
            if (length < 0) {
                throw new NegativeMessageSizeException(code, length);
            }
            if (length > this.maximumMessageSize) {
                throw new MessageTooLongException(code, length, this.maximumMessageSize);
            }
            if (b.readableBytes() >= length) {
                ServerMessage serverMessage;
                if (MessageDecoder$.MODULE$.log().isTraceEnabled()) {
                    MessageDecoder$.MODULE$.log().trace(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received buffer ", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)code), BufferDumper.dumpAsHex((ByteBuf)b)})));
                }
                byte by = code;
                switch (by) {
                    default: {
                        serverMessage = this.parser().parse(code, b.readSlice(length));
                        break;
                    }
                    case 82: {
                        serverMessage = AuthenticationStartupParser$.MODULE$.parseMessage(b);
                    }
                }
                ServerMessage result2 = serverMessage;
                out.add(result2);
            } else {
                b.resetReaderIndex();
            }
        }
    }

    public MessageDecoder(boolean sslEnabled, Charset charset, int maximumMessageSize) {
        this.sslEnabled = sslEnabled;
        this.maximumMessageSize = maximumMessageSize;
        this.parser = new MessageParsersRegistry(charset);
        this.sslChecked = false;
    }
}

