/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.pool.TimeoutScheduler;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$connect$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$disconnect$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$failQueryPromise$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$holder$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$onReadyForQuery$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$sendPreparedStatement$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$sendQuery$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$setColumnDatas$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$setErrorOnFutures$1;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$lambda$$succeedQueryPromise$1;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.NotificationResponse;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Metrics$;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001ds!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0006)pgR<'/Z*R\u0019\u000e{gN\\3di&|gN\u0003\u0002\u0004\t\u0005Q\u0001o\\:uOJ,7/\u001d7\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"A\u0003bgft7M\u0003\u0002\n\u0015\u0005AQ.Y;sS\u000eLwN\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u000by\u0012aB\"pk:$XM]\u000b\u0002AA\u0011\u0011EK\u0007\u0002E)\u00111\u0005J\u0001\u0007CR|W.[2\u000b\u0005\u00152\u0013AC2p]\u000e,(O]3oi*\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\u0012#AC!u_6L7\rT8oO\"1Q&\u0005Q\u0001\u000e\u0001\n\u0001bQ8v]R,'\u000f\t\u0005\b_E\u0011\r\u0011\"\u00021\u0003A\u0019VM\u001d<feZ+'o]5p].+\u00170F\u00012\u001f\u0005\u0011\u0014%A\u001a\u0002\u001dM,'O^3s?Z,'o]5p]\"1Q'\u0005Q\u0001\u000eE\n\u0011cU3sm\u0016\u0014h+\u001a:tS>t7*Z=!\u0011\u001d9\u0014C1A\u0005\u0006a\n1\u0001\\8h+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000f\u0002\u0007\u0019><w-\u001a:\t\r\t\u000b\u0002\u0015!\u0004:\u0003\u0011awn\u001a\u0011\t\u000f\u0011\u000b\u0012\u0013!C\u0001\u000b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012A\u0012\u0016\u0003\u000f.\u0003\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8oW\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u0003%)hn\u00195fG.,GM\u0003\u0002R-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Ms%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q+EI\u0001\n\u00031\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001XU\tA6\n\u0005\u0002Z96\t!L\u0003\u0002\\\t\u000511m\u001c7v[:L!!\u0018.\u0003+\r{G.^7o\u000b:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"9q,EI\u0001\n\u0003\u0001\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001bU\t\u00117\n\u0005\u0002ZG&\u0011AM\u0017\u0002\u0016\u0007>dW/\u001c8EK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0011\u001d1\u0017#%A\u0005\u0002\u001d\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u00015+\u0005%\\\u0005CA\u000bk\u0013\tYgCA\u0004C_>dW-\u00198\t\u000f5\f\u0012\u0013!C\u0001]\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\u0012a\u001c\u0016\u0003a.\u0003\"!]:\u000e\u0003IT!!\n\f\n\u0005Q\u0014(\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\r\u0011\u0011\"\u0001\u0001<\u0014\rU$r/`A\u0001!\tA80D\u0001z\u0015\tQ(!A\u0003d_\u0012,7-\u0003\u0002}s\na\u0002k\\:uOJ,7+\u0015'D_:tWm\u0019;j_:$U\r\\3hCR,\u0007C\u0001%\u007f\u0013\tyHA\u0001\u0006D_:tWm\u0019;j_:\u0004B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f!\u0011\u0001\u00029p_2LA!a\u0003\u0002\u0006\t\u0001B+[7f_V$8k\u00195fIVdWM\u001d\u0005\n\u0003\u001f)(\u0011!Q\u0001\n\u001d\u000bQbY8oM&<WO]1uS>t\u0007\"CA\nk\n\u0005\t\u0015!\u0003Y\u0003=)gnY8eKJ\u0014VmZ5tiJL\b\"CA\fk\n\u0005\t\u0015!\u0003c\u0003=!WmY8eKJ\u0014VmZ5tiJL\b\"CA\u000ek\n\u0005\t\u0015!\u0003j\u0003U\u0001xn]5uS>t\u0017\r\u001c)be\u0006l\u0007j\u001c7eKJD!\"a\bv\u0005\u000b\u0007I1AA\u0011\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001q\u0011%\t)#\u001eB\u0001B\u0003%\u0001/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002BaaG;\u0005\u0002\u0005%B\u0003DA\u0016\u0003[\ty#!\r\u00024\u0005U\u0002C\u0001\tv\u0011%\ty!a\n\u0011\u0002\u0003\u0007q\tC\u0005\u0002\u0014\u0005\u001d\u0002\u0013!a\u00011\"I\u0011qCA\u0014!\u0003\u0005\rA\u0019\u0005\n\u00037\t9\u0003%AA\u0002%D\u0011\"a\b\u0002(A\u0005\t9\u00019\t\u0013\u0005eRO1A\u0005\n\u0005m\u0012!B4s_V\u0004XCAA\u001f!\u0011\ty$!\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nqa\u00195b]:,GN\u0003\u0003\u0002H\u0005%\u0013!\u00028fiRL(BAA&\u0003\tIw.\u0003\u0003\u0002P\u0005\u0005#AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\t\u0003'*\b\u0015!\u0003\u0002>\u00051qM]8va\u0002B\u0011\"a\u0016v\u0005\u0004%i!!\u0017\u0002#\r|gN\\3di&|g\u000eS1oI2,'/\u0006\u0002\u0002\\A\u0019\u00010!\u0018\n\u0007\u0005}\u0013PA\u000eQ_N$xM]3T#2\u001buN\u001c8fGRLwN\u001c%b]\u0012dWM\u001d\u0005\t\u0003G*\b\u0015!\u0004\u0002\\\u0005\u00112m\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:!\u0011%\t9'\u001eb\u0001\n\u001b\tI'\u0001\u0007dkJ\u0014XM\u001c;D_VtG/\u0006\u0002\u0002lA\u0019Q#!\u001c\n\u0007\u0005=dC\u0001\u0003M_:<\u0007\u0002CA:k\u0002\u0006i!a\u001b\u0002\u001b\r,(O]3oi\u000e{WO\u001c;!\u0011%\t9(\u001eb\u0001\n\u001b\tI(A\rqe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\u001c8i\\;oi\u0016\u0014XCAA>!\r\t\u0013QP\u0005\u0004\u0003\u007f\u0012#!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005\u0002\u0004V\u0004\u000bQBA>\u0003i\u0001(/\u001a9be\u0016$7\u000b^1uK6,g\u000e^:D_VtG/\u001a:!\u0011%\t9)\u001eb\u0001\n\u0013\tI)A\bqCJ\fW.\u001a;feN#\u0018\r^;t+\t\tY\t\u0005\u0005\u0002\u000e\u0006]\u00151TAN\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003+3\u0012AC2pY2,7\r^5p]&!\u0011\u0011TAH\u0005\u001dA\u0015m\u001d5NCB\u0004B!!(\u0002$:\u0019Q#a(\n\u0007\u0005\u0005f#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\u000b9K\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003C3\u0002\u0002CAVk\u0002\u0006I!a#\u0002!A\f'/Y7fi\u0016\u00148\u000b^1ukN\u0004\u0003\"CAXk\n\u0007I\u0011BAY\u0003A\u0001\u0018M]:fIN#\u0018\r^3nK:$8/\u0006\u0002\u00024BA\u0011QRAL\u00037\u000b)\fE\u0002\u0011\u0003oK1!!/\u0003\u0005]\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e%pY\u0012,'\u000f\u0003\u0005\u0002>V\u0004\u000b\u0011BAZ\u0003E\u0001\u0018M]:fIN#\u0018\r^3nK:$8\u000f\t\u0005\n\u0003\u0003,\b\u0019!C\u0005\u0003\u0007\fQ\"Y;uQ\u0016tG/[2bi\u0016$W#A5\t\u0013\u0005\u001dW\u000f1A\u0005\n\u0005%\u0017!E1vi\",g\u000e^5dCR,Gm\u0018\u0013fcR!\u00111ZAi!\r)\u0012QZ\u0005\u0004\u0003\u001f4\"\u0001B+oSRD\u0011\"a5\u0002F\u0006\u0005\t\u0019A5\u0002\u0007a$\u0013\u0007C\u0004\u0002XV\u0004\u000b\u0015B5\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^3eA!I\u00111\\;C\u0002\u0013%\u0011Q\\\u0001\u0011G>tg.Z2uS>tg)\u001e;ve\u0016,\"!a8\u0011\tE\f\t/`\u0005\u0004\u0003G\u0014(a\u0002)s_6L7/\u001a\u0005\t\u0003O,\b\u0015!\u0003\u0002`\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8GkR,(/\u001a\u0011\t\u0013\u0005-X\u000f1A\u0005\n\u0005\r\u0017a\u0003:fG\u0016tG/\u0012:s_JD\u0011\"a<v\u0001\u0004%I!!=\u0002\u001fI,7-\u001a8u\u000bJ\u0014xN]0%KF$B!a3\u0002t\"I\u00111[Aw\u0003\u0003\u0005\r!\u001b\u0005\b\u0003o,\b\u0015)\u0003j\u00031\u0011XmY3oi\u0016\u0013(o\u001c:!\u0011%\tY0\u001eb\u0001\n\u0013\ti0A\u000brk\u0016\u0014\u0018\u0010\u0015:p[&\u001cXMU3gKJ,gnY3\u0016\u0005\u0005}\b#B\u0011\u0003\u0002\t\u0015\u0011b\u0001B\u0002E\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0003\u0016\u0005\u000f\u0011Y!C\u0002\u0003\nY\u0011aa\u00149uS>t\u0007#B9\u0002b\n5\u0001c\u0001%\u0003\u0010%\u0019!\u0011\u0003\u0003\u0003\u0017E+XM]=SKN,H\u000e\u001e\u0005\t\u0005+)\b\u0015!\u0003\u0002\u0000\u00061\u0012/^3ssB\u0013x.\\5tKJ+g-\u001a:f]\u000e,\u0007\u0005C\u0005\u0003\u001aU\u0004\r\u0011\"\u0003\u0003\u001c\u0005a1-\u001e:sK:$\u0018+^3ssV\u0011!Q\u0004\t\u0006+\t\u001d!q\u0004\t\u0007\u0005C\u00119Ca\u000b\u000e\u0005\t\r\"b\u0001B\u0013\t\u00059q-\u001a8fe\u0006d\u0017\u0002\u0002B\u0015\u0005G\u0011\u0001#T;uC\ndWMU3tk2$8+\u001a;\u0011\t\t5\"qG\u0007\u0003\u0005_QAA!\r\u00034\u00059!-Y2lK:$'b\u0001B\u001b\u0005\u0005AQ.Z:tC\u001e,7/\u0003\u0003\u0003:\t=\"\u0001\u0006)pgR<'/Z*R\u0019\u000e{G.^7o\t\u0006$\u0018\rC\u0005\u0003>U\u0004\r\u0011\"\u0003\u0003@\u0005\u00012-\u001e:sK:$\u0018+^3ss~#S-\u001d\u000b\u0005\u0003\u0017\u0014\t\u0005\u0003\u0006\u0002T\nm\u0012\u0011!a\u0001\u0005;A\u0001B!\u0012vA\u0003&!QD\u0001\u000eGV\u0014(/\u001a8u#V,'/\u001f\u0011\t\u0013\t%S\u000f1A\u0005\n\t-\u0013\u0001G2veJ,g\u000e\u001e)sKB\f'/\u001a3Ti\u0006$X-\\3oiV\u0011!Q\n\t\u0006+\t\u001d\u0011Q\u0017\u0005\n\u0005#*\b\u0019!C\u0005\u0005'\nAdY;se\u0016tG\u000f\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002L\nU\u0003BCAj\u0005\u001f\n\t\u00111\u0001\u0003N!A!\u0011L;!B\u0013\u0011i%A\rdkJ\u0014XM\u001c;Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R\u0004\u0003\"\u0003B/k\u0002\u0007I\u0011\u0002B0\u0003\u001d1XM]:j_:,\"A!\u0019\u0011\t\t\r$qM\u0007\u0003\u0005KR!a\n\u0003\n\t\t%$Q\r\u0002\b-\u0016\u00148/[8o\u0011%\u0011i'\u001ea\u0001\n\u0013\u0011y'A\u0006wKJ\u001c\u0018n\u001c8`I\u0015\fH\u0003BAf\u0005cB!\"a5\u0003l\u0005\u0005\t\u0019\u0001B1\u0011!\u0011)(\u001eQ!\n\t\u0005\u0014\u0001\u0003<feNLwN\u001c\u0011\t\u0013\teT\u000f1A\u0005\n\tm\u0014a\u00048pi&4\u0017\u0010T5ti\u0016tWM]:\u0016\u0005\tu\u0004C\u0002B@\u0005\u0003\u0013))D\u0001%\u0013\r\u0011\u0019\t\n\u0002\u0015\u0007>\u0004\u0018p\u00148Xe&$X-\u0011:sCfd\u0015n\u001d;\u0011\u000fU\u00119Ia#\u0002L&\u0019!\u0011\u0012\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003\u0002B\u0017\u0005\u001bKAAa$\u00030\t!bj\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016D\u0011Ba%v\u0001\u0004%IA!&\u0002'9|G/\u001b4z\u0019&\u001cH/\u001a8feN|F%Z9\u0015\t\u0005-'q\u0013\u0005\u000b\u0003'\u0014\t*!AA\u0002\tu\u0004\u0002\u0003BNk\u0002\u0006KA! \u0002!9|G/\u001b4z\u0019&\u001cH/\u001a8feN\u0004\u0003\"\u0003BPk\u0002\u0007I\u0011\u0002BQ\u0003-\tX/\u001a:z%\u0016\u001cX\u000f\u001c;\u0016\u0005\t\r\u0006#B\u000b\u0003\b\t5\u0001\"\u0003BTk\u0002\u0007I\u0011\u0002BU\u0003=\tX/\u001a:z%\u0016\u001cX\u000f\u001c;`I\u0015\fH\u0003BAf\u0005WC!\"a5\u0003&\u0006\u0005\t\u0019\u0001BR\u0011!\u0011y+\u001eQ!\n\t\r\u0016\u0001D9vKJL(+Z:vYR\u0004\u0003b\u0002BZk\u0012\u0005\u00131H\u0001\u000fKZ,g\u000e\u001e'p_B<%o\\;q\u0011\u001d\u00119,\u001eC\u0001\u0003\u0007\fq\"[:SK\u0006$\u0017PR8s#V,'/\u001f\u0005\b\u0005w+H\u0011\u0001B_\u0003\u001d\u0019wN\u001c8fGR,\"Aa0\u0011\tE\u0014\t-`\u0005\u0004\u0005\u0007\u0014(A\u0002$viV\u0014X\rC\u0004\u0003HV$\tE!0\u0002\u0015\u0011L7oY8o]\u0016\u001cG\u000fC\u0004\u0003LV$\tE!4\u0002\u0013=tG+[7f_V$XCAAf\u0011\u001d\u0011\t.\u001eC!\u0003\u0007\f1\"[:D_:tWm\u0019;fI\"9!Q[;\u0005\u0002\t]\u0017!\u00059be\u0006lW\r^3s'R\fG/^:fgV\u0011!\u0011\u001c\t\t\u00057\u0014\t/a'\u0002\u001c6\u0011!Q\u001c\u0006\u0005\u0005?\f\u0019*A\u0005j[6,H/\u00192mK&!!1\u001dBo\u0005\ri\u0015\r\u001d\u0005\b\u0005O,H\u0011\tBu\u0003%\u0019XM\u001c3Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0003l\n5\b#B9\u0003B\n5\u0001\u0002\u0003Bx\u0005K\u0004\r!a'\u0002\u000bE,XM]=\t\u000f\tMX\u000f\"\u0011\u0003v\u0006)2/\u001a8e!J,\u0007/\u0019:fIN#\u0018\r^3nK:$HC\u0002Bv\u0005o\u0014I\u0010\u0003\u0005\u0003p\nE\b\u0019AAN\u0011)\u0011YP!=\u0011\u0002\u0003\u0007!Q`\u0001\u0007m\u0006dW/Z:\u0011\r\t}8qBB\u000b\u001d\u0011\u0019\taa\u0003\u000f\t\r\r1\u0011B\u0007\u0003\u0007\u000bQ1aa\u0002\u000f\u0003\u0019a$o\\8u}%\tq#C\u0002\u0004\u000eY\tq\u0001]1dW\u0006<W-\u0003\u0003\u0004\u0012\rM!aA*fc*\u00191Q\u0002\f\u0011\u0007U\u00199\"C\u0002\u0004\u001aY\u00111!\u00118z\u0011\u001d\u0019i\"\u001eC!\u0007?\tqa\u001c8FeJ|'\u000f\u0006\u0003\u0002L\u000e\u0005\u0002\u0002CB\u0012\u00077\u0001\ra!\n\u0002\u0013\u0015D8-\u001a9uS>t\u0007\u0003\u0002B\u0000\u0007OIAa!\u000b\u0004\u0014\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0007[)H\u0011AAb\u00039A\u0017m\u001d*fG\u0016tG/\u0012:s_JDqa!\rv\t\u0013\u0019\u0019$A\ttKR,%O]8s\u001f:4U\u000f^;sKN$B!a3\u00046!A1qGB\u0018\u0001\u0004\u0019)#A\u0001f\u0011\u001d\u0019Y$\u001eC!\u0007{\tqb\u001c8SK\u0006$\u0017PR8s#V,'/\u001f\u000b\u0003\u0003\u0017Dqa!\bv\t\u0003\u001a\t\u0005\u0006\u0003\u0002L\u000e\r\u0003\u0002CB#\u0007\u007f\u0001\raa\u0012\u0002\u00035\u0004BA!\f\u0004J%!11\nB\u0018\u00051)%O]8s\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019y%\u001eC!\u0007#\n\u0011c\u001c8D_6l\u0017M\u001c3D_6\u0004H.\u001a;f)\u0011\tYma\u0015\t\u0011\r\u00153Q\na\u0001\u0007+\u0002BA!\f\u0004X%!1\u0011\fB\u0018\u0005Y\u0019u.\\7b]\u0012\u001cu.\u001c9mKR,W*Z:tC\u001e,\u0007bBB/k\u0012\u00053qL\u0001\u0012_:\u0004\u0016M]1nKR,'o\u0015;biV\u001cH\u0003BAf\u0007CB\u0001b!\u0012\u0004\\\u0001\u000711\r\t\u0005\u0005[\u0019)'\u0003\u0003\u0004h\t=\"A\u0006)be\u0006lW\r^3s'R\fG/^:NKN\u001c\u0018mZ3\t\u000f\r-T\u000f\"\u0011\u0004n\u0005IqN\u001c#bi\u0006\u0014vn\u001e\u000b\u0005\u0003\u0017\u001cy\u0007\u0003\u0005\u0004F\r%\u0004\u0019AB9!\u0011\u0011ica\u001d\n\t\rU$q\u0006\u0002\u000f\t\u0006$\u0018MU8x\u001b\u0016\u001c8/Y4f\u0011\u001d\u0019I(\u001eC!\u0007w\n\u0001c\u001c8S_^$Um]2sSB$\u0018n\u001c8\u0015\t\u0005-7Q\u0010\u0005\t\u0007\u000b\u001a9\b1\u0001\u0004\u0000A!!QFBA\u0013\u0011\u0019\u0019Ia\f\u0003+I{w\u000fR3tGJL\u0007\u000f^5p]6+7o]1hK\"91qQ;\u0005\n\r%\u0015AD:fi\u000e{G.^7o\t\u0006$\u0018m\u001d\u000b\u0005\u0003\u0017\u001cY\t\u0003\u0005\u0004\u000e\u000e\u0015\u0005\u0019ABH\u0003-\u0019w\u000e\\;n]\u0012\u000bG/Y:\u0011\r\u000555\u0011\u0013B\u0016\u0013\u0011\u0019\u0019*a$\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0007/+H\u0011IBM\u0003ayg.Q;uQ\u0016tG/[2bi&|gNU3ta>t7/\u001a\u000b\u0005\u0003\u0017\u001cY\n\u0003\u0005\u0004\u001e\u000eU\u0005\u0019ABP\u0003\u001diWm]:bO\u0016\u0004BA!\f\u0004\"&!11\u0015B\u0018\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:lUm]:bO\u0016Dqaa*v\t\u0003\u001aI+\u0001\fp]:{G/\u001b4jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0011\tYma+\t\u0011\ru5Q\u0015a\u0001\u0005\u0017Cqaa,v\t\u0003\u0019\t,\u0001\fsK\u001eL7\u000f^3s\u001d>$\u0018NZ=MSN$XM\\3s)\u0011\tYma-\t\u0011\rU6Q\u0016a\u0001\u0005\u000b\u000b\u0001\u0002\\5ti\u0016tWM\u001d\u0005\b\u0007s+H\u0011AB^\u0003a)hN]3hSN$XM\u001d(pi&4\u0017\u0010T5ti\u0016tWM\u001d\u000b\u0005\u0003\u0017\u001ci\f\u0003\u0005\u00046\u000e]\u0006\u0019\u0001BC\u0011\u001d\u0019\t-\u001eC\u0001\u0007{\tAc\u00197fCJtu\u000e^5gs2K7\u000f^3oKJ\u001c\bbBBck\u0012%1qY\u0001\u000bGJ,G-\u001a8uS\u0006dG\u0003BBe\u0007+\u0004Baa3\u0004R6\u00111Q\u001a\u0006\u0005\u0007\u001f\u0014\u0019$\u0001\u0005ge>tG/\u001a8e\u0013\u0011\u0019\u0019n!4\u0003#\r\u0013X\rZ3oi&\fG.T3tg\u0006<W\r\u0003\u0005\u0004X\u000e\r\u0007\u0019ABm\u0003U\tW\u000f\u001e5f]RL7-\u0019;j_:lUm]:bO\u0016\u0004BA!\f\u0004\\&!1Q\u001cB\u0018\u0005y\tU\u000f\u001e5f]RL7-\u0019;j_:\u001c\u0005.\u00197mK:<W-T3tg\u0006<W\r\u0003\u0005\u0004bV\u0004K\u0011BBr\u0003Uqw\u000e\u001e*fC\u0012Lhi\u001c:Rk\u0016\u0014\u00180\u0012:s_J$ba!:\u0004l\u000e=\bcA\u000b\u0004h&\u00191\u0011\u001e\f\u0003\u000f9{G\u000f[5oO\"A1Q^Bp\u0001\u0004\tY*\u0001\u0007feJ|'/T3tg\u0006<W\rC\u0004\u0004r\u000e}\u0007\u0019A5\u0002\tI\f7-\u001a\u0005\b\u0007k,H\u0011AB|\u0003m1\u0018\r\\5eCR,\u0017JZ%u\u0013N\u0014V-\u00193z\r>\u0014\u0018+^3ssR!\u00111ZB}\u0011!\u0019ioa=A\u0002\u0005m\u0005bBB\u007fk\u0012%1q`\u0001\u000em\u0006d\u0017\u000eZ1uKF+XM]=\u0015\t\u0005-G\u0011\u0001\u0005\t\u0005_\u001cY\u00101\u0001\u0002\u001c\"9AQA;\u0005\n\u0011\u001d\u0011\u0001D9vKJL\bK]8nSN,WC\u0001B\u0003\u0011\u001d!Y!\u001eC\u0005\t\u001b\tqb]3u#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003\u0017$y\u0001\u0003\u0005\u0005\u0012\u0011%\u0001\u0019\u0001B\u0006\u0003\u001d\u0001(o\\7jg\u0016Dq\u0001\"\u0006v\t\u0013!9!A\tdY\u0016\f'/U;fef\u0004&o\\7jg\u0016Dq\u0001\"\u0007v\t\u0013!Y\"\u0001\tgC&d\u0017+^3ssB\u0013x.\\5tKR!\u00111\u001aC\u000f\u0011!!y\u0002b\u0006A\u0002\r\u0015\u0012!\u0001;\t\u000f\u0011\rR\u000f\"\u0003\u0005&\u0005\u00192/^2dK\u0016$\u0017+^3ssB\u0013x.\\5tKR!\u00111\u001aC\u0014\u0011!!I\u0003\"\tA\u0002\t5\u0011A\u0002:fgVdG\u000fC\u0004\u0005.U$I\u0001b\f\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\u0005-G\u0011\u0007\u0005\t\u0007;#Y\u00031\u0001\u00054A!11\u001aC\u001b\u0013\u0011!9d!4\u0003\u001b\rc\u0017.\u001a8u\u001b\u0016\u001c8/Y4f\u0011\u001d!Y$\u001eC!\t{\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037C\u0011\u0002\"\u0011v#\u0003%\t\u0005b\u0011\u0002?M,g\u000e\u001a)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u0012\"WMZ1vYR$#'\u0006\u0002\u0005F)\u001a!Q`&")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final boolean positionalParamHolder;
    private final ExecutionContext executionContext;
    private final EventLoopGroup group;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger preparedStatementsCounter;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners;
    private Option<QueryResult> queryResult;
    private AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public AtomicBoolean com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool() {
        return this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool;
    }

    public void com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool_$eq(AtomicBoolean x$1) {
        this.com$github$mauricio$async$db$pool$TimeoutScheduler$$isTimeoutedBool = x$1;
    }

    public boolean isTimeouted() {
        return TimeoutScheduler.class.isTimeouted((TimeoutScheduler)this);
    }

    public <A> Option<ScheduledFuture<?>> addTimeout(Promise<A> promise, Option<Duration> durationOption, ExecutionContext executionContext) {
        return TimeoutScheduler.class.addTimeout((TimeoutScheduler)this, promise, durationOption, (ExecutionContext)executionContext);
    }

    public ScheduledFuture<?> schedule(Function0<BoxedUnit> block, Duration duration) {
        return TimeoutScheduler.class.schedule((TimeoutScheduler)this, block, (Duration)duration);
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.class.inTransaction((Connection)this, f, (ExecutionContext)executionContext);
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private EventLoopGroup group() {
        return this.group;
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    private final AtomicInteger preparedStatementsCounter() {
        return this.preparedStatementsCounter;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    private HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    private Promise<Connection> connectionFuture() {
        return this.connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners() {
        return this.notifyListeners;
    }

    private void notifyListeners_$eq(CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> x$1) {
        this.notifyListeners = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.group();
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onComplete((Function1)new PostgreSQLConnection$lambda$$connect$1(this), this.executionContext());
        return this.connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1)new PostgreSQLConnection$lambda$$disconnect$1(this), this.executionContext());
    }

    public void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.$conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        return Metrics$.MODULE$.stat(query, (Function0)new PostgreSQLConnection$lambda$$sendQuery$1(this, query));
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        return Metrics$.MODULE$.stat(query, (Function0)new PostgreSQLConnection$lambda$$sendPreparedStatement$1(this, query, values));
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (this.connectionFuture().isCompleted()) {
            future = BoxedUnit.UNIT;
        } else {
            this.connectionFuture().failure(e);
            future = this.disconnect();
        }
        this.currentPreparedStatement().map((Function1)new PostgreSQLConnection$lambda$$setErrorOnFutures$1(this));
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1)new PostgreSQLConnection$lambda$$onReadyForQuery$1(this));
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", (Object)m);
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        this.parameterStatus().put((Object)m.key(), (Object)m.value());
        if ("server_version".equals(m.key())) {
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[Predef$.MODULE$.refArrayOps((Object[])m.values()).size()];
        int x = 0;
        while (true) {
            Object object;
            if (x >= Predef$.MODULE$.refArrayOps((Object[])m.values()).size()) {
                ((MutableResultSet)this.currentQuery().get()).addRow(items);
                return;
            }
            ByteBuf buf = m.values()[x];
            if (buf == null) {
                object = null;
            } else {
                try {
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                    object = this.decoderRegistry.decode((ColumnData)columnType, buf, this.configuration.charset());
                }
                catch (Throwable throwable) {
                    void var4_4;
                    var4_4.release();
                    throw throwable;
                }
                buf.release();
            }
            items[x] = object;
            ++x;
        }
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet(m.columnDatas())));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(ArrayBuffer<PostgreSQLColumnData> columnDatas) {
        this.currentPreparedStatement().foreach((Function1)new PostgreSQLConnection$lambda$$setColumnDatas$1(columnDatas));
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage;
        block5: {
            block3: {
                block4: {
                    block2: {
                        authenticationMessage = message;
                        if (!(authenticationMessage instanceof AuthenticationOkMessage)) break block2;
                        PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
                        this.authenticated_$eq(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(authenticationMessage instanceof AuthenticationChallengeCleartextMessage)) break block4;
                    AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
                    this.write(this.credential(authenticationChallengeCleartextMessage));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(authenticationMessage instanceof AuthenticationChallengeMD5)) break block5;
                AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
                this.write(this.credential(authenticationChallengeMD5));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)authenticationMessage);
    }

    @Override
    public void onNotificationResponse(NotificationResponse message) {
        Iterator<Function1<NotificationResponse, BoxedUnit>> iterator = this.notifyListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().apply((Object)message);
        }
    }

    public void registerNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().add(listener);
    }

    public void unregisterNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().remove(listener);
    }

    public void clearNotifyListeners() {
        this.notifyListeners().clear();
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() != null && this.configuration.password().isDefined()) {
            return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
        }
        throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            return;
        }
        throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1)new PostgreSQLConnection$lambda$$failQueryPromise$1(t));
    }

    private void succeedQueryPromise(QueryResult result2) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1)new PostgreSQLConnection$lambda$$succeedQueryPromise$1(result2));
    }

    private void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "{counter=", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToLong((long)this.currentCount())}));
    }

    public final /* synthetic */ Object com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$1(Try x0$1) {
        Object object;
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            object = BoxesRunTime.boxToBoolean((boolean)this.connectionFuture().tryFailure(e));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public final /* synthetic */ PostgreSQLConnection com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$2(PostgreSQLConnectionHandler c) {
        return this;
    }

    public final /* synthetic */ Future com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$3(String query$1) {
        this.validateQuery(query$1);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query$1));
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public final /* synthetic */ PreparedStatementHolder com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$5(String query$2) {
        return new PreparedStatementHolder(query$2, this.preparedStatementsCounter().incrementAndGet(), this.positionalParamHolder);
    }

    public final /* synthetic */ Future com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$4(String query$2, Seq values$1) {
        PreparedStatementMessage preparedStatementMessage;
        this.validateQuery(query$2);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        PreparedStatementHolder holder2 = (PreparedStatementHolder)this.parsedStatements().getOrElseUpdate((Object)query$2, (Function0)new PostgreSQLConnection$lambda$$holder$1(this, query$2));
        if (holder2.paramsCount() != values$1.length()) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder2.paramsCount(), values$1);
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder2));
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet(holder2.columnDatas())));
        if (holder2.prepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder2.statementId(), holder2.realQuery(), (Seq<Object>)values$1, this.encoderRegistry);
        } else {
            holder2.prepared_$eq(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder2.statementId(), holder2.realQuery(), (Seq<Object>)values$1, this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        this.addTimeout(promise, (Option<Duration>)this.configuration.queryTimeout(), this.executionContext());
        return promise.future();
    }

    public final /* synthetic */ Option com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$6(PreparedStatementHolder p) {
        return this.parsedStatements().remove((Object)p.query());
    }

    public final /* synthetic */ void com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$7(QueryResult result2) {
        this.succeedQueryPromise(result2);
    }

    public static final /* synthetic */ void com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$8(ArrayBuffer columnDatas$1, PreparedStatementHolder holder2) {
        holder2.columnDatas_$eq((ArrayBuffer<PostgreSQLColumnData>)columnDatas$1);
    }

    public static final /* synthetic */ Promise com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$9(Throwable t$1, Promise promise) {
        PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", (Object)promise);
        return promise.failure(t$1);
    }

    public static final /* synthetic */ Promise com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$$anonfun$10(QueryResult result$1, Promise x$1) {
        return x$1.success((Object)result$1);
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, boolean positionalParamHolder, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.positionalParamHolder = positionalParamHolder;
        this.executionContext = executionContext;
        Connection.class.$init$((Connection)this);
        TimeoutScheduler.class.$init$((TimeoutScheduler)this);
        this.group = configuration.eventLoopGroup();
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, this.group(), executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.preparedStatementsCounter = new AtomicInteger();
        this.parameterStatus = new HashMap();
        this.parsedStatements = new HashMap();
        this.authenticated = false;
        this.connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.notifyListeners = new CopyOnWriteArrayList();
        this.queryResult = None$.MODULE$;
    }
}

