/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.column;

import com.github.mauricio.async.db.column.ColumnDecoder;
import com.github.mauricio.async.db.column.ColumnEncoder;
import com.github.mauricio.async.db.column.ColumnEncoderDecoder;
import com.github.mauricio.async.db.exceptions.DateEncoderNotAvailableException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.postgresql.column.PostgreSQLIntervalEncoderDecoder$lambda$$i$1;
import com.github.mauricio.async.db.util.Log$;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class PostgreSQLIntervalEncoderDecoder$
implements ColumnEncoderDecoder {
    public static final PostgreSQLIntervalEncoderDecoder$ MODULE$;
    private final Logger log;
    private final PeriodFormatter formatter;
    private final PeriodFormatter postgres_verboseParser;
    private final PeriodFormatter hmsParser;
    private final PeriodFormatter postgresParser;
    private final PeriodFormatter sqlDTParser;
    private final PeriodFormatter sqlParser;

    static {
        new PostgreSQLIntervalEncoderDecoder$();
    }

    public Object decode(ColumnData kind, ByteBuf value, Charset charset) {
        return ColumnDecoder.class.decode((ColumnDecoder)this, (ColumnData)kind, (ByteBuf)value, (Charset)charset);
    }

    public boolean supportsStringDecoding() {
        return ColumnDecoder.class.supportsStringDecoding((ColumnDecoder)this);
    }

    private Logger log() {
        return this.log;
    }

    private PeriodFormatter formatter() {
        return this.formatter;
    }

    public String encode(Object value) {
        block4: {
            String string;
            block3: {
                Object object;
                block2: {
                    object = value;
                    if (!(object instanceof ReadablePeriod)) break block2;
                    ReadablePeriod readablePeriod = (ReadablePeriod)object;
                    string = this.formatter().print(readablePeriod);
                    break block3;
                }
                if (!(object instanceof ReadableDuration)) break block4;
                ReadableDuration readableDuration = (ReadableDuration)object;
                string = readableDuration.toString();
            }
            return string;
        }
        throw new DateEncoderNotAvailableException(value);
    }

    private PeriodFormatterBuilder postgresYMDBuilder(PeriodFormatterBuilder builder) {
        return builder.appendYears().appendSuffix(" year", " years").appendSeparator(" ").appendMonths().appendSuffix(" mon", " mons").appendSeparator(" ").appendDays().appendSuffix(" day", " days").appendSeparator(" ");
    }

    private PeriodFormatter postgres_verboseParser() {
        return this.postgres_verboseParser;
    }

    private PeriodFormatterBuilder postgresHMSBuilder(PeriodFormatterBuilder builder) {
        return builder.rejectSignedValues(true).appendHours().appendSuffix(":").appendMinutes().appendSuffix(":").appendSecondsWithOptionalMillis();
    }

    private PeriodFormatter hmsParser() {
        return this.hmsParser;
    }

    private PeriodFormatter postgresParser() {
        return this.postgresParser;
    }

    private PeriodFormatterBuilder sqlDTBuilder(PeriodFormatterBuilder builder) {
        return this.postgresHMSBuilder(builder.appendDays().appendSeparator(" "));
    }

    private PeriodFormatter sqlDTParser() {
        return this.sqlDTParser;
    }

    private PeriodFormatter sqlParser() {
        return this.sqlParser;
    }

    public Period decode(String value) {
        Period period;
        if (value.isEmpty()) {
            period = Period.ZERO;
        } else {
            PeriodFormatter format;
            int i2;
            PeriodFormatter periodFormatter = ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0))).equals(BoxesRunTime.boxToCharacter((char)'P')) ? this.formatter() : (value.startsWith("@ ") ? this.postgres_verboseParser() : ((i2 = new StringOps(Predef$.MODULE$.augmentString(value)).indexWhere((Function1)new PostgreSQLIntervalEncoderDecoder$lambda$$i$1(), new StringOps(Predef$.MODULE$.augmentString("-+")).contains((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0))) ? 1 : 0)) < 0 || new StringOps(Predef$.MODULE$.augmentString(":.")).contains((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i2))) ? this.hmsParser() : (((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i2))).equals(BoxesRunTime.boxToCharacter((char)'-')) ? this.sqlParser() : (format = ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i2))).equals(BoxesRunTime.boxToCharacter((char)' ')) && i2 + 1 < value.length() && RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), i2 + 1))) ? this.sqlDTParser() : this.postgresParser()))));
            period = format == this.hmsParser() && ((Object)BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), 0))).equals(BoxesRunTime.boxToCharacter((char)'-')) ? format.parsePeriod(value.substring(1)).negated() : (value.endsWith(" ago") ? format.parsePeriod(new StringOps(Predef$.MODULE$.augmentString(value)).stripSuffix(" ago")).negated() : format.parsePeriod(value));
        }
        return period;
    }

    public static final /* synthetic */ boolean com$github$mauricio$async$db$postgresql$column$PostgreSQLIntervalEncoderDecoder$$$anonfun$1(char x$1) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$1));
    }

    private PostgreSQLIntervalEncoderDecoder$() {
        MODULE$ = this;
        ColumnEncoder.class.$init$((ColumnEncoder)this);
        ColumnDecoder.class.$init$((ColumnDecoder)this);
        this.log = Log$.MODULE$.getByName(this.getClass().getName());
        this.formatter = ISOPeriodFormat.standard();
        this.postgres_verboseParser = this.postgresYMDBuilder(new PeriodFormatterBuilder().appendLiteral("@ ")).appendHours().appendSuffix(" hour", " hours").appendSeparator(" ").appendMinutes().appendSuffix(" min", " mins").appendSeparator(" ").appendSecondsWithOptionalMillis().appendSuffix(" sec", " secs").toFormatter();
        this.hmsParser = this.postgresHMSBuilder(new PeriodFormatterBuilder()).toFormatter();
        this.postgresParser = this.postgresHMSBuilder(this.postgresYMDBuilder(new PeriodFormatterBuilder())).toFormatter();
        this.sqlDTParser = this.sqlDTBuilder(new PeriodFormatterBuilder()).toFormatter();
        this.sqlParser = this.sqlDTBuilder(new PeriodFormatterBuilder().printZeroAlways().rejectSignedValues(true).appendYears().appendSeparator("-").appendMonths().rejectSignedValues(false).printZeroNever().appendSeparator(" ")).toFormatter();
    }
}

